# @package SobiPro multi-directory component with content construction support
# @author
# Name: Sigrid Suski & Radek Suski, Sigsiu.NET GmbH
# Url: https://www.Sigsiu.NET
# @copyright Copyright (C) 2006–2024 Sigsiu.NET GmbH (https://www.sigsiu.net). All rights reserved.
# @license GNU/GPL Version 3
# This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License version 3
# as published by the Free Software Foundation, and under the additional terms according section 7 of GPL v3.
# See https://www.gnu.org/licenses/gpl.html and https://www.sigsiu.net/licenses.
# This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
# @modified 02 October 2024 by Sigrid Suski
# EXAMPLE DATA
# ------------

# insert categories (sid 2 to 36)
INSERT IGNORE INTO `#__sobipro_category`( `id`, `section`, `position`, `param1`, `parseDesc`, `param2`, `showIntrotext`, `icon`, `showIcon`, `allFields`, `entryFields` )
VALUES
( 2, 1, 1, '', '0', '', '2', '{\'element\':\'span\',\'class\':\'fas fa-desktop\',\'font\':\'font-awesome-5\'}', '2', 1, '' ),
( 3, 1, 2, '', '0', '', '2', '{\'element\':\'span\',\'class\':\'fas fa-gamepad\',\'font\':\'font-awesome-5\'}', '2', 1, '' ),
( 4, 1, 3, '', '0', '', '2', '{\'element\':\'span\',\'class\':\'fas fa-medkit\',\'font\':\'font-awesome-5\'}', '2', 1, '' ),
( 5, 1, 4, '', '0', '', '2', '{\'element\':\'span\',\'class\':\'fas fa-home\',\'font\':\'font-awesome-5\'}', '2', 1, '' ),
( 6, 1, 5, '', '0', '', '2', '{\'element\':\'span\',\'class\':\'fas fa-rss-square\',\'font\':\'font-awesome-5\'}', '2', 1, '' ),
( 7, 1, 6, '', '0', '', '2', '{\'element\':\'span\',\'class\':\'fas fa-shopping-cart\',\'font\':\'font-awesome-5\'}', '2', 1, '' ),
( 8, 1, 1, '', '0', '', '2', '{\'element\':\'span\',\'class\':\'fas fa-volume-up\',\'font\':\'font-awesome-5\'}', '2', 1, '' ),
( 9, 1, 2, '', '0', '', '2', '{\'element\':\'span\',\'class\':\'fas fa-images\',\'font\':\'font-awesome-5\'}', '2', 1, '' ),
( 10, 1, 3, '', '0', '', '2', '{\'element\':\'span\',\'class\':\'fas fa-keyboard\',\'font\':\'font-awesome-5\'}', '2', 1, '' ),
( 11, 1, 4, '', '0', '', '2', '{\'element\':\'span\',\'class\':\'fas fa-laptop\',\'font\':\'font-awesome-5\'}', '2', 1, '' ),
( 12, 1, 5, '', '0', '', '2', '{\'element\':\'span\',\'class\':\'fas fa-tablet\',\'font\':\'font-awesome-5\'}', '2', 1, '' ),
( 14, 1, 1, '', '0', '', '2', '{\'element\':\'span\',\'class\':\'fas fa-dice\',\'font\':\'font-awesome-5\'}', '2', 1, '' ),
( 15, 1, 2, '', '0', '', '2', '{\'element\':\'span\',\'class\':\'fas fa-bug\',\'font\':\'font-awesome-5\'}', '2', 1, '' ),
( 16, 1, 3, '', '0', '', '2', '{\'element\':\'span\',\'class\':\'fas fa-puzzle-piece\',\'font\':\'font-awesome-5\'}', '2', 1, '' ),
( 17, 1, 4, '', '0', '', '2', '{\'element\':\'span\',\'class\':\'fas fa-video\',\'font\':\'font-awesome-5\'}', '2', 1, '' ),
( 18, 1, 1, '', '0', '', '2', '{\'element\':\'span\',\'class\':\'far fa-grin\',\'font\':\'font-awesome-5\'}', '2', 1, '' ),
( 19, 1, 2, '', '0', '', '2', '{\'element\':\'span\',\'class\':\'fas fa-male\',\'font\':\'font-awesome-5\'}', '2', 1, '' ),
( 20, 1, 3, '', '0', '', '2', '{\'element\':\'span\',\'class\':\'fas fa-flask\',\'font\':\'font-awesome-5\'}', '2', 1, '' ),
( 21, 1, 4, '', '0', '', '2', '{\'element\':\'span\',\'class\':\'fas fa-sort-amount-down\',\'font\':\'font-awesome-5\'}', '2', 1, '' ),
( 22, 1, 5, '', '0', '', '2', '{\'element\':\'span\',\'class\':\'fas fa-wrench\',\'font\':\'font-awesome-5\'}', '2', 1, '' ),
( 23, 1, 6, '', '0', '', '2', '{\'element\':\'span\',\'class\':\'fas fa-truck\',\'font\':\'font-awesome-5\'}', '2', 1, '' ),
( 24, 1, 7, '', '0', '', '2', '{\'element\':\'span\',\'class\':\'fas fa-money-bill-wave\',\'font\':\'font-awesome-5\'}', '2', 1, '' ),
( 25, 1, 8, '', '0', '', '2', '{\'element\':\'span\',\'class\':\'fas fa-dove\',\'font\':\'font-awesome-5\'}', '2', 1, '' ),
( 26, 1, 9, '', '0', '', '2', '{\'element\':\'span\',\'class\':\'fas fa-comments\',\'font\':\'font-awesome-5\'}', '2', 1, '' ),
( 27, 1, 10, '', '0', '', '2', '{\'element\':\'span\',\'class\':\'fas fa-calendar\',\'font\':\'font-awesome-5\'}', '2', 1, '' ),
( 28, 1, 11, '', '0', '', '2', '{\'element\':\'span\',\'class\':\'fas fa-file-alt\',\'font\':\'font-awesome-5\'}', '2', 1, '' ),
( 29, 1, 12, '', '0', '', '2', '{\'element\':\'span\',\'class\':\'fas fa-tv\',\'font\':\'font-awesome-5\'}', '2', 1, '' ),
( 30, 1, 13, '', '0', '', '2', '{\'element\':\'span\',\'class\':\'fas fa-sun\',\'font\':\'font-awesome-5\'}', '2', 1, '' ),
( 31, 1, 2, '', '0', '', '2', '{\'element\':\'span\',\'class\':\'fas fa-book\',\'font\':\'font-awesome-5\'}', '2', 1, '' ),
( 32, 1, 3, '', '0', '', '2', '{\'element\':\'span\',\'class\':\'fas fa-music\',\'font\':\'font-awesome-5\'}', '2', 1, '' ),
( 33, 1, 4, '', '0', '', '2', '{\'element\':\'span\',\'class\':\'fas fa-rocket\',\'font\':\'font-awesome-5\'}', '2', 1, '' ),
( 34, 1, 5, '', '0', '', '2', '{\'element\':\'span\',\'class\':\'fas fa-home\',\'font\':\'font-awesome-5\'}', '2', 1, '' ),
( 35, 1, 1, '', '0', '', '2', '{\'element\':\'span\',\'class\':\'fas fa-truck\',\'font\':\'font-awesome-5\'}', '2', 1, '' ),
( 36, 1, 1, '', '0', '', '2', '{\'element\':\'span\',\'class\':\'fas fa-car\',\'font\':\'font-awesome-5\'}', '2', 1, '' );

# insert section settings
INSERT IGNORE INTO `#__sobipro_config`( `sKey`, `sValue`, `section`, `critical`, `cSection` )
VALUES
( 'allowed_attributes_array',
  'YTo4OntpOjA7czo1OiJjbGFzcyI7aToxO3M6MjoiaWQiO2k6MjtzOjU6InN0eWxlIjtpOjM7czo0OiJocmVmIjtpOjQ7czozOiJzcmMiO2k6NTtzOjQ6Im5hbWUiO2k6NjtzOjM6ImFsdCI7aTo3O3M6NToidGl0bGUiO30=', 1, 0,
  'html' ),
( 'allowed_tags_array',
  'YToxNzp7aTowO3M6MToiYSI7aToxO3M6MToicCI7aToyO3M6MjoiYnIiO2k6MztzOjI6ImhyIjtpOjQ7czozOiJkaXYiO2k6NTtzOjI6ImxpIjtpOjY7czoyOiJ1bCI7aTo3O3M6NDoic3BhbiI7aTo4O3M6NToidGFibGUiO2k6OTtzOjI6InRyIjtpOjEwO3M6MjoidGQiO2k6MTE7czozOiJpbWciO2k6MTI7czoyOiJoMSI7aToxMztzOjI6ImgyIjtpOjE0O3M6MjoiaDMiO2k6MTU7czoyOiJoNCI7aToxNjtzOjI6Img1Ijt9',
  1, 0, 'html' ),
( 'always_add_entryinput', '0', 1, 0, 'meta' ),
( 'always_add_search', '0', 1, 0, 'meta' ),
( 'always_add_section', '0', 1, 0, 'meta' ),
( 'cat_desc', '0', 1, 0, 'list' ),
( 'cat_full', '0', 1, 0, 'list' ),
( 'cat_meta', '0', 1, 0, 'list' ),
( 'catdependent', '0', 1, 0, 'alphamenu' ),
( 'categories_in_line', '2', 1, 0, 'list' ),
( 'categories_ordering', 'name.asc', 1, 0, 'list' ),
( 'category_access_enabled', '0', 1, 0, 'redirects' ),
( 'category_access_msg', 'UNAUTHORIZED_ACCESS', 1, 0, 'redirects' ),
( 'category_access_msgtype', 'info', 1, 0, 'redirects' ),
( 'entries_limit', '1', 1, 0, 'list' ),
( 'entries_ordering', 'updatedTime.desc', 1, 0, 'list' ),
( 'entries_ordering', 'disabled', 1, 0, 'search' ),
( 'entry_access_enabled', '0', 1, 0, 'redirects' ),
( 'entry_access_msg', 'UNAUTHORIZED_ACCESS', 1, 0, 'redirects' ),
( 'entry_access_msgtype', 'info', 1, 0, 'redirects' ),
( 'entry_add_enabled', '0', 1, 0, 'redirects' ),
( 'entry_add_msg', 'UNAUTHORIZED_ACCESS', 1, 0, 'redirects' ),
( 'entry_add_msgtype', 'info', 1, 0, 'redirects' ),
( 'entry_cats', '1', 1, 0, 'list' ),
( 'entry_meta', '0', 1, 0, 'list' ),
( 'entry_save_enabled', '0', 1, 0, 'redirects' ),
( 'entry_save_msg', 'EN.ENTRY_SAVED_NA', 1, 0, 'redirects' ),
( 'entry_save_msgtype', 'info', 1, 0, 'redirects' ),
( 'export-directory', '0ae414bd13f809cc9e309964db7982e2', 1, 0, 'imex' ),
( 'extra_fields_array', 'YToyOntpOjA7czoxOiIyIjtpOjE7czoxOiI0Ijt9', 1, 0, 'alphamenu' ),
( 'fields_array', 'YTo0OntpOjA7czoxNDoiZmllbGRfbmFtZS5hc2MiO2k6MTtzOjE1OiJmaWVsZF9uYW1lLmRlc2MiO2k6MjtzOjEyOiJjb3VudGVyLmRlc2MiO2k6MztzOjE2OiJjcmVhdGVkVGltZS5kZXNjIjt9', 1, 0,
  'ordering' ),
( 'fields_array', '', 1, 0, 'sordering' ),
( 'framework-load', '1', 1, 0, 'template' ),
( 'framework-style', '5', 1, 0, 'template' ),
( 'highlight-search', '0', 1, 0, 'search' ),
( 'wildcard-search', '1', 1, 0, 'search' ),
( 'icon_fonts_arr', '', 0, 0, 'template' ),
( 'icon_fonts_arr', 'YToxOntpOjA7czoxNDoiZm9udC1hd2Vzb21lLTUiO30=', 1, 0, 'template' ),
( 'icon_fonts_load', '1', 1, 0, 'template' ),
( 'iconsize', '2', 1, 0, 'category' ),
( 'jquery-load', '1', 1, 0, 'template' ),
( 'letters', 'A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z,0-9', 1, 0, 'alphamenu' ),
( 'maxCats', '5', 1, 0, 'entry' ),
( 'name_field', '1', 1, 0, 'entry' ),
( 'num_subcats', '6', 1, 0, 'list' ),
( 'parse_desc', '0', 1, 0, 'category' ),
( 'parse_template_content', '0', 1, 0, 'general' ),
( 'primary_field', '1', 1, 0, 'alphamenu' ),
( 'publish_limit', '', 1, 0, 'entry' ),
( 'search_ordering', 'priority', 1, 0, 'search' ),
( 'section_access_enabled', '0', 1, 0, 'redirects' ),
( 'section_access_msg', 'UNAUTHORIZED_ACCESS', 1, 0, 'redirects' ),
( 'section_access_msgtype', 'info', 1, 0, 'redirects' ),
( 'section_msg', 'UNAUTHORIZED_ACCESS', 1, 0, 'redirects' ),
( 'section_search_enabled', '0', 1, 0, 'redirects' ),
( 'section_search_msg', 'UNAUTHORIZED_ACCESS', 1, 0, 'redirects' ),
( 'section_search_msgtype', 'info', 1, 0, 'redirects' ),
( 'separator', '', 1, 0, 'meta' ),
( 'show', '1', 1, 0, 'alphamenu' ),
( 'show_desc', '1', 1, 0, 'category' ),
( 'show_icon', '1', 1, 0, 'category' ),
( 'show_intro', '1', 1, 0, 'category' ),
( 'subcats', '1', 1, 0, 'list' ),
( 'subcats_ordering', 'name.asc', 1, 0, 'list' ),
( 'supportold', '0', 1, 0, 'template' ),
( 'template', 'default8', 1, 0, 'section' ),
( 'top_menu', '1', 1, 0, 'general' ),
( 'verify', '1', 1, 0, 'alphamenu' ),
( 'versioning', '1', 1, 0, 'entry' ),
( 'versioningAdminBehaviour', '1', 1, 0, 'entry' ),
( 'xml_ip', '', 1, 0, 'debug' ),
( 'xml_raw', '0', 1, 0, 'debug' );

# insert fields (fid 1 to 17)
INSERT IGNORE INTO `#__sobipro_field`( `fid`, `nid`, `adminField`, `admList`, `dataType`, `enabled`, `fee`, `fieldType`, `filter`, `isFree`, `position`,
                                       `priority`, `required`, `section`, `multiLang`, `uniqueData`, `validate`, `addToMetaDesc`, `addToMetaKeys`, `editLimit`,
                                       `editable`, `showIn`, `allowedAttributes`, `allowedTags`, `editor`, `inSearch`, `withLabel`, `cssClass`, `parse`,
                                       `template`, `notice`, `params`, `defaultValue`, `version` )
VALUES
( 1, 'field_name', 0, 0, 0, 1, 0, 'inbox', '0', 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, -1, 1, 'both', '', '', '', 1, 0, 'spClassInbox', 0, '', '',
  'bVHBTsMwDP0VlC9oB1tHdkLAAWlIiEnj7LZeGylNojjVhhD/TpI2bQecHL/37NjPwFcZ/yKerzgjBFu1r+haXbMd8YKzBhVakCHbciYcdsZqE9KMsxBCXYvSGE3CCa0CtuasRKnPkfc66psGyQnVRISzPMZbz7T6/FwLtwdfwHaC5yPRoYMDGrDgtB2rbkK89xxc9qga14bca/N1Ns5XET1KIEqDkYnpiyr1JWFJcxQ4DLiZdAGatXez9hCNieh2Ug/gv73DSr96B2jSemNL+hD1sIJfrUiGlGPbJblJH8vg0gO9Saiw1bJGe+Wnf6Cq7KdxT+BgpJI1J6nhzwWKdPN3UA0eQfZIi9t6r08WMZLLdsGaXjkLiqT/qZRXrG+q+g6tqGb0+wc=',
  '', 1 ),
( 2, 'field_zip', 0, 0, 0, 1, 0, 'inbox', 'alphanum', 1, 7, 10, 0, 1, 0, 0, 0, 0, 1, -1, 1, 'details', '', '', '', 0, 0, 'spClassInbox', 0, '', '',
  'bVLBbsIwDP0VlPMOLYzBwmnadpjEpAkkdnZb00YKSRSngmnav88JTRlipzjvPcf2c0BOC/lNspxKQQi+7t4xdLYRK5JzKTyYFmO8lEIFPDhvXbwWUsQjZnWonbOkgrJmyKpQ22PiWUd92yIFZdqESFGmc8ZMZ4+vjQpr4ASxUrIYiAMG2KIDD8H6qOYyd5MYPDIJpzWaNnTxzuJyXgwN1kTPGohyZ+TS9c1U9pSxrNkpTB1O56MuQkk74XFCbZs0eHl/SdomgxK6HNPO4L9F4nAJexjVERq1C7aKPlVznoWtmWVrquHZW5IL6+jXE31oqLGzukF/5SwHaGr/5cILBBio7NFeW7jZxSLvfhPXvQPdI/3ZMpu+94ib/BfGPLamN4H/CGmuVOkrlh81/QG9qi8t/PwC',
  '', 1 ),
( 3, 'field_city', 0, 0, 0, 1, 0, 'inbox', '0', 1, 8, 4, 1, 1, 0, 0, 0, 0, 0, -1, 1, 'details', '', '', '', 1, 0, 'spClassInbox', 0, '', '',
  'bVHLbsIwEPwV5C8IlFfNqaI9VKJSVSR63jhLYsnYlncjQFX/vbZJAoie1jsz+xqDnBTyh+R4IgUhBNV8IDeuEiuS8wQZVJySpRSa8eCD8yktpEghlTVovHekWTubsJkUJRp3zHzUUVvXSKxtnREpxjk+RaZxx7dK8wZigVhpWXTEARm26CEAu9BVjVJ8jhycNmhrblIeteNZ0e2niNYGiPrFyOf03Zbu1GO9ZqcxLziZDroEZe1IaT6PsM0102vNNvuT0eVQdQH/nZFOy9h8UCdo0C6iUfStq8sp8cR5b0zZtX0k42CT3HqhTwMKG2cqDHe+xgdaFc6eX4Gho3qL9sbBw08s+q//AlvjDkyLdPPH0fN9QMzkbbtkTWs5gCUTJ5Xmjo1NbXvAoNUV/f0D',
  '', 1 ),
( 4, 'field_contact', 0, 0, 0, 1, 0, 'inbox', '0', 1, 11, 8, 0, 1, 0, 0, 0, 0, 0, -1, 1, 'details', '', '', '', 0, 1, 'spClassInbox', 0, '', '',
  'bVHbTsMwDP0VlC9oB2Mje0LAA9KQEJPGs5t6baQ0iRJXG0L8O0562bg8OT7n2LGPQS4K+RlluZAiIgTVviC1rhabKFdSNGgxgEnZWgpN2Png/EgqZwkUpSyVt2i8d1GTdjZhSykqNO6Y+YLb902DkbRtMiJFkeM1M607PtWatsAFYqNlMRIdEuzQQwByYay6SvGOOTht0TbUppy1ZVGMY6oYHwzEOA0WfU6fbeVOEzZp9hqHAW9nXYLO2puzdpf9yeh6Vg/gv73TSr96J2jWsoVVfNf1sAKvtpwMqca2f0n+2CSX7uOrAYWtMzVOzpQ58gOtCh+eHoHg0mquPRgHFxcYKlbT6d/ANrgH02P2jm82en0IiJn8cTm2prcUwEbDP1UGL7tyU9t3GLQ613x9Aw==',
  '', 1 ),
( 5, 'field_phone', 0, 0, 0, 1, 0, 'inbox', 'phone', 1, 12, 10, 0, 1, 0, 0, 0, 0, 0, -1, 1, 'details', '', '', '', 0, 0, 'spClassInbox', 0, '', '',
  'bVHbTgIxEP0V0i9YEATLk0EfTDAxkuDz7O6wbVLaptMNGOO/O+3eMPrUzjlz5nIG5KKQXyTnCykIIVTqFaNytdiSXEvRoMUAJkUbKXTEsw/Op3AlhVfOYvonsULjvSMdtbM9X6Jxl8wXXLxtGqSobZMRKYr83jGj3OW51nEPLBBbLYueOGOEA3oIEF3oVbP0PjAH1z3aJqoUc/tV0c9YEe0MEA1zkc/hiy3ddcCGnKPGPN9iyktQzp1N2y0nxSFblNHNqOnAfzukvTJ2P2YnaMxli0v60HW3B++3HFwp+7J/SW5sklWP9GagQuVMjYM98/zyB20VPn18ggi3frP2ZBzcnKFTrIfrv4Nt8AimxewgH643/BQQM/nrfGxNa2MAS4Y7lQZvq3JR254x6GpCv38A',
  '', 1 ),
( 6, 'field_fax', 0, 0, 0, 1, 0, 'inbox', 'phone', 1, 13, 10, 0, 1, 0, 0, 0, 0, 0, -1, 1, 'details', '', '', '', 0, 0, 'spClassInbox', 0, '', '',
  'bVFBTsMwEPxK5RekoaXFPaHCAalIiErlvEk2jiXHtryOWoT4O7Ybp0Fwsndmdrw7Bl4W/Iv4suSMEFzdvaLvTMN2xDecCdToQMVqy5n02FtnbCzvOGvhEm+xtUNlrSHppdERW3NWoTLnxBfBehACyUstEsLZMp3BhDpzfm6kP0BoYDvJi5Ho0cMRLTjwxo1di3g+BA4uB9TCd7EOz6+LccKaaK+AKM9FNpUvujLTrFlzkpjmK4tJF6GkXeTdVjf9McWT0O3UcQX/9Y9bJex+Ukdo0oZ4K/qQzXWLsN0qZ1KNtnOyzA+rGNQjvSmosTOqQfcr0nBBXbtP65/Aw0jleFpl4M8nbPLPv4MWeAI1YMovxDLG3TrERM7tYjSD9g40qfBSpXDuGkz10KOT9Q39/gE=',
  '', 1 ),
( 7, 'field_email', 0, 0, 0, 1, 0, 'inbox', 'email', 1, 4, 5, 1, 1, 0, 0, 0, 0, 0, -1, 1, 'hidden', '', '', '', 0, 0, 'spClassInbox', 0, '', '',
  'bVHbTsMwDP0VlC9oB7uQPSHgAWlIiEnj2W29NlKaRHGqDSH+HSe9rDCeHJ9z7NjHIBeZ/CKZL6QgBF82rxgaW4ktybUUNRr0oGO2kUIFbJ23LqaZFDHEuga1c5ZUUNZEbClFgdqeEs866uoaKShTJ0SKLMVbZhp7eq5U2AEXiK2S+UC0GGCPDjwE64eqmxjvmYPzDk0dmpizNl9mw3wl0aMGonEwcil9MYU9j9ioOSjsB1xNughdtHcX7T4Zk9DNpO7Bf3vHlf70jtCkZWML+lBVvwKvthoNKYa21yR/rKNLD/SmocTG6gpHZ/IU+YGm9J8uPEGAudVce9QWri6wHm/+DqbGA+gOaXZb9vroERP5q46t6UzwYEjzT4XG+Rzc1HQtelVear5/AA==',
  '', 1 ),
( 8, 'field_short_description', 0, 0, 0, 1, 0, 'textarea', '', 1, 16, 6, 1, 1, 0, 0, 0, 1, 0, -1, 1, 'vcard',
  'YTo4OntpOjA7czo1OiJjbGFzcyI7aToxO3M6MjoiaWQiO2k6MjtzOjU6InN0eWxlIjtpOjM7czo0OiJocmVmIjtpOjQ7czozOiJzcmMiO2k6NTtzOjQ6Im5hbWUiO2k6NjtzOjM6ImFsdCI7aTo3O3M6NToidGl0bGUiO30=',
  'YToxNzp7aTowO3M6MToiYSI7aToxO3M6MToicCI7aToyO3M6MjoiYnIiO2k6MztzOjI6ImhyIjtpOjQ7czozOiJkaXYiO2k6NTtzOjI6ImxpIjtpOjY7czoyOiJ1bCI7aTo3O3M6NDoic3BhbiI7aTo4O3M6NToidGFibGUiO2k6OTtzOjI6InRyIjtpOjEwO3M6MjoidGQiO2k6MTE7czozOiJpbWciO2k6MTI7czoyOiJoMSI7aToxMztzOjI6ImgyIjtpOjE0O3M6MjoiaDMiO2k6MTU7czoyOiJoNCI7aToxNjtzOjI6Img1Ijt9',
  '0', 1, 0, 'spClassText', 0, '', '',
  'bZFPT8MwDMW/CsqZQ9Mx/mQnBEgchoQ0BGe3NW2ktIlqow0hvjt22o4JcWry87P7ngPOXrkvctfOeMY+jTGZDbnCGf3Y0pkOQ0qRPPs4KFs7U2GI+1xfOdMjww4TjMBxVCg952d6uJEiHLY4tNzpXcSrotDTpY71bccztmXGYqImugtAlKdbZyjl6wseeDG0SF49TibWR5mio/TiV7pDGOvsQdIu4gn+N/mh8fxnsqKjVBxTF/fKtiDLMBvvrBYkQFBwS88BauxiaDDvRJLkhPL3it58My2k1ORLUhzq8TPxPTCcdsjI9xCB/dDO2M67hSCv8Mh9OJVbeTn6aFukqaNyxRyOctwn5C42s5UWBxxB+r9/AA==',
  '', 1 ),
( 9, 'field_full_description', 0, 0, 0, 1, 20, 'textarea', '', 0, 17, 7, 0, 1, 0, 0, 0, 0, 0, -1, 1, 'details',
  'YTo4OntpOjA7czo1OiJjbGFzcyI7aToxO3M6MjoiaWQiO2k6MjtzOjU6InN0eWxlIjtpOjM7czo0OiJocmVmIjtpOjQ7czozOiJzcmMiO2k6NTtzOjQ6Im5hbWUiO2k6NjtzOjM6ImFsdCI7aTo3O3M6NToidGl0bGUiO30=',
  'YToxNzp7aTowO3M6MToiYSI7aToxO3M6MToicCI7aToyO3M6MjoiYnIiO2k6MztzOjI6ImhyIjtpOjQ7czozOiJkaXYiO2k6NTtzOjI6ImxpIjtpOjY7czoyOiJ1bCI7aTo3O3M6NDoic3BhbiI7aTo4O3M6NToidGFibGUiO2k6OTtzOjI6InRyIjtpOjEwO3M6MjoidGQiO2k6MTE7czozOiJpbWciO2k6MTI7czoyOiJoMSI7aToxMztzOjI6ImgyIjtpOjE0O3M6MjoiaDMiO2k6MTU7czoyOiJoNCI7aToxNjtzOjI6Img1Ijt9',
  '1', 1, 0,
  'spClassText', 0, '', '',
  'bVBNT8MwDP0rU37BWhgf2QkBEochIQ3B2W29NFLaRHFGhxD/HTtdth04OXl+tt97oKtb/UP6TiubcAjRB7UmvdRKSlVr1aMLwZNN1o+CrbSCxn9h7l9pNWCCLQaIkHzMoFYLqffcg8MGR5P6i503stKaPsmH56t6KS8W0BI9OiDKS3gLhfx9x0MqYgrlw+KU5880gYS62O2d65DaaEPRXF2fR7cIsc2C2HkZnsH/Lj13dsZWJ7JAJyo7oN5Pgm2gQafWVlfSYENOgAd6c9Bi71kU59PoJXf5ckOftpuTqSWF4hrHNn6H9AQJjmmWfHbOQ7KjKUs4YHDOTy9pcEdqlSsnTXtjkC7ZYoqyzVdMve/ULMPgiBF4/vcP',
  '', 1 ),
( 10, 'field_company_logo', 0, 0, 0, 1, 0, 'image', '', 1, 3, 10, 0, 1, 0, 0, 0, 0, 0, -1, 1, 'both', '', '', '', 0, 0, 'spClassImage', 0, '',
  'Change the allowed image file types in your Joomla configuration.',
  'dVLLbsIwEPwX/wBJaKA4p4q2aiUKlYroeZNsE6uJHdkujyL+vbZjR4AoF7Qzs7uzEwMdR/So6D0lTGPbSdGRTNGIEvsXJ5TU2HSdUEwzwS2WUgK52KLjx5SoWuyeSqYXkGNDMkbjzI0rlJo3oFSYozpXvrZQYcCCZsNw57DJoLPQTa3ddaW10KCdUpKrT1bq2lamMY5I70jBFt/B4/Zg26JGSuTM3D1CriUz9ZGVp5HVzIyEP6IG1ih/ua5/2txvYXxTgCw9wwavsZe9IKtqZ9WklCSpIyNPDgYNN44iv85RS2jR10chK27Kk1/5jditZOUmUeK6TAoSFftFD8Ze2sL+w6OmuovcL/jrO849zDyZBPLC/WSahkDsmf85tM+hQo4SNK5DUsHTcPpzI0D71GRYYlk3e2D9E7wzX94/yvNJjM/NkkrIA8mW/ayvvtNWsfm6JWos9FoCVx1I5MXhKqFC8C1KfR6mnSx2/KHRa9xfMmHB6jZtcoNGv8F+gbwaUo1Tw57+AA==',
  '', 1 ),
( 11, 'field_website', 0, 0, 0, 1, 10, 'url', 'website', 0, 14, 9, 0, 1, 0, 0, 0, 0, 0, -1, 1, 'details', '', '', '', 0, 0, 'spClassUrl', 0, '', '',
  'bVHBTsMwDP0VlC9oywbDPaEJTkPsAOycNaaN8OKqySjStH/HyZohBqckzy/Pz88aqgIOHhagbMBdP3Cvag8FqHiUFagOqe/Z22DZRWwOaovEY6pfg/Idjw/GhpUWWNUWSincgdrprxW6NnSRKLxyXsSbNGq8X5L2PilIJ9+n5+tAuWdmvFlMfarqzIqQMK9G3IonvPwRnSRsdv4RoUn7Vrz7jTUnUyWoRTrFE0X3935NusGOyeAwMcrJNI9umvAHjuO/E+vw/LtYZAdJ9en/IEohfmqyRgfMo+evN6A0ScZo1gMHbpgkLA0VHCwUpx10IfQ+xz07vVV9TNE7HDfWmWlHWVQuDe9dWJJtPvyl1VTC4YX/DCLDO35korNemVM3SBjwH8G41X3bog/WtareiuvjNw==',
  '', 1 ),
( 12, 'field_business_days', 0, 0, 0, 1, 0, 'chbxgroup', '', 1, 15, 9, 1, 1, 0, 0, 0, 0, 0, -1, 1, 'details', '', '', '', 1, 1, 'spClassCheckbox', 0, '', '',
  'dVHBTsMwDP2VKV+wlMKGd5w4IA1xmATntLUWi66J6qAOEP9O4qQFhDg5efZ7tp8N6A18MOgKFKMZW/uAwbpO7RhqUK1tLum5BUUBz350Pn3XoFJIJIu9944pkBsSdg2qwd5Nko91/Ho6IQcaToKAWku8ihnrpruOwsFEgtoR6JI4YzBH9GY0wY2FtSpTtMz73jALHHuxl+/eYvvSuMs81Vz2RCiTVPVSmqC5fNWZtyxVf3OOYoOw9MLK4H9t0hqC3S6EBP0s30Rf+Jm6kJVB6Wo2oinqf7NpQaZ3LCboedR8qUePi0VRxgxytTiC8+F+ONDwi7cVfOlRTngTxSYKed98nc8v',
  '', 1 ),
( 13, 'field_country', 0, 0, 0, 1, 0, 'select', '', 1, 9, 1, 1, 1, 0, 0, 0, 0, 1, -1, 1, 'details', '', '', '', 1, 0, 'spClassSelect', 0, '', '',
  'bVHLTsQwDPyVVc4ItYVll/QI3HhJleCctqaJlCZRnNWyIP6dOE1bEJwiz4ztyVjwcs8/kZcVZwjCd/IBgrQ9q5HvOBsRNHSBqj1nKsDovHVUFpzRQ30StHMWVVDWELblrAVtj4mPOjwMA2BQZkgIZ0V6LyIj7fGuV+FexAZWK15mYoQgGnDCi2A9qeOas0220SHeaIG4THGpbBarZGoWvShIRqrtIiRoEm86ezDBn1LT5drUpCQSev1jPoH/b6FPJGy3yAlaxRFv8VX1QeYMrmb3bR78h4x+UH0Aqx+nTHGqUhZlMVuejvbkIEdF4iqG3oMD04PpTrfwpsxyHFo5/VoBnr+Per7S2vDrSnGZ0PGYz8KDCZi5ktVf3w==',
  '', 1 ),
( 14, 'field_street', 0, 0, 0, 1, 0, 'inbox', '0', 1, 6, 5, 0, 1, 0, 0, 0, 0, 0, -1, 1, 'details', '', '', '', 0, 0, 'spClassInbox', 0, '', '',
  'bVHNbsIwDH4VlCcoMAYLp2nbYRKTpiGxs9uaNlJIotgVTNPefU5oC2g7Of5+4uQz6Fmhv0lPZ1oRQqzaN+TW12pNeqlVgw4j2NSttDKMhxB9SG2hVSrJ16INwZNh413CFlqVaP0x86KjrmmQ2LgmI1oVuc6Faf3xpTa8ATGotdFFTxyQYYsBIrCPvWuS6oNwcNqga7hNvWini6J/X0X0ZIFoeBiF3L660p8GbNDsDOYHzuajLkFZOyGOiJwtdxfLNueT0dVoOoP/jkg/y9j9qE7QqJV8S/o09fkn8sPVkEvZX/uXlME2hfVI7xYqbL2tcQhomqsc0FXxK/AzMFwnLt699XC1iLNjOaz+A1yDO7Ad0tWKJfK9xJHJmwVKNJ3jCI6sTCrtDSuXuu6A0VQX9OcX',
  '', 1 ),
( 15, 'field_category', 0, 0, 0, 1, 0, 'category', '', 1, 2, 10, 1, 1, 0, 0, 0, 0, 0, -1, 1, 'hidden', '', '', '', 1, 0, 'spClassCategory', 0, '', '',
  'fVHLTsMwEPwXfwBqQh/g3IiQOLQFiUPPTrzEK8V15HVFC+Lf8StJAYmbPTsznh0LXi75J/Gi5IxA2FbtwCkjWUV8HaAeWhcud5yhAz1YM7BqXyWFgn4YDKFDcwykFWcWOxUFxa2XK/P+KNFtRQM9q5AXyVZBYu2TcUtU94IoyrwHDfFaCwedsZcIL2faa8wZ0LKYyAn8ISlnSQgRsftJEKBr+oazhg4oXXT2xutxiyab/xn6TIQfEI4LznIB9Avy6+qpUv+Injv1bG2k6FMRPhrSi0UtQqCx4lY42onzFnXegLPVVIifHdCpWmEvKU8X+bfe8AyyRjlbpf99uuq+8HxjJVhfBD1csvIoNNwIaqPhZtQ9/8vz4QcL82reuMi0gJ80jEF8LXTqOiCHx45VDV9UX98=',
  '', 1 ),
( 16, 'field_contact_information', 0, 0, 0, 1, 0, 'info', '', 1, 10, 0, 0, 1, 0, 0, 0, 0, 0, -1, 1, 'details', '', '', '', 0, 0, 'spClassInfo', 0, '', '',
  'YTo3OntzOjEyOiJoZWxwcG9zaXRpb24iO3M6NToiYmVsb3ciO3M6MTM6InNob3dFZGl0TGFiZWwiO2k6MDtzOjg6ImNzc0NsYXNzIjtzOjExOiJzcENsYXNzSW5mbyI7czoxMjoiY3NzQ2xhc3NWaWV3IjtzOjE1OiJzcENsYXNzVmlld0luZm8iO3M6MTI6ImNzc0NsYXNzRWRpdCI7czoxNToic3BDbGFzc0VkaXRJbmZvIjtzOjc6ImJzV2lkdGgiO3M6MjoiMTAiO3M6MTA6InN1Z2dlc3RpbmciO2I6MDt9',
  '', 1 ),
( 17, 'field_address_information', 0, 0, 0, 1, 0, 'info', '', 1, 5, 0, 0, 1, 0, 0, 0, 0, 0, -1, 1, 'hidden', 'YToxOntpOjA7czowOiIiO30=', 'YToxOntpOjA7czowOiIiO30=', '', 0, 0,
  'spClassInfo', 0, '', '',
  'YTo3OntzOjEyOiJoZWxwcG9zaXRpb24iO3M6NToiYmVsb3ciO3M6MTM6InNob3dFZGl0TGFiZWwiO2k6MDtzOjg6ImNzc0NsYXNzIjtzOjExOiJzcENsYXNzSW5mbyI7czoxMjoiY3NzQ2xhc3NWaWV3IjtzOjE1OiJzcENsYXNzVmlld0luZm8iO3M6MTI6ImNzc0NsYXNzRWRpdCI7czoxNToic3BDbGFzc0VkaXRJbmZvIjtzOjc6ImJzV2lkdGgiO3M6MjoiMTAiO3M6MTA6InN1Z2dlc3RpbmciO2I6MDt9',
  '', 1 );

# insert field's data (entries sid 37 to 41)

INSERT IGNORE INTO `#__sobipro_field_data`( `publishUp`, `publishDown`, `fid`, `sid`, `section`, `lang`, `enabled`, `params`, `options`, `baseData`, `approved`,
                                            `confirmed`, `createdTime`, `createdBy`, `createdIP`, `updatedTime`, `updatedBy`, `updatedIP`, `copy`, `editLimit` )
VALUES
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 37, 1, 'en-GB', 1, NULL, NULL, 'Neotrin Electronics', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00',
  0, '000.000.000.000',
  0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 4, 37, 1, 'en-GB', 1, NULL, NULL, 'John Doe', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0,
  '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 7, 37, 1, 'en-GB', 1, NULL, NULL, 'contact@neotrin.com', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00',
  0, '000.000.000.000',
  0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 2, 37, 1, 'en-GB', 1, NULL, NULL, '60606', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0,
  '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 3, 37, 1, 'en-GB', 1, NULL, NULL, 'Chicago', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0,
  '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 5, 37, 1, 'en-GB', 1, NULL, NULL, '+1 (0) 1234.567.890', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00',
  0, '000.000.000.000',
  0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 6, 37, 1, 'en-GB', 1, NULL, NULL, '+1 (0) 1234.567.891', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00',
  0, '000.000.000.000',
  0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 8, 37, 1, 'en-GB', 1, NULL, NULL,
  'Morbi ornare porta eleifend. Praesent auctor urna eget nulla bibendum vestibulum. Phasellus eros est, adipiscing eu cursus fermentum, lacinia interdum felis. Vestibulum sit amet velit dui, a placerat dolor. Phasellus gravida, urna eu scelerisque venenatis, velit quam facilisis eros.',
  1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0, '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 9, 37, 1, 'en-GB', 1, NULL, NULL,
  '<p>Morbi ornare porta eleifend. Praesent auctor urna eget nulla bibendum vestibulum. Phasellus eros est, adipiscing eu cursus fermentum, lacinia interdum felis. Vestibulum sit amet velit dui, a placerat dolor. Phasellus gravida, urna eu scelerisque venenatis, velit quam facilisis eros, sit amet pretium metus leo quis orci. Sed eget ultrices neque. Proin at elit nibh, in aliquam elit. Morbi euismod libero in sapien rutrum in blandit enim pharetra. Integer tincidunt sagittis pellentesque. Cras sed mauris vitae est convallis rhoncus sed sed ligula. Fusce cursus, tortor non pellentesque consequat, purus odio ultrices massa, a gravida libero nisl eget tellus. Donec mollis tincidunt ligula, at rhoncus libero suscipit ut. Integer sodales semper congue. Ut sagittis bibendum augue, et feugiat mauris gravida ac. Maecenas pellentesque orci vitae quam sagittis non gravida lorem egestas. Aenean at enim id orci facilisis fermentum. Pellentesque convallis tortor eget lorem blandit ornare. In purus nisi, tincidunt at ultricies ac, luctus auctor augue. Sed orci neque, commodo in lobortis sit amet, condimentum ac odio.</p>',
  1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0, '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 11, 37, 1, 'en-GB', 1, NULL, NULL,
  'YTozOntzOjg6InByb3RvY29sIjtzOjU6Imh0dHBzIjtzOjM6InVybCI7czoxMToibmVvdHJpbi5jb20iO3M6NToibGFiZWwiO3M6MDoiIjt9',
  1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0, '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 12, 37, 1, 'en-GB', 1, NULL, NULL, '', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0,
  '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 38, 1, 'en-GB', 1, NULL, NULL, 'Natural Communications', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000',
  '2024-01-01 00:00:00', 0,
  '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 4, 38, 1, 'en-GB', 1, NULL, NULL, 'Scrooge McDuck', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0,
  '000.000.000.000', 0,
  2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 7, 38, 1, 'en-GB', 1, NULL, NULL, 'mcduck@naturalcommunications.com', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000',
  '2024-01-01 00:00:00',
  0, '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 2, 38, 1, 'en-GB', 1, NULL, NULL, '70122', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0,
  '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 3, 38, 1, 'en-GB', 1, NULL, NULL, 'New Orleans', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0,
  '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 5, 38, 1, 'en-GB', 1, NULL, NULL, '+1 (0) 9934.567.899', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00',
  0, '000.000.000.000',
  0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 6, 38, 1, 'en-GB', 1, NULL, NULL, '+1 (0) 9934.567.001', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00',
  0, '000.000.000.000',
  0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 11, 38, 1, 'en-GB', 1, NULL, NULL,
  'YTozOntzOjg6InByb3RvY29sIjtzOjU6Imh0dHBzIjtzOjM6InVybCI7czoyOToid3d3Lm5hdHVyYWxjb21tdW5pY2F0aW9ucy5jb20iO3M6NToibGFiZWwiO3M6MDoiIjt9',
  1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0, '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 12, 38, 1, 'en-GB', 1, NULL, NULL, '', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0,
  '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 8, 38, 1, 'en-GB', 1, NULL, NULL,
  'Fusce vel felis et dolor sagittis volutpat. Nunc sit amet lacus sapien, ac imperdiet mi. Duis sed massa metus, venenatis dignissim odio. Proin dui urna, facilisis vitae venenatis non, vehicula id neque. Sed rutrum est eu diam suscipit elementum eget nec mi.',
  1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0, '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 9, 38, 1, 'en-GB', 1, NULL, NULL,
  '<p>Morbi ornare porta eleifend. Praesent auctor urna eget nulla bibendum vestibulum. Phasellus eros est, adipiscing eu cursus fermentum, lacinia interdum felis. Vestibulum sit amet velit dui, a placerat dolor. Phasellus gravida, urna eu scelerisque venenatis, velit quam facilisis eros, sit amet pretium metus leo quis orci. Sed eget ultrices neque. Proin at elit nibh, in aliquam elit. Morbi euismod libero in sapien rutrum in blandit enim pharetra. Integer tincidunt sagittis pellentesque. Cras sed mauris vitae est convallis rhoncus sed sed ligula. Fusce cursus, tortor non pellentesque consequat, purus odio ultrices massa, a gravida libero nisl eget tellus. Donec mollis tincidunt ligula, at rhoncus libero suscipit ut. Integer sodales semper congue. Ut sagittis bibendum augue, et feugiat mauris gravida ac. Maecenas pellentesque orci vitae quam sagittis non gravida lorem egestas.</p>',
  1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0, '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 13, 37, 1, 'en-GB', 1, NULL, NULL, '', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0,
  '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 13, 38, 1, 'en-GB', 1, NULL, NULL, '', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0,
  '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 14, 37, 1, 'en-GB', 1, NULL, NULL, 'Main Street 789b', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0,
  '000.000.000.000',
  0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 15, 38, 1, 'en-GB', 1, NULL, NULL, 'YTozOntpOjA7czoxOiI4IjtpOjE7czoxOiI5IjtpOjI7czoyOiIxMSI7fQ==', 1, 0, '2024-01-01 00:00:00', 0,
  '000.000.000.000', '2024-01-01 00:00:00', 0, '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 14, 38, 1, 'en-GB', 1, NULL, NULL, 'Hemmingway Road 5', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0,
  '000.000.000.000',
  0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 15, 37, 1, 'en-GB', 1, NULL, NULL, 'YTo0OntpOjA7czoxOiI4IjtpOjE7czoyOiIxMCI7aToyO3M6MjoiMTEiO2k6MztzOjI6IjEyIjt9', 1, 0,
  '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0, '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 39, 1, 'en-GB', 1, NULL, NULL, 'Sun Bookstore', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0,
  '000.000.000.000', 0,
  2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 4, 39, 1, 'en-GB', 1, NULL, NULL, 'Carl  Sun', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0,
  '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 7, 39, 1, 'en-GB', 1, NULL, NULL, 'sun@sunbookstore.com', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00',
  0,
  '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 2, 39, 1, 'en-GB', 1, NULL, NULL, '10001', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0,
  '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 3, 39, 1, 'en-GB', 1, NULL, NULL, 'New York', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0,
  '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 5, 39, 1, 'en-GB', 1, NULL, NULL, '+1 (0) 567.899.11', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0,
  '000.000.000.000',
  0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 6, 39, 1, 'en-GB', 1, NULL, NULL, '+1 (0) 567.899.99', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0,
  '000.000.000.000',
  0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 11, 39, 1, 'en-GB', 1, NULL, NULL,
  'YTozOntzOjg6InByb3RvY29sIjtzOjU6Imh0dHBzIjtzOjM6InVybCI7czoyMDoid3d3LnN1bmJvb2tzdG9yZS5jb20iO3M6NToibGFiZWwiO3M6MDoiIjt9',
  1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0, '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 12, 39, 1, 'en-GB', 1, NULL, NULL, '', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0,
  '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 8, 39, 1, 'en-GB', 1, NULL, NULL,
  'Vivamus est leo, tempor at dictum in, pellentesque molestie velit. Sed lacinia, quam non malesuada porttitor, ante arcu ornare magna, vel lacinia nibh velit quis massa. Donec nec massa sit amet metus elementum porta. Duis a velit vitae leo accumsan sodales. Vestibulum convallis consectetur elit',
  1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0, '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 9, 39, 1, 'en-GB', 1, NULL, NULL,
  '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque laoreet rhoncus tempor. Suspendisse dapibus vulputate dolor ut tincidunt. Suspendisse tristique laoreet dui, ut tempor orci dictum ut. Quisque aliquam urna ac justo tristique interdum. Aliquam in dui eget lectus elementum lacinia eget eu sem. Nam eu felis tellus, ac cursus velit. Etiam magna libero, condimentum at facilisis a, fermentum eget leo. Nulla gravida imperdiet neque, accumsan auctor magna viverra a. Aliquam eget augue a ante malesuada convallis a nec mi. Phasellus mollis, urna et interdum congue, lacus ante lacinia ipsum, vitae fringilla quam mi id ipsum.</p>',
  1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0, '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 13, 39, 1, 'en-GB', 1, NULL, NULL, '', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0,
  '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 15, 39, 1, 'en-GB', 1, NULL, NULL, 'YTozOntpOjA7czoyOiIzMSI7aToxO3M6MjoiMzIiO2k6MjtzOjI6IjMzIjt9', 1, 0, '2024-01-01 00:00:00', 0,
  '000.000.000.000', '2024-01-01 00:00:00', 0, '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 14, 39, 1, 'en-GB', 1, NULL, NULL, 'Barcley Street', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0,
  '000.000.000.000', 0,
  2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 10, 38, 1, 'en-GB', 1, NULL, NULL,
  'jVFNT8MwDL3zK6KcQALarWvWZdoBQYFNDKatiCMKbWiN2qa06WCg/XfidHycgEvk92w/PzuCD/h7Yx6aCC3oWPDeDstXeETs7fD59CpEzBAHBkMur0Uh6bjhnsnHtaoqmdyXQre1yI9iVRRtCbHQoMrm+KlKsbLX7zrPhJYRYDfwHvMY84JgNBh/Ka/grct5Phuwbz7aVJbvd9TcSHSUkXY5hUKk0nmqZDfM43QlY2vgXLVlguSQ09Ob+Ty8juh4a0UMXNxG4Rlu93mNTBc5VvdN/AKJziZ05LqUZBLSTE8oG/oU84zTS0uhKUMayuf0DjuQMT3dyGlzqnJV25Vw7E8X9ubAsdJHfhmeRDdLTtLkCDch696xS/bbBsqUTGcXZLYIL8h65B4ckudW5KA3ZEJG7p7ZZ7u18+0Z0J7PdqBxGvUAVa0cWeoaDPYCB4r0j+8yWjpriwcbB79p2bI/1Mx3QKz+4StWvyptPwA=',
  1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0, '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 10, 37, 1, 'en-GB', 1, NULL, NULL,
  'jVFNT8JAEL37KzZ70kToly3tNhwMFITIR6DGoynt2i5pu7VdUDT8d3e2aLhIvGzmvZl582Y2Infkq5EPTiIRYT8ixgnTD/YK2Drh0eQxAOwAdiVmOZ1HBcV+QyyD4LjmVUWTl5JyUbOyQ3Mai5qXLG662yqFMsNs24aRoCGDVkYMx3Icy3Vtz/+VXbPPNucZrnnGh4dK8WZLzaRES0lpnWBWRCnVthVth1kEr6UFxstmxHdlAmSP4MFiNgvmIfaPSkTC5VMYDGG1n1Nkosih2pTxO0tE1seermOUUZZmoo+dno0h7xD8oCgwJUlJ2QQ/QwcwsqcdOWkGPOe1WgnGnrtQB2cEKm3gV8F9uFgRlCYd2ATtja6OrncNK1M0mY7RdBmM0d7Tb27R2y7KmTigPvL0K7nP8ajmqzOAPds6gUZr+IZVNddoKf9GYqunsSK99FdSSGS7YqNi+5KQKrskBTZi/g9HMf9b5vgN',
  1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0, '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 10, 39, 1, 'en-GB', 1, NULL, NULL,
  'jZFdb4IwFIbv9yuaXm3JFBBEKPFiUXSa+RFl2eWC0EEdUEaLm1v472uL+7gwy25I36c97znvIUQW+mDiA+OQh9ALkXHS+I08SW2e9GR250ttS+0ITTK8DHMMPYZ6fQSjipYljh9ZXXR2lD4zTivc3ZeJfGD02oJxyHFAZBFBhm3atum4hu59G27Je3tnWq5j/vDgWCrea9FCWLRIWOsIkjxMsLYvcdvMRHCLI05owSa0LmIJBwiOVouFvwyg1ygTIdf3gT+Wob6WkPI8U4HE+ZXEPB1Cx3UgSDFJUj6E9sCC8t5G8FYhOZSAAokVPMgKSURN23LGRjSjlYok2/6eQq2aIJm+L/nGvwlWGwSSuCOTgIPR1cFlzUiRgNl8CuZrfwoOrn51DV7qMCP8CIbA1S9EnqZR/dUa5HjW4CSYxuiOlBXVcMErIrTpaiRPzv8lYcHTOt8pC/cvC/XsvIlYPonoP6aI6DmD5hM=',
  1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0, '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 40, 1, 'en-GB', 1, NULL, NULL, 'Good Health Ltd.', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0,
  '000.000.000.000', 0,
  2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 15, 40, 1, 'en-GB', 1, NULL, NULL, 'YToyOntpOjA7czoyOiIyMCI7aToxO3M6MjoiMjEiO30=', 1, 0, '2024-01-01 00:00:00', 0,
  '000.000.000.000',
  '2024-01-01 00:00:00', 0, '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 10, 40, 1, 'en-GB', 1, NULL, NULL,
  'jVFdT8IwFH33VzR90kRYN2BjXXgwMBAiH4EZH03Z6lay0bl1KJr9d9sO1ERjfFl6zr3n3HvuCO7i91J+YEQEgR7B5gnTV/akcOeEx9M7X2Fb4b7ELKULklHoldjqYBgWPM9p9BhzHrUSSlKRtHd5rMqm1bSPiKABUxKGTbtj252+aznep92GvTU1hBxkfvHBMde81VBzadFQ0hphyDISU2OX02aY3GVDQ8H4vhzzah8p0sFwuJzP/UUAvVqbSLi6D/yRinQ+QSKyVMeR7xcWiWQAXYQgSCiLEzGAttODqm5jeKsptZQkJdXD8EEpFCM1zchpOeQpL3QkNfb7FvrQDKvOnuLX/k2wXGMQRy2VBBzMNgKXVcn2MZjOJmC28ifg4KKra/BckZSJIxgAF13IPHWt5+szqPW6Z1AaJd+yvOAG3YuCSdxFBsvi3/6R1IikyrbawPnLQLf9ZiEPz0L+jw1C/lNefwA=',
  1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0, '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 7, 40, 1, 'en-GB', 1, NULL, NULL, 'home@goodhealth.com', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00',
  0, '000.000.000.000',
  0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 14, 40, 1, 'en-GB', 1, NULL, NULL, 'Science Park', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0,
  '000.000.000.000', 0,
  2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 2, 40, 1, 'en-GB', 1, NULL, NULL, '1013', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0,
  '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 3, 40, 1, 'en-GB', 1, NULL, NULL, 'Amsterdam', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0,
  '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 13, 40, 1, 'en-GB', 1, NULL, NULL, '', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0,
  '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 4, 40, 1, 'en-GB', 1, NULL, NULL, 'Dr. Adam Feelgood', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0,
  '000.000.000.000',
  0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 5, 40, 1, 'en-GB', 1, NULL, NULL, '+31896-7765438', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0,
  '000.000.000.000', 0,
  2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 6, 40, 1, 'en-GB', 1, NULL, NULL, '+31896-7765439', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0,
  '000.000.000.000', 0,
  2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 11, 40, 1, 'en-GB', 1, NULL, NULL,
  'YTozOntzOjg6InByb3RvY29sIjtzOjU6Imh0dHBzIjtzOjM6InVybCI7czoxODoid3d3Lmdvb2RoZWFsdGguY29tIjtzOjU6ImxhYmVsIjtzOjA6IiI7fQ==',
  1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0, '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 12, 40, 1, 'en-GB', 1, NULL, NULL, '', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0,
  '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 8, 40, 1, 'en-GB', 1, NULL, NULL,
  'At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr,  sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.',
  1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0, '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 9, 40, 1, 'en-GB', 1, NULL, NULL,
  '<p>Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, At accusam aliquyam diam diam dolore dolores duo eirmod eos erat, et nonumy sed tempor et et invidunt justo labore Stet clita ea et gubergren, kasd magna no rebum. sanctus sea sed takimata ut vero voluptua. est Lorem ipsum dolor sit amet.</p>',
  1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0, '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 10, 41, 1, 'en-GB', 1, NULL, NULL,
  'jVHJTsMwFLzzFZZPINFmbdo46gG1aSmii9ogjihNTOIqiU3iFArKv2M7YblQcbE8896beUuIbPRRiQfGIQ+hFyKjw/iNPEtsdXi2uPcldiQeCUwyvApzDL0KWTqCUUkZw/ETL0lB+KnHMO9VNWPZqX9gicwyzLZqGnIcEFlJkOFYjmONXNv2vlV35F3F3JFtmj90cGKK7qilUGgpoSz8SR4mWDsw3HpZCO5wxAktqhmti1iSQwQn6+XSXwXQa5SIgJuHwJ/Kwb4WkfI8k9mm+L+SmKdj6Oo6BCkmScrH0BkOoIw7CN4qSjYlSEENEHyUFap7XW8tF9WEZrRU00rb312odRMkMweS3/o3wXqLQBL35CTgaPR1cFlXpEjA4m4O7jb+HBxd/eoavNRhJvYMxsDVL8Q8TaP81RpkewOzA5VW0T1hJdVwIY4jsG1oJE/OXEro8LTO9+pvn9NRaWeUxBlIRP/RT0T/VGk+AQ==',
  1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0, '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 41, 1, 'en-GB', 1, NULL, NULL, 'Trinity Pet Supplies', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00',
  0,
  '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 15, 41, 1, 'en-GB', 1, NULL, NULL, 'YToxOntpOjA7czoyOiIzMyI7fQ==', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000',
  '2024-01-01 00:00:00', 0,
  '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 7, 41, 1, 'en-GB', 1, NULL, NULL, 'trinity@trinity-pet-supplies.com', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000',
  '2024-01-01 00:00:00',
  0, '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 14, 41, 1, 'en-GB', 1, NULL, NULL, '1400 Route Saint-Guérin', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000',
  '2024-01-01 00:00:00', 0,
  '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 2, 41, 1, 'en-GB', 1, NULL, NULL, '73200', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0,
  '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 3, 41, 1, 'en-GB', 1, NULL, NULL, 'Grignon', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0,
  '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 13, 41, 1, 'en-GB', 1, NULL, NULL, '', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0,
  '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 4, 41, 1, 'en-GB', 1, NULL, NULL, 'Trinity Hound', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0,
  '000.000.000.000', 0,
  2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 5, 41, 1, 'en-GB', 1, NULL, NULL, '+33 555 536520', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0,
  '000.000.000.000', 0,
  2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 6, 41, 1, 'en-GB', 1, NULL, NULL, '+33 555 536528', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0,
  '000.000.000.000', 0,
  2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 11, 41, 1, 'en-GB', 1, NULL, NULL,
  'YTozOntzOjg6InByb3RvY29sIjtzOjU6Imh0dHBzIjtzOjM6InVybCI7czoyODoid3d3LnRyaW5pdHktcGV0LXN1cHBsaWVzLmNvbSI7czo1OiJsYWJlbCI7czowOiIiO30=',
  1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0, '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 12, 41, 1, 'en-GB', 1, NULL, NULL, '', 1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0,
  '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 8, 41, 1, 'en-GB', 1, NULL, NULL,
  'Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi. Lorem ipsum dolor sit amet, c',
  1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0, '000.000.000.000', 0, 2 ),
( '0000-00-00 00:00:00', '0000-00-00 00:00:00', 9, 41, 1, 'en-GB', 1, NULL, NULL,
  '<p>Consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>',
  1, 0, '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', 0, '000.000.000.000', 0, 2 );


# insert field options
INSERT IGNORE INTO `#__sobipro_field_option`( `fid`, `optValue`, `optPos`, `img`, `optClass`, `actions`, `class`, `optParent` )
VALUES
( 12, 'monday', 1, '', '', '', '', '' ),
( 12, 'tuesday', 2, '', '', '', '', '' ),
( 12, 'wednesday', 3, '', '', '', '', '' ),
( 12, 'thursday', 4, '', '', '', '', '' ),
( 12, 'friday', 5, '', '', '', '', '' ),
( 12, 'saturday', 6, '', '', '', '', '' ),
( 12, 'sunday', 7, '', '', '', '', '' ),
( 13, 'africa', 1, '', '', '', '', '' ),
( 13, 'algeria', 2, '', '', '', '', 'africa' ),
( 13, 'angola', 3, '', '', '', '', 'africa' ),
( 13, 'benin', 4, '', '', '', '', 'africa' ),
( 13, 'botswana', 5, '', '', '', '', 'africa' ),
( 13, 'burkina-faso', 6, '', '', '', '', 'africa' ),
( 13, 'burundi', 7, '', '', '', '', 'africa' ),
( 13, 'cameroon', 8, '', '', '', '', 'africa' ),
( 13, 'cape-verde', 9, '', '', '', '', 'africa' ),
( 13, 'central-african-republic', 10, '', '', '', '', 'africa' ),
( 13, 'chad', 11, '', '', '', '', 'africa' ),
( 13, 'comoros', 12, '', '', '', '', 'africa' ),
( 13, 'congo-democratic', 13, '', '', '', '', 'africa' ),
( 13, 'congo-republic-of', 14, '', '', '', '', 'africa' ),
( 13, 'cote-d-ivoire', 15, '', '', '', '', 'africa' ),
( 13, 'djibouti', 16, '', '', '', '', 'africa' ),
( 13, 'egypt', 17, '', '', '', '', 'africa' ),
( 13, 'equatorial-guinea', 18, '', '', '', '', 'africa' ),
( 13, 'eritrea', 19, '', '', '', '', 'africa' ),
( 13, 'ethiopia', 20, '', '', '', '', 'africa' ),
( 13, 'gabon', 21, '', '', '', '', 'africa' ),
( 13, 'gambia', 22, '', '', '', '', 'africa' ),
( 13, 'ghana', 23, '', '', '', '', 'africa' ),
( 13, 'guinea', 24, '', '', '', '', 'africa' ),
( 13, 'guinea-bissau', 25, '', '', '', '', 'africa' ),
( 13, 'kenya', 26, '', '', '', '', 'africa' ),
( 13, 'lesotho', 27, '', '', '', '', 'africa' ),
( 13, 'liberia', 28, '', '', '', '', 'africa' ),
( 13, 'libya', 29, '', '', '', '', 'africa' ),
( 13, 'madagascar', 30, '', '', '', '', 'africa' ),
( 13, 'malawi', 31, '', '', '', '', 'africa' ),
( 13, 'mali', 32, '', '', '', '', 'africa' ),
( 13, 'mauritania', 33, '', '', '', '', 'africa' ),
( 13, 'mauritius', 34, '', '', '', '', 'africa' ),
( 13, 'mayotte', 35, '', '', '', '', 'africa' ),
( 13, 'morocco', 36, '', '', '', '', 'africa' ),
( 13, 'mozambique', 37, '', '', '', '', 'africa' ),
( 13, 'namibia', 38, '', '', '', '', 'africa' ),
( 13, 'niger', 39, '', '', '', '', 'africa' ),
( 13, 'nigeria', 40, '', '', '', '', 'africa' ),
( 13, 'reunion', 41, '', '', '', '', 'africa' ),
( 13, 'rwanda', 42, '', '', '', '', 'africa' ),
( 13, 'sao-tome-and-principe', 43, '', '', '', '', 'africa' ),
( 13, 'senegal', 44, '', '', '', '', 'africa' ),
( 13, 'seychelles', 45, '', '', '', '', 'africa' ),
( 13, 'sierra-leone', 46, '', '', '', '', 'africa' ),
( 13, 'somalia', 47, '', '', '', '', 'africa' ),
( 13, 'somaliland', 48, '', '', '', '', 'africa' ),
( 13, 'south-africa', 49, '', '', '', '', 'africa' ),
( 13, 'sudan', 50, '', '', '', '', 'africa' ),
( 13, 'swaziland', 51, '', '', '', '', 'africa' ),
( 13, 'tunisia', 52, '', '', '', '', 'africa' ),
( 13, 'uganda', 53, '', '', '', '', 'africa' ),
( 13, 'western-sahara', 54, '', '', '', '', 'africa' ),
( 13, 'zambia', 55, '', '', '', '', 'africa' ),
( 13, 'zimbabwe', 56, '', '', '', '', 'africa' ),
( 13, 'asia', 57, '', '', '', '', '' ),
( 13, 'abkhazia', 58, '', '', '', '', 'asia' ),
( 13, 'afghanistan', 59, '', '', '', '', 'asia' ),
( 13, 'akrotiri-and-dhekelia', 60, '', '', '', '', 'asia' ),
( 13, 'armenia', 61, '', '', '', '', 'asia' ),
( 13, 'azerbaijan', 62, '', '', '', '', 'asia' ),
( 13, 'bahrain', 63, '', '', '', '', 'asia' ),
( 13, 'bangladesh', 64, '', '', '', '', 'asia' ),
( 13, 'bhutan', 65, '', '', '', '', 'asia' ),
( 13, 'british-indian', 66, '', '', '', '', 'asia' ),
( 13, 'brunei', 67, '', '', '', '', 'asia' ),
( 13, 'cambodia', 68, '', '', '', '', 'asia' ),
( 13, 'china', 69, '', '', '', '', 'asia' ),
( 13, 'taiwan', 70, '', '', '', '', 'asia' ),
( 13, 'christmas-island', 71, '', '', '', '', 'asia' ),
( 13, 'cocos-islands', 72, '', '', '', '', 'asia' ),
( 13, 'cyprus', 73, '', '', '', '', 'asia' ),
( 13, 'georgia', 74, '', '', '', '', 'asia' ),
( 13, 'hong-kong', 75, '', '', '', '', 'asia' ),
( 13, 'india', 76, '', '', '', '', 'asia' ),
( 13, 'indonesia', 77, '', '', '', '', 'asia' ),
( 13, 'iran', 78, '', '', '', '', 'asia' ),
( 13, 'iraq', 79, '', '', '', '', 'asia' ),
( 13, 'israel', 80, '', '', '', '', 'asia' ),
( 13, 'japan', 81, '', '', '', '', 'asia' ),
( 13, 'jordan', 82, '', '', '', '', 'asia' ),
( 13, 'kazakhstan', 83, '', '', '', '', 'asia' ),
( 13, 'north-korea', 84, '', '', '', '', 'asia' ),
( 13, 'korea-republic', 85, '', '', '', '', 'asia' ),
( 13, 'kuwait', 86, '', '', '', '', 'asia' ),
( 13, 'kyrgyzstan', 87, '', '', '', '', 'asia' ),
( 13, 'laos', 88, '', '', '', '', 'asia' ),
( 13, 'lebanon', 89, '', '', '', '', 'asia' ),
( 13, 'macau', 90, '', '', '', '', 'asia' ),
( 13, 'malaysia', 91, '', '', '', '', 'asia' ),
( 13, 'maldives', 92, '', '', '', '', 'asia' ),
( 13, 'mongolia', 93, '', '', '', '', 'asia' ),
( 13, 'myanmar', 94, '', '', '', '', 'asia' ),
( 13, 'nagorno-karabakh', 95, '', '', '', '', 'asia' ),
( 13, 'northern-cyprus', 96, '', '', '', '', 'asia' ),
( 13, 'nepal', 97, '', '', '', '', 'asia' ),
( 13, 'oman', 98, '', '', '', '', 'asia' ),
( 13, 'pakistan', 99, '', '', '', '', 'asia' ),
( 13, 'palestinian-territories', 100, '', '', '', '', 'asia' ),
( 13, 'philippines', 101, '', '', '', '', 'asia' ),
( 13, 'qatar', 102, '', '', '', '', 'asia' ),
( 13, 'saudi-arabia', 103, '', '', '', '', 'asia' ),
( 13, 'singapore', 104, '', '', '', '', 'asia' ),
( 13, 'south-ossetia', 105, '', '', '', '', 'asia' ),
( 13, 'sri-lanka', 106, '', '', '', '', 'asia' ),
( 13, 'syria', 107, '', '', '', '', 'asia' ),
( 13, 'tajikistan', 108, '', '', '', '', 'asia' ),
( 13, 'thailand', 109, '', '', '', '', 'asia' ),
( 13, 'timor-leste', 110, '', '', '', '', 'asia' ),
( 13, 'turkey', 111, '', '', '', '', 'asia' ),
( 13, 'turkmenistan', 112, '', '', '', '', 'asia' ),
( 13, 'united-arab-emirates', 113, '', '', '', '', 'asia' ),
( 13, 'uzbekistan', 114, '', '', '', '', 'asia' ),
( 13, 'vietnam', 115, '', '', '', '', 'asia' ),
( 13, 'yemen', 116, '', '', '', '', 'asia' ),
( 13, 'europe', 117, '', '', '', '', '' ),
( 13, 'aland-islands', 118, '', '', '', '', 'europe' ),
( 13, 'albania', 119, '', '', '', '', 'europe' ),
( 13, 'andorra', 120, '', '', '', '', 'europe' ),
( 13, 'austria', 121, '', '', '', '', 'europe' ),
( 13, 'belarus', 122, '', '', '', '', 'europe' ),
( 13, 'belgium', 123, '', '', '', '', 'europe' ),
( 13, 'bosnia-herzegovina', 124, '', '', '', '', 'europe' ),
( 13, 'bulgaria', 125, '', '', '', '', 'europe' ),
( 13, 'croatia', 126, '', '', '', '', 'europe' ),
( 13, 'czech-republic', 127, '', '', '', '', 'europe' ),
( 13, 'denmark', 128, '', '', '', '', 'europe' ),
( 13, 'estonia', 129, '', '', '', '', 'europe' ),
( 13, 'faroe-islands', 130, '', '', '', '', 'europe' ),
( 13, 'finland', 131, '', '', '', '', 'europe' ),
( 13, 'france', 132, '', '', '', '', 'europe' ),
( 13, 'germany', 133, '', '', '', '', 'europe' ),
( 13, 'gibraltar', 134, '', '', '', '', 'europe' ),
( 13, 'greece', 135, '', '', '', '', 'europe' ),
( 13, 'guernsey', 136, '', '', '', '', 'europe' ),
( 13, 'hungary', 137, '', '', '', '', 'europe' ),
( 13, 'iceland', 138, '', '', '', '', 'europe' ),
( 13, 'ireland', 139, '', '', '', '', 'europe' ),
( 13, 'isle-of-man', 140, '', '', '', '', 'europe' ),
( 13, 'italy', 141, '', '', '', '', 'europe' ),
( 13, 'jersey', 142, '', '', '', '', 'europe' ),
( 13, 'kosovo', 143, '', '', '', '', 'europe' ),
( 13, 'latvia', 144, '', '', '', '', 'europe' ),
( 13, 'liechtenstein', 145, '', '', '', '', 'europe' ),
( 13, 'lithuania', 146, '', '', '', '', 'europe' ),
( 13, 'luxembourg', 147, '', '', '', '', 'europe' ),
( 13, 'macedonia', 148, '', '', '', '', 'europe' ),
( 13, 'malta', 149, '', '', '', '', 'europe' ),
( 13, 'moldova', 150, '', '', '', '', 'europe' ),
( 13, 'monaco', 151, '', '', '', '', 'europe' ),
( 13, 'montenegro', 152, '', '', '', '', 'europe' ),
( 13, 'netherlands', 153, '', '', '', '', 'europe' ),
( 13, 'norway', 154, '', '', '', '', 'europe' ),
( 13, 'poland', 155, '', '', '', '', 'europe' ),
( 13, 'portugal', 156, '', '', '', '', 'europe' ),
( 13, 'romania', 157, '', '', '', '', 'europe' ),
( 13, 'russia', 158, '', '', '', '', 'europe' ),
( 13, 'san-marino', 159, '', '', '', '', 'europe' ),
( 13, 'serbia', 160, '', '', '', '', 'europe' ),
( 13, 'slovakia', 161, '', '', '', '', 'europe' ),
( 13, 'slovenia', 162, '', '', '', '', 'europe' ),
( 13, 'spain', 163, '', '', '', '', 'europe' ),
( 13, 'svalbard', 164, '', '', '', '', 'europe' ),
( 13, 'sweden', 165, '', '', '', '', 'europe' ),
( 13, 'switzerland', 166, '', '', '', '', 'europe' ),
( 13, 'transnistria', 167, '', '', '', '', 'europe' ),
( 13, 'ukraine', 168, '', '', '', '', 'europe' ),
( 13, 'united-kingdom', 169, '', '', '', '', 'europe' ),
( 13, 'vatican', 170, '', '', '', '', 'europe' ),
( 13, 'north-america', 171, '', '', '', '', '' ),
( 13, 'anguilla', 172, '', '', '', '', 'north-america' ),
( 13, 'antigua-and-barbuda', 173, '', '', '', '', 'north-america' ),
( 13, 'aruba', 174, '', '', '', '', 'north-america' ),
( 13, 'bahamas', 175, '', '', '', '', 'north-america' ),
( 13, 'barbados', 176, '', '', '', '', 'north-america' ),
( 13, 'belize', 177, '', '', '', '', 'north-america' ),
( 13, 'bermuda', 178, '', '', '', '', 'north-america' ),
( 13, 'british-virgin-islands', 179, '', '', '', '', 'north-america' ),
( 13, 'canada', 180, '', '', '', '', 'north-america' ),
( 13, 'cayman-islands', 181, '', '', '', '', 'north-america' ),
( 13, 'clipperton-island', 182, '', '', '', '', 'north-america' ),
( 13, 'costa-rica', 183, '', '', '', '', 'north-america' ),
( 13, 'cuba', 184, '', '', '', '', 'north-america' ),
( 13, 'dominica', 185, '', '', '', '', 'north-america' ),
( 13, 'dominican-republic', 186, '', '', '', '', 'north-america' ),
( 13, 'el-salvador', 187, '', '', '', '', 'north-america' ),
( 13, 'greenland', 188, '', '', '', '', 'north-america' ),
( 13, 'grenada', 189, '', '', '', '', 'north-america' ),
( 13, 'guadeloupe', 190, '', '', '', '', 'north-america' ),
( 13, 'guatemala', 191, '', '', '', '', 'north-america' ),
( 13, 'haiti', 192, '', '', '', '', 'north-america' ),
( 13, 'honduras', 193, '', '', '', '', 'north-america' ),
( 13, 'jamaica', 194, '', '', '', '', 'north-america' ),
( 13, 'martinique', 195, '', '', '', '', 'north-america' ),
( 13, 'mexico', 196, '', '', '', '', 'north-america' ),
( 13, 'montserrat', 197, '', '', '', '', 'north-america' ),
( 13, 'navassa-island', 198, '', '', '', '', 'north-america' ),
( 13, 'netherlands-antilles', 199, '', '', '', '', 'north-america' ),
( 13, 'nicaragua', 200, '', '', '', '', 'north-america' ),
( 13, 'panama', 201, '', '', '', '', 'north-america' ),
( 13, 'puerto-rico', 202, '', '', '', '', 'north-america' ),
( 13, 'saint-barthelemy', 203, '', '', '', '', 'north-america' ),
( 13, 'saint-kitts-and-nevis', 204, '', '', '', '', 'north-america' ),
( 13, 'saint-lucia', 205, '', '', '', '', 'north-america' ),
( 13, 'saint-martin', 206, '', '', '', '', 'north-america' ),
( 13, 'saint-pierre-and-miquelon', 207, '', '', '', '', 'north-america' ),
( 13, 'saint-vincent-grenadines', 208, '', '', '', '', 'north-america' ),
( 13, 'trinidad-and-tobago', 209, '', '', '', '', 'north-america' ),
( 13, 'turks-and-caicos-islands', 210, '', '', '', '', 'north-america' ),
( 13, 'usa', 211, '', '', '', '', 'north-america' ),
( 13, 'virgin-islands', 212, '', '', '', '', 'north-america' ),
( 13, 'south-america', 213, '', '', '', '', '' ),
( 13, 'argentina', 214, '', '', '', '', 'south-america' ),
( 13, 'bolivia', 215, '', '', '', '', 'south-america' ),
( 13, 'brazil', 216, '', '', '', '', 'south-america' ),
( 13, 'chile', 217, '', '', '', '', 'south-america' ),
( 13, 'colombia', 218, '', '', '', '', 'south-america' ),
( 13, 'ecuador', 219, '', '', '', '', 'south-america' ),
( 13, 'falkland-islands', 220, '', '', '', '', 'south-america' ),
( 13, 'french-guiana', 221, '', '', '', '', 'south-america' ),
( 13, 'guyana', 222, '', '', '', '', 'south-america' ),
( 13, 'paraguay', 223, '', '', '', '', 'south-america' ),
( 13, 'peru', 224, '', '', '', '', 'south-america' ),
( 13, 'suriname', 225, '', '', '', '', 'south-america' ),
( 13, 'uruguay', 226, '', '', '', '', 'south-america' ),
( 13, 'venezuela', 227, '', '', '', '', 'south-america' ),
( 13, 'oceania', 228, '', '', '', '', '' ),
( 13, 'american-samoa', 229, '', '', '', '', 'oceania' ),
( 13, 'ashmore-and-cartier', 230, '', '', '', '', 'oceania' ),
( 13, 'australia', 231, '', '', '', '', 'oceania' ),
( 13, 'baker-island', 232, '', '', '', '', 'oceania' ),
( 13, 'cook-islands', 233, '', '', '', '', 'oceania' ),
( 13, 'coral-sea-islands', 234, '', '', '', '', 'oceania' ),
( 13, 'fiji', 235, '', '', '', '', 'oceania' ),
( 13, 'french-polynesia', 236, '', '', '', '', 'oceania' ),
( 13, 'guam', 237, '', '', '', '', 'oceania' ),
( 13, 'howland-island', 238, '', '', '', '', 'oceania' ),
( 13, 'jarvis-island', 239, '', '', '', '', 'oceania' ),
( 13, 'johnston-atoll', 240, '', '', '', '', 'oceania' ),
( 13, 'kingman-reef', 241, '', '', '', '', 'oceania' ),
( 13, 'kiribati', 242, '', '', '', '', 'oceania' ),
( 13, 'marshall-islands', 243, '', '', '', '', 'oceania' ),
( 13, 'micronesia', 244, '', '', '', '', 'oceania' ),
( 13, 'midway-atoll', 245, '', '', '', '', 'oceania' ),
( 13, 'nauru', 246, '', '', '', '', 'oceania' ),
( 13, 'new-caledonia', 247, '', '', '', '', 'oceania' ),
( 13, 'new-zealand', 248, '', '', '', '', 'oceania' ),
( 13, 'niue', 249, '', '', '', '', 'oceania' ),
( 13, 'norfolk-island', 250, '', '', '', '', 'oceania' ),
( 13, 'northern-mariana-islands', 251, '', '', '', '', 'oceania' ),
( 13, 'palau', 252, '', '', '', '', 'oceania' ),
( 13, 'palmyra-atoll', 253, '', '', '', '', 'oceania' ),
( 13, 'papua-new-guinea', 254, '', '', '', '', 'oceania' ),
( 13, 'pitcairn-islands', 255, '', '', '', '', 'oceania' ),
( 13, 'samoa', 256, '', '', '', '', 'oceania' ),
( 13, 'solomon-islands', 257, '', '', '', '', 'oceania' ),
( 13, 'tokelau', 258, '', '', '', '', 'oceania' ),
( 13, 'tonga', 259, '', '', '', '', 'oceania' ),
( 13, 'tuvalu', 260, '', '', '', '', 'oceania' ),
( 13, 'vanuatu', 261, '', '', '', '', 'oceania' ),
( 13, 'wake-island', 262, '', '', '', '', 'oceania' ),
( 13, 'wallis-and-futuna', 263, '', '', '', '', 'oceania' ),
( 13, 'antarctica', 264, '', '', '', '', '' ),
( 13, 'bouvet-island', 265, '', '', '', '', 'antarctica' ),
( 13, 'french-southern-territories', 266, '', '', '', '', 'antarctica' ),
( 13, 'heard-island-mcdonald-islands', 267, '', '', '', '', 'antarctica' ),
( 13, 'south-georgia-south-sandwich-islands', 268, '', '', '', '', 'antarctica' );

# insert selected field options
INSERT IGNORE INTO `#__sobipro_field_option_selected`( `fid`, `sid`, `optValue`, `params`, `copy` )
VALUES
( 12, 37, 'friday', '', 0 ),
( 12, 37, 'monday', '', 0 ),
( 12, 37, 'thursday', '', 0 ),
( 12, 37, 'tuesday', '', 0 ),
( 12, 37, 'wednesday', '', 0 ),
( 12, 38, 'friday', '', 0 ),
( 12, 38, 'monday', '', 0 ),
( 12, 38, 'saturday', '', 0 ),
( 12, 38, 'thursday', '', 0 ),
( 12, 38, 'tuesday', '', 0 ),
( 12, 38, 'wednesday', '', 0 ),
( 12, 39, 'friday', '', 0 ),
( 12, 39, 'saturday', '', 0 ),
( 12, 39, 'thursday', '', 0 ),
( 12, 39, 'tuesday', '', 0 ),
( 12, 39, 'wednesday', '', 0 ),
( 12, 40, 'monday', '', 0 ),
( 12, 40, 'thursday', '', 0 ),
( 12, 40, 'tuesday', '', 0 ),
( 12, 40, 'wednesday', '', 0 ),
( 12, 41, 'friday', '', 0 ),
( 12, 41, 'monday', '', 0 ),
( 12, 41, 'saturday', '', 0 ),
( 12, 41, 'sunday', '', 0 ),
( 12, 41, 'thursday', '', 0 ),
( 12, 41, 'tuesday', '', 0 ),
( 12, 41, 'wednesday', '', 0 ),
( 13, 37, 'usa', '', 0 ),
( 13, 38, 'usa', '', 0 ),
( 13, 39, 'usa', '', 0 ),
( 13, 40, 'netherlands', '', 0 ),
( 13, 41, 'france', '', 0 );

# insert field data (language dependant data from categories and entries)

INSERT IGNORE INTO `#__sobipro_language`( `sKey`, `sValue`, `section`, `language`, `oType`, `fid`, `id`, `params`, `options`, `explanation` )
VALUES
( 'description',
  '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque laoreet rhoncus tempor. Suspendisse dapibus vulputate dolor ut tincidunt. Suspendisse tristique laoreet dui, ut tempor orci dictum ut. Quisque aliquam urna ac justo tristique interdum. Aliquam in dui eget lectus elementum lacinia eget eu sem. Nam eu felis tellus, ac cursus velit. Etiam magna libero, condimentum at facilisis a, fermentum eget leo.</p>',
  0, 'en-GB', 'section', 0, 1, NULL, NULL, NULL ),
( 'name', 'Business Directory', 0, 'en-GB', 'section', 0, 1, NULL, NULL, NULL ),
( 'nid', 'business-directory', 0, 'en-GB', 'section', 0, 1, NULL, NULL, NULL ),
( 'metaKeys', 'business, directory', 0, 'en-GB', 'section', 0, 1, NULL, NULL, NULL ),
( 'metaDesc', 'Business Directory', 0, 'en-GB', 'section', 0, 1, NULL, NULL, NULL ),
( 'sfMetaKeys', 'search', 0, 'en-GB', 'section', 0, 1, NULL, NULL, NULL ),
( 'sfMetaDesc', 'Search companies. ', 0, 'en-GB', 'section', 0, 1, NULL, NULL, NULL ),
( 'efMetaKeys', 'add, new', 0, 'en-GB', 'section', 0, 1, NULL, NULL, NULL ),
( 'efMetaDesc', 'Add a company. ', 0, 'en-GB', 'section', 0, 1, NULL, NULL, NULL ),
( 'efDesc', '', 0, 'en-GB', 'section', 0, 1, NULL, NULL, NULL ),
( 'sfDesc', '', 0, 'en-GB', 'section', 0, 1, NULL, NULL, NULL ),
( 'efTitle', '', 0, 'en-GB', 'section', 0, 1, NULL, NULL, NULL ),
( 'sfTitle', '', 0, 'en-GB', 'section', 0, 1, NULL, NULL, NULL ),
( 'redirectSectionUrl', 'index.php', 0, 'en-GB', 'section', 0, 1, NULL, NULL, NULL ),
( 'redirectCategoryUrl', 'index.php', 0, 'en-GB', 'section', 0, 1, NULL, NULL, NULL ),
( 'redirectEntryUrl', 'index.php', 0, 'en-GB', 'section', 0, 1, NULL, NULL, NULL ),
( 'redirectEntryAddUrl', 'index.php', 0, 'en-GB', 'section', 0, 1, NULL, NULL, NULL ),
( 'redirectEntrySaveUrl', 'index.php', 0, 'en-GB', 'section', 0, 1, NULL, NULL, NULL ),
( 'redirectSearchUrl', 'index.php', 0, 'en-GB', 'section', 0, 1, NULL, NULL, NULL ),
( 'description',
  '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque laoreet rhoncus tempor. Suspendisse dapibus vulputate dolor ut tincidunt. Suspendisse tristique laoreet dui, ut tempor orci dictum ut. Quisque aliquam urna ac justo tristique interdum. Aliquam in dui eget lectus elementum lacinia eget eu sem. Nam eu felis tellus, ac cursus velit. </p>',
  0, 'en-GB', 'category', 0, 2, NULL, NULL, NULL ),
( 'introtext', '', 0, 'en-GB', 'category', 0, 2, NULL, NULL, NULL ),
( 'name', 'Computers and Internet', 0, 'en-GB', 'category', 0, 2, NULL, NULL, NULL ),
( 'description',
  '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque laoreet rhoncus tempor. Suspendisse dapibus vulputate dolor ut tincidunt. Suspendisse tristique laoreet dui, ut tempor orci dictum ut. Quisque aliquam urna ac justo tristique interdum. Aliquam in dui eget lectus elementum lacinia eget eu sem. Nam eu felis tellus, ac cursus velit. </p>',
  0, 'en-GB', 'category', 0, 3, NULL, NULL, NULL ),
( 'introtext', '', 0, 'en-GB', 'category', 0, 3, NULL, NULL, NULL ),
( 'name', 'Games', 0, 'en-GB', 'category', 0, 3, NULL, NULL, NULL ),
( 'description',
  '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque laoreet rhoncus tempor. Suspendisse dapibus vulputate dolor ut tincidunt. Suspendisse tristique laoreet dui, ut tempor orci dictum ut. Quisque aliquam urna ac justo tristique interdum. Aliquam in dui eget lectus elementum lacinia eget eu sem. Nam eu felis tellus, ac cursus velit. </p>',
  0, 'en-GB', 'category', 0, 4, NULL, NULL, NULL ),
( 'introtext', '', 0, 'en-GB', 'category', 0, 4, NULL, NULL, NULL ),
( 'name', 'Health', 0, 'en-GB', 'category', 0, 4, NULL, NULL, NULL ),
( 'description',
  '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque laoreet rhoncus tempor. Suspendisse dapibus vulputate dolor ut tincidunt. Suspendisse tristique laoreet dui, ut tempor orci dictum ut. Quisque aliquam urna ac justo tristique interdum. Aliquam in dui eget lectus elementum lacinia eget eu sem. Nam eu felis tellus, ac cursus velit. </p>',
  0, 'en-GB', 'category', 0, 5, NULL, NULL, NULL ),
( 'introtext', '', 0, 'en-GB', 'category', 0, 5, NULL, NULL, NULL ),
( 'name', 'Home & Garden', 0, 'en-GB', 'category', 0, 5, NULL, NULL, NULL ),
( 'description',
  '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque laoreet rhoncus tempor. Suspendisse dapibus vulputate dolor ut tincidunt. Suspendisse tristique laoreet dui, ut tempor orci dictum ut. Quisque aliquam urna ac justo tristique interdum. Aliquam in dui eget lectus elementum lacinia eget eu sem. Nam eu felis tellus, ac cursus velit. </p>',
  0, 'en-GB', 'category', 0, 6, NULL, NULL, NULL ),
( 'introtext', '', 0, 'en-GB', 'category', 0, 6, NULL, NULL, NULL ),
( 'name', 'News', 0, 'en-GB', 'category', 0, 6, NULL, NULL, NULL ),
( 'description',
  '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque laoreet rhoncus tempor. Suspendisse dapibus vulputate dolor ut tincidunt. Suspendisse tristique laoreet dui, ut tempor orci dictum ut. Quisque aliquam urna ac justo tristique interdum. Aliquam in dui eget lectus elementum lacinia eget eu sem. Nam eu felis tellus, ac cursus velit. </p>',
  0, 'en-GB', 'category', 0, 7, NULL, NULL, NULL ),
( 'introtext', '', 0, 'en-GB', 'category', 0, 7, NULL, NULL, NULL ),
( 'name', 'Shopping', 0, 'en-GB', 'category', 0, 7, NULL, NULL, NULL ),
( 'description',
  '<p><b>Telecommunication</b> occurs when the exchange of <a title=\"Information\" href=\"https://en.wikipedia.org/wiki/Information\">information</a> between two <a class=\"mw-redirect\" title=\"Entities\" href=\"https://en.wikipedia.org/wiki/Entities\">entities</a> (<a title=\"Communication\" href=\"https://en.wikipedia.org/wiki/Communication\">communication</a>) includes the use of technology. </p>',
  0, 'en-GB', 'category', 0, 8, NULL, NULL, NULL ),
( 'introtext', 'Telecommunication occurs when the exchange of information between two entities (communication) includes the use of technology. ', 0, 'en-GB', 'category', 0, 8,
  NULL, NULL, NULL ),
( 'name', 'Communications', 0, 'en-GB', 'category', 0, 8, NULL, NULL, NULL ),
( 'description',
  '<p><b>Graphics</b> (from <a title=\"Greek language\" href=\"https://en.wikipedia.org/wiki/Greek_language\">Greek</a> <span lang=\"grc\"><a class=\"extiw\" title=\"wikt:γραφικός\" href=\"https://en.wiktionary.org/wiki/%CE%B3%CF%81%CE%B1%CF%86%CE%B9%CE%BA%CF%8C%CF%82\">γραφικός</a></span> <i>graphikos</i>, \\\'something written\\\' e.g. autograph) are <a title=\"Visual perception\" href=\"https://en.wikipedia.org/wiki/Visual_perception\">visual</a> images or designs on some surface, such as a wall, <a title=\"Canvas\" href=\"https://en.wikipedia.org/wiki/Canvas\">canvas</a>, screen, paper, or stone to inform, illustrate, or entertain.</p>',
  0, 'en-GB', 'category', 0, 9, NULL, NULL, NULL ),
( 'introtext',
  'Graphics (from Greek γραφικός graphikos, \\\'something written\\\' e.g. autograph) are visual images or designs on some surface, such as a wall, canvas, screen, paper, or stone to inform, illustrate, or entertain.',
  0, 'en-GB', 'category', 0, 9, NULL, NULL, NULL ),
( 'name', 'Graphics', 0, 'en-GB', 'category', 0, 9, NULL, NULL, NULL ),
( 'description',
  '<p><b>Computer hardware</b> (usually simply called <b>hardware</b> when a <a title=\"Computing\" href=\"https://en.wikipedia.org/wiki/Computing\">computing</a> context is implicit) is the collection of physical elements that constitutes a <a title=\"Computer\" href=\"https://en.wikipedia.org/wiki/Computer\">computer</a> system.</p>',
  0, 'en-GB', 'category', 0, 10, NULL, NULL, NULL ),
( 'introtext',
  'Computer hardware (usually simply called hardware when a computing context is implicit) is the collection of physical elements that constitutes a computer system. ', 0, 'en-GB',
  'category', 0, 10, NULL, NULL, NULL ),
( 'name', 'Hardware', 0, 'en-GB', 'category', 0, 10, NULL, NULL, NULL ),
( 'description',
  '<p><b>Mobile computing</b> is <a title=\"Human–computer interaction\" href=\"https://en.wikipedia.org/wiki/Human%E2%80%93computer_interaction\">human–computer interaction</a> by which a <a title=\"Computer\" href=\"https://en.wikipedia.org/wiki/Computer\">computer</a> is expected to be transported during normal usage. Mobile computing involves <a class=\"mw-redirect\" title=\"Mobile communication\" href=\"https://en.wikipedia.org/wiki/Mobile_communication\">mobile communication</a>, mobile hardware, and mobile software.</p>',
  0, 'en-GB', 'category', 0, 11, NULL, NULL, NULL ),
( 'introtext', 'Mobile computing is human–computer interaction by which a computer is expected to be transported during normal usage. ', 0, 'en-GB', 'category', 0, 11, NULL, NULL,
  NULL ),
( 'name', 'Mobile Computing', 0, 'en-GB', 'category', 0, 11, NULL, NULL, NULL ),
( 'description',
  '<p><b>Multimedia</b> refers to <a class=\"mw-redirect\" title=\"Content (media and publishing)\" href=\"https://en.wikipedia.org/wiki/Content_%28media_and_publishing%29\">content</a> that uses a combination of different <a title=\"Content format\" href=\"https://en.wikipedia.org/wiki/Content_format\">content forms</a>. This contrasts with media that use only rudimentary computer displays such as text-only or traditional forms of printed or hand-produced material.</p>',
  0, 'en-GB', 'category', 0, 12, NULL, NULL, NULL ),
( 'introtext', 'Multimedia refers to content that uses a combination of different content forms.', 0, 'en-GB', 'category', 0, 12, NULL, NULL, NULL ),
( 'name', 'Multimedia', 0, 'en-GB', 'category', 0, 12, NULL, NULL, NULL ),
( 'description',
  '<p><b>Dice games</b> are <a title=\"Game\" href=\"https://en.wikipedia.org/wiki/Game\">games</a> that use or incorporate one or more <a title=\"Dice\" href=\"https://en.wikipedia.org/wiki/Dice\">dice</a> as their sole or central component, usually as a <a class=\"mw-redirect\" title=\"Random device\" href=\"https://en.wikipedia.org/wiki/Random_device\">random device</a>.</p>\',\n  \'0\', \'A dice game is any game using dices as the primary device with which the game is played, be they traditional or game-specific.',
  0, 'en-GB', 'category', 0, 14, NULL, NULL, NULL ),
( 'introtext', 'A card game is any game using playing cards as the primary device with which the game is played, be they traditional or game-specific. ', 0, 'en-GB', 'category', 0,
  14, NULL, NULL, NULL ),
( 'name', 'Card Games', 0, 'en-GB', 'category', 0, 14, NULL, NULL, NULL ),
( 'description',
  '<p><b>PC games</b>, also known as <b>computer games</b> or <b>personal computer games</b>, are <a title=\"Video game\" href=\"https://en.wikipedia.org/wiki/Video_game\">video games</a> played on a <a title=\"Personal computer\" href=\"https://en.wikipedia.org/wiki/Personal_computer\">personal computer</a> rather than a dedicated <a title=\"Video game console\" href=\"https://en.wikipedia.org/wiki/Video_game_console\">video game console</a> or <a class=\"mw-redirect\" title=\"Arcade machine\" href=\"https://en.wikipedia.org/wiki/Arcade_machine\">arcade machine</a>. </p>',
  0, 'en-GB', 'category', 0, 15, NULL, NULL, NULL ),
( 'introtext',
  'PC games, also known as computer games or personal computer games, are video games played on a personal computer rather than a dedicated video game console or arcade machine. ',
  0, 'en-GB', 'category', 0, 15, NULL, NULL, NULL ),
( 'name', 'Computer Games', 0, 'en-GB', 'category', 0, 15, NULL, NULL, NULL ),
( 'description',
  '<p>A <b>puzzle</b> is a <a title=\"Game\" href=\"https://en.wikipedia.org/wiki/Game\">game</a>, <a class=\"mw-redirect\" title=\"Problem\" href=\"https://en.wikipedia.org/wiki/Problem\">problem</a>, or <a title=\"Toy\" href=\"https://en.wikipedia.org/wiki/Toy\">toy</a> that tests a person\\\'s <a title=\"Ingenuity\" href=\"https://en.wikipedia.org/wiki/Ingenuity\">ingenuity</a> or knowledge. In a puzzle, one is required to put pieces together in a logical way, in order to arrive at the correct solution of the puzzle.</p>',
  0, 'en-GB', 'category', 0, 16, NULL, NULL, NULL ),
( 'introtext',
  'A puzzle is a game, problem, or toy that tests a person\\\'s ingenuity or knowledge. In a puzzle, one is required to put pieces together in a logical way, in order to arrive at the correct solution of the puzzle. ',
  0, 'en-GB', 'category', 0, 16, NULL, NULL, NULL ),
( 'name', 'Puzzles', 0, 'en-GB', 'category', 0, 16, NULL, NULL, NULL ),
( 'description',
  '<p>A <b>video game</b> is an <a title=\"Electronic game\" href=\"https://en.wikipedia.org/wiki/Electronic_game\">electronic game</a> that involves human interaction with a <a title=\"User interface\" href=\"https://en.wikipedia.org/wiki/User_interface\">user interface</a> to generate visual feedback on a <a title=\"Video\" href=\"https://en.wikipedia.org/wiki/Video\">video device</a>. The word <i>video</i> in <i>video game</i> traditionally referred to a <a title=\"Raster scan\" href=\"https://en.wikipedia.org/wiki/Raster_scan\">raster</a> display device,<sup id=\"cite_ref-1\" class=\"reference\"></sup> but it now implies any type of <a title=\"Display device\" href=\"https://en.wikipedia.org/wiki/Display_device\">display device</a> that can produce two- or three-dimensional images.</p>',
  0, 'en-GB', 'category', 0, 17, NULL, NULL, NULL ),
( 'introtext', 'A video game is an electronic game that involves human interaction with a user interface to generate visual feedback on a video device. ', 0, 'en-GB', 'category',
  0, 17, NULL, NULL, NULL ),
( 'name', 'Video Games', 0, 'en-GB', 'category', 0, 17, NULL, NULL, NULL ),
( 'description',
  '<p><b>Physical attractiveness</b> is the degree to which a person\\\'s physical traits are considered <a class=\"mw-redirect\" title=\"Aesthetic\" href=\"https://en.wikipedia.org/wiki/Aesthetic\">aesthetically</a> pleasing or <a title=\"Beauty\" href=\"https://en.wikipedia.org/wiki/Beauty\">beautiful</a>. The term often implies <a title=\"Sexual attraction\" href=\"https://en.wikipedia.org/wiki/Sexual_attraction\">sexual attractiveness</a> or desirability, but can also be distinct from the two. </p>',
  0, 'en-GB', 'category', 0, 18, NULL, NULL, NULL ),
( 'introtext', 'Physical attractiveness is the degree to which a person\\\'s physical traits are considered aesthetically pleasing or beautiful. ', 0, 'en-GB', 'category', 0, 18,
  NULL, NULL, NULL ),
( 'name', 'Beauty', 0, 'en-GB', 'category', 0, 18, NULL, NULL, NULL ),
( 'description',
  '<p><b>Physical fitness</b> is a general state of <a title=\"Health\" href=\"https://en.wikipedia.org/wiki/Health\">health</a> and well-being and, more specifically, the ability to perform aspects of <a title=\"Outline of sports\" href=\"https://en.wikipedia.org/wiki/Outline_of_sports\">sports</a> or occupations. Physical fitness is generally achieved through correct <a title=\"Nutrition\" href=\"https://en.wikipedia.org/wiki/Nutrition\">nutrition</a>, moderate-vigorous physical activity, <a title=\"Physical exercise\" href=\"https://en.wikipedia.org/wiki/Physical_exercise\">exercise</a> and rest.</p>',
  0, 'en-GB', 'category', 0, 19, NULL, NULL, NULL ),
( 'introtext', 'Physical fitness is a general state of health and well-being and, more specifically, the ability to perform aspects of sports or occupations. ', 0, 'en-GB',
  'category', 0, 19, NULL, NULL, NULL ),
( 'name', 'Fitness', 0, 'en-GB', 'category', 0, 19, NULL, NULL, NULL ),
( 'description',
  '<p><b>Pharmacy</b> is the science and technique of preparing and dispensing <a title=\"Drug\" href=\"https://en.wikipedia.org/wiki/Drug\">drugs</a>. It is a <a class=\"mw-redirect\" title=\"Health profession\" href=\"https://en.wikipedia.org/wiki/Health_profession\">health profession</a> that links <a class=\"mw-redirect\" title=\"Health science\" href=\"https://en.wikipedia.org/wiki/Health_science\">health sciences</a> with <a title=\"Chemistry\" href=\"https://en.wikipedia.org/wiki/Chemistry\">chemical sciences</a> and aims to ensure the safe and effective use of <a title=\"Pharmaceutical drug\" href=\"https://en.wikipedia.org/wiki/Pharmaceutical_drug\">pharmaceutical drugs</a>.</p>',
  0, 'en-GB', 'category', 0, 20, NULL, NULL, NULL ),
( 'introtext',
  'Pharmacy is the science and technique of preparing and dispensing drugs. It is a health profession that links health sciences with chemical sciences and aims to ensure the safe and effective use of pharmaceutical drugs.',
  0, 'en-GB', 'category', 0, 20, NULL, NULL, NULL ),
( 'name', 'Pharmacy', 0, 'en-GB', 'category', 0, 20, NULL, NULL, NULL ),
( 'description',
  '<p><b>Weight loss</b>, in the context of medicine, health, or <a title=\"Physical fitness\" href=\"https://en.wikipedia.org/wiki/Physical_fitness\">physical fitness</a>, refers to a reduction of the total <a class=\"mw-redirect\" title=\"Body mass\" href=\"https://en.wikipedia.org/wiki/Body_mass\">body mass</a>, due to a mean loss of fluid, body fat or <a title=\"Adipose tissue\" href=\"https://en.wikipedia.org/wiki/Adipose_tissue\">adipose tissue</a> and/or lean mass, namely bone mineral deposits, muscle, tendon, and other connective tissue.</p>',
  0, 'en-GB', 'category', 0, 21, NULL, NULL, NULL ),
( 'introtext',
  'Weight loss, in the context of medicine, health, or physical fitness, refers to a reduction of the total body mass, due to a mean loss of fluid, body fat or adipose tissue and/or lean mass, namely bone mineral deposits, muscle, tendon, and other connective tissue.',
  0, 'en-GB', 'category', 0, 21, NULL, NULL, NULL ),
( 'name', 'Weight Loss', 0, 'en-GB', 'category', 0, 21, NULL, NULL, NULL ),
( 'description',
  '<p><b>Do it yourself</b>, also known as <b>DIY</b>, is the method of building, modifying, or <a class=\"mw-redirect\" title=\"Repair\" href=\"https://en.wikipedia.org/wiki/Repair\">repairing</a> something without the aid of experts or professionals.</p>',
  0, 'en-GB', 'category', 0, 22, NULL, NULL, NULL ),
( 'introtext', 'Do it yourself, also known as DIY, is the method of building, modifying, or repairing something without the aid of experts or professionals.', 0, 'en-GB',
  'category', 0, 22, NULL, NULL, NULL ),
( 'name', 'Do-It-Yourself', 0, 'en-GB', 'category', 0, 22, NULL, NULL, NULL ),
( 'description',
  '<p><b>Relocation</b>, also known as <b>moving</b>, is the process of vacating a fixed location (such as a residence or business) and settling in a different one.</p>', 0,
  'en-GB', 'category', 0, 23, NULL, NULL, NULL ),
( 'introtext', 'Relocation, also known as moving, is the process of vacating a fixed location (such as a residence or business) and settling in a different one. ', 0, 'en-GB',
  'category', 0, 23, NULL, NULL, NULL ),
( 'name', 'Moving and Relocating', 0, 'en-GB', 'category', 0, 23, NULL, NULL, NULL ),
( 'description',
  '<p><b>Personal finance</b> is the financial management which an individual or a family unit is required to do to obtain, <a title=\"Personal budget\" href=\"https://en.wikipedia.org/wiki/Personal_budget\">budget</a>, save, and spend monetary resources over time, taking into account various financial risks and future life events.</p>',
  0, 'en-GB', 'category', 0, 24, NULL, NULL, NULL ),
( 'introtext',
  'Personal finance is the financial management which an individual or a family unit is required to do to obtain, budget, save, and spend monetary resources over time, taking into account various financial risks and future life events.',
  0, 'en-GB', 'category', 0, 24, NULL, NULL, NULL ),
( 'name', 'Personal Finance', 0, 'en-GB', 'category', 0, 24, NULL, NULL, NULL ),
( 'description',
  '<p>A <b>pet</b> is an <a title=\"Animal\" href=\"https://en.wikipedia.org/wiki/Animal\">animal</a> kept primarily for a person\\\'s company or protection, as opposed to <a title=\"Working animal\" href=\"https://en.wikipedia.org/wiki/Working_animal\">working animals</a>, <a class=\"mw-redirect\" title=\"Sport animal\" href=\"https://en.wikipedia.org/wiki/Sport_animal\">sport animals</a>, <a title=\"Livestock\" href=\"https://en.wikipedia.org/wiki/Livestock\">livestock</a>, and <a class=\"mw-redirect\" title=\"Laboratory animal\" href=\"https://en.wikipedia.org/wiki/Laboratory_animal\">laboratory animals</a>, which are kept primarily for performance, agricultural value, or research.</p>',
  0, 'en-GB', 'category', 0, 25, NULL, NULL, NULL ),
( 'introtext',
  'A pet is an animal kept primarily for a person\\\'s company or protection, as opposed to working animals, sport animals, livestock, and laboratory animals, which are kept primarily for performance, agricultural value, or research. ',
  0, 'en-GB', 'category', 0, 25, NULL, NULL, NULL ),
( 'name', 'Pets', 0, 'en-GB', 'category', 0, 25, NULL, NULL, NULL ),
( 'description',
  '<p>An <b>Internet forum</b>, or <b>message board</b>, is an <a class=\"mw-redirect\" title=\"Online\" href=\"https://en.wikipedia.org/wiki/Online\">online</a> discussion site where people can hold conversations in the form of posted messages. They differ from <a class=\"mw-redirect\" title=\"Chat rooms\" href=\"https://en.wikipedia.org/wiki/Chat_rooms\">chat rooms</a> in that messages are often longer than one line of text, and are at least temporarily archived.</p>',
  0, 'en-GB', 'category', 0, 26, NULL, NULL, NULL ),
( 'introtext', 'An Internet forum, or message board, is an online discussion site where people can hold conversations in the form of posted messages.', 0, 'en-GB', 'category', 0,
  26, NULL, NULL, NULL ),
( 'name', 'Chats and Forums', 0, 'en-GB', 'category', 0, 26, NULL, NULL, NULL ),
( 'description',
  '<p><b>Event management</b> is the application of <a title=\"Project management\" href=\"https://en.wikipedia.org/wiki/Project_management\">project management</a> to the creation and development of large scale events such as <a title=\"Festival\" href=\"https://en.wikipedia.org/wiki/Festival\">festivals</a>, conferences, ceremonies, formal parties, concerts, or <a title=\"Convention (meeting)\" href=\"https://en.wikipedia.org/wiki/Convention_%28meeting%29\">conventions</a>. It involves studying the brand, identifying the <a title=\"Target audience\" href=\"https://en.wikipedia.org/wiki/Target_audience\">target audience</a>, devising the event concept, planning the logistics and coordinating the technical aspects before actually launching the event.<sup id=\"cite_ref-1\" class=\"reference\"></sup></p>',
  0, 'en-GB', 'category', 0, 27, NULL, NULL, NULL ),
( 'introtext',
  'Event management is the application of project management to the creation and development of large scale events such as festivals, conferences, ceremonies, formal parties, concerts, or conventions.',
  0, 'en-GB', 'category', 0, 27, NULL, NULL, NULL ),
( 'name', 'Current Events', 0, 'en-GB', 'category', 0, 27, NULL, NULL, NULL ),
( 'description',
  '<p><b>Journalism</b> is gathering, processing, and dissemination of <a title=\"News\" href=\"https://en.wikipedia.org/wiki/News\">news</a> and information related to the news to an <a title=\"Audience\" href=\"https://en.wikipedia.org/wiki/Audience\">audience</a>. The word applies to both the method of inquiring for news and the literary style which is used to disseminate it.</p>',
  0, 'en-GB', 'category', 0, 28, NULL, NULL, NULL ),
( 'introtext', 'Journalism is gathering, processing, and dissemination of news and information related to the news to an audience. ', 0, 'en-GB', 'category', 0, 28, NULL, NULL,
  NULL ),
( 'name', 'Journalism', 0, 'en-GB', 'category', 0, 28, NULL, NULL, NULL ),
( 'description',
  '<p>A <b>television</b>, commonly referred to as <b>TV</b> or <b>telly</b> is a <a title=\"Telecommunication\" href=\"https://en.wikipedia.org/wiki/Telecommunication\">telecommunication</a> medium used for transmitting sound with moving images in <a title=\"Monochrome\" href=\"https://en.wikipedia.org/wiki/Monochrome\">monochrome</a> (<a title=\"Black-and-white\" href=\"https://en.wikipedia.org/wiki/Black-and-white\">black-and-white</a>), <a class=\"mw-redirect\" title=\"Colour\" href=\"https://en.wikipedia.org/wiki/Colour\">colour</a>, or in <a title=\"3D television\" href=\"https://en.wikipedia.org/wiki/3D_television\">three dimensions</a>. </p>',
  0, 'en-GB', 'category', 0, 29, NULL, NULL, NULL ),
( 'introtext',
  'A television, commonly referred to as TV or telly is a telecommunication medium used for transmitting sound with moving images in monochrome (black-and-white), colour, or in three dimensions.',
  0, 'en-GB', 'category', 0, 29, NULL, NULL, NULL ),
( 'name', 'Television', 0, 'en-GB', 'category', 0, 29, NULL, NULL, NULL ),
( 'description',
  '<p><b>Weather forecasting</b> is the application of science and technology to predict the state of the <a class=\"mw-redirect\" title=\"Earth\\\'s atmosphere\" href=\"https://en.wikipedia.org/wiki/Earth%27s_atmosphere\">atmosphere</a> for a given location. Human beings have attempted to predict the weather informally for millennia, and formally since the nineteenth century.</p>',
  0, 'en-GB', 'category', 0, 30, NULL, NULL, NULL ),
( 'introtext', 'Weather forecasting is the application of science and technology to predict the state of the atmosphere for a given location. ', 0, 'en-GB', 'category', 0, 30,
  NULL, NULL, NULL ),
( 'name', 'Weather', 0, 'en-GB', 'category', 0, 30, NULL, NULL, NULL ),
( 'description',
  '<p>A <b>book</b> is a set of written, printed, illustrated, or blank sheets, made of <a title=\"Ink\" href=\"https://en.wikipedia.org/wiki/Ink\">ink</a>, <a title=\"Paper\" href=\"https://en.wikipedia.org/wiki/Paper\">paper</a>, <a title=\"Parchment\" href=\"https://en.wikipedia.org/wiki/Parchment\">parchment</a>, or other materials, fastened together to hinge at one side. A single sheet within a book is a <a class=\"mw-redirect\" title=\"Recto\" href=\"https://en.wikipedia.org/wiki/Recto\">leaf</a>, and each side of a leaf is a <a title=\"Page (paper)\" href=\"https://en.wikipedia.org/wiki/Page_%28paper%29\">page</a>.</p>',
  0, 'en-GB', 'category', 0, 31, NULL, NULL, NULL ),
( 'introtext', 'A book is a set of written, printed, illustrated, or blank sheets, made of ink, paper, parchment, or other materials, fastened together to hinge at one side.', 0,
  'en-GB', 'category', 0, 31, NULL, NULL, NULL ),
( 'name', 'Books', 0, 'en-GB', 'category', 0, 31, NULL, NULL, NULL ),
( 'description',
  '<p><b>Music</b> is an <a title=\"Art\" href=\"https://en.wikipedia.org/wiki/Art\">art</a> form whose <a class=\"mw-redirect\" title=\"Media (arts)\" href=\"https://en.wikipedia.org/wiki/Media_%28arts%29\">medium</a> is <a title=\"Sound\" href=\"https://en.wikipedia.org/wiki/Sound\">sound</a>. Generally, a <b><a title=\"Song\" href=\"https://en.wikipedia.org/wiki/Song\">song</a></b> is considered the smallest standalone work of music, especially when involving <a title=\"Singing\" href=\"https://en.wikipedia.org/wiki/Singing\">singing</a>.</p>',
  0, 'en-GB', 'category', 0, 32, NULL, NULL, NULL ),
( 'introtext', 'Music is an art form whose medium is sound. ', 0, 'en-GB', 'category', 0, 32, NULL, NULL, NULL ),
( 'name', 'Movies & Music', 0, 'en-GB', 'category', 0, 32, NULL, NULL, NULL ),
( 'description',
  '<p>A <b>toy</b> is an item that can be used for <a title=\"Play (activity)\" href=\"https://en.wikipedia.org/wiki/Play_%28activity%29\">play</a>. Toys are generally played with by <a title=\"Child\" href=\"https://en.wikipedia.org/wiki/Child\">children</a> and <a title=\"Pet\" href=\"https://en.wikipedia.org/wiki/Pet\">pets</a>. Playing with toys is an enjoyable means of training the young for life in society. Different materials are used to make toys enjoyable to both young and old.</p>',
  0, 'en-GB', 'category', 0, 33, NULL, NULL, NULL ),
( 'introtext', 'A toy is an item that can be used for play. Toys are generally played with by children and pets.', 0, 'en-GB', 'category', 0, 33, NULL, NULL, NULL ),
( 'name', 'Toys', 0, 'en-GB', 'category', 0, 33, NULL, NULL, NULL ),
( 'description',
  '<p><b>Home improvement</b>, <b>home renovation</b> or <b>remodeling</b> is the process of <a title=\"Renovation\" href=\"https://en.wikipedia.org/wiki/Renovation\">renovating</a> or making additions to one\\\'s home. <a title=\"Building material\" href=\"https://en.wikipedia.org/wiki/Building_material\">Building materials</a> and hardware for home improvement projects are typically purchased at <a class=\"mw-redirect\" title=\"Home improvement store\" href=\"https://en.wikipedia.org/wiki/Home_improvement_store\">home improvement stores</a>.</p>',
  0, 'en-GB', 'category', 0, 34, NULL, NULL, NULL ),
( 'introtext', 'Home improvement, home renovation or remodeling is the process of renovating or making additions to one\\\'s home. ', 0, 'en-GB', 'category', 0, 34, NULL, NULL,
  NULL ),
( 'name', 'Home Improvement', 0, 'en-GB', 'category', 0, 34, NULL, NULL, NULL ),
( 'description',
  '<p>A <b>car</b> is a wheeled, self-powered <a title=\"Motor vehicle\" href=\"https://en.wikipedia.org/wiki/Motor_vehicle\">motor vehicle</a> used for <a class=\"mw-redirect\" title=\"Transportation\" href=\"https://en.wikipedia.org/wiki/Transportation\">transportation</a>. Most definitions of the term specify that cars are designed to run primarily on roads, to have seating for one to eight people, to typically have four wheels, and to be constructed principally for the transport of people rather than goods.</p>',
  0, 'en-GB', 'category', 0, 36, NULL, NULL, NULL ),
( 'introtext', 'A car is a wheeled, self-powered motor vehicle used for transportation. ', 0, 'en-GB', 'category', 0, 36, NULL, NULL, NULL ),
( 'name', 'Cars', 0, 'en-GB', 'category', 0, 36, NULL, NULL, NULL ),
( 'metaKeys', '', 0, 'en-GB', 'category', 0, 4, NULL, NULL, NULL ),
( 'metaDesc', '', 0, 'en-GB', 'category', 0, 4, NULL, NULL, NULL ),
( 'nid', 'health', 0, 'en-GB', 'category', 0, 4, NULL, NULL, NULL ),
( 'nid', 'communications', 0, 'en-GB', 'category', 0, 8, NULL, NULL, NULL ),
( 'metaKeys', '', 0, 'en-GB', 'category', 0, 8, NULL, NULL, NULL ),
( 'metaDesc', '', 0, 'en-GB', 'category', 0, 8, NULL, NULL, NULL ),
( 'metaKeys', '', 0, 'en-GB', 'category', 0, 2, NULL, NULL, NULL ),
( 'metaDesc', '', 0, 'en-GB', 'category', 0, 2, NULL, NULL, NULL ),
( 'nid', 'computers-and-internet', 0, 'en-GB', 'category', 0, 2, NULL, NULL, NULL ),
( 'metaKeys', '', 0, 'en-GB', 'category', 0, 3, NULL, NULL, NULL ),
( 'metaDesc', '', 0, 'en-GB', 'category', 0, 3, NULL, NULL, NULL ),
( 'nid', 'games', 0, 'en-GB', 'category', 0, 3, NULL, NULL, NULL ),
( 'metaKeys', '', 0, 'en-GB', 'category', 0, 5, NULL, NULL, NULL ),
( 'metaDesc', '', 0, 'en-GB', 'category', 0, 5, NULL, NULL, NULL ),
( 'nid', 'home-garden', 0, 'en-GB', 'category', 0, 5, NULL, NULL, NULL ),
( 'metaKeys', '', 0, 'en-GB', 'category', 0, 6, NULL, NULL, NULL ),
( 'metaDesc', '', 0, 'en-GB', 'category', 0, 6, NULL, NULL, NULL ),
( 'nid', 'news', 0, 'en-GB', 'category', 0, 6, NULL, NULL, NULL ),
( 'metaKeys', '', 0, 'en-GB', 'category', 0, 7, NULL, NULL, NULL ),
( 'metaDesc', '', 0, 'en-GB', 'category', 0, 7, NULL, NULL, NULL ),
( 'nid', 'shopping', 0, 'en-GB', 'category', 0, 7, NULL, NULL, NULL ),
( 'metaKeys', '', 0, 'en-GB', 'category', 0, 9, NULL, NULL, NULL ),
( 'metaDesc', '', 0, 'en-GB', 'category', 0, 9, NULL, NULL, NULL ),
( 'nid', 'graphics', 0, 'en-GB', 'category', 0, 9, NULL, NULL, NULL ),
( 'metaKeys', '', 0, 'en-GB', 'category', 0, 11, NULL, NULL, NULL ),
( 'metaDesc', '', 0, 'en-GB', 'category', 0, 11, NULL, NULL, NULL ),
( 'nid', 'mobile-computing', 0, 'en-GB', 'category', 0, 11, NULL, NULL, NULL ),
( 'metaKeys', '', 0, 'en-GB', 'category', 0, 12, NULL, NULL, NULL ),
( 'metaDesc', '', 0, 'en-GB', 'category', 0, 12, NULL, NULL, NULL ),
( 'nid', 'multimedia', 0, 'en-GB', 'category', 0, 12, NULL, NULL, NULL ),
( 'metaKeys', '', 0, 'en-GB', 'category', 0, 10, NULL, NULL, NULL ),
( 'metaDesc', '', 0, 'en-GB', 'category', 0, 10, NULL, NULL, NULL ),
( 'nid', 'hardware', 0, 'en-GB', 'category', 0, 10, NULL, NULL, NULL ),
( 'metaKeys', '', 0, 'en-GB', 'category', 0, 18, NULL, NULL, NULL ),
( 'metaDesc', '', 0, 'en-GB', 'category', 0, 18, NULL, NULL, NULL ),
( 'nid', 'beauty', 0, 'en-GB', 'category', 0, 18, NULL, NULL, NULL ),
( 'metaKeys', '', 0, 'en-GB', 'category', 0, 19, NULL, NULL, NULL ),
( 'metaDesc', '', 0, 'en-GB', 'category', 0, 19, NULL, NULL, NULL ),
( 'nid', 'fitness', 0, 'en-GB', 'category', 0, 19, NULL, NULL, NULL ),
( 'metaKeys', '', 0, 'en-GB', 'category', 0, 20, NULL, NULL, NULL ),
( 'metaDesc', '', 0, 'en-GB', 'category', 0, 20, NULL, NULL, NULL ),
( 'nid', 'pharmacy', 0, 'en-GB', 'category', 0, 20, NULL, NULL, NULL ),
( 'metaKeys', '', 0, 'en-GB', 'category', 0, 21, NULL, NULL, NULL ),
( 'metaDesc', '', 0, 'en-GB', 'category', 0, 21, NULL, NULL, NULL ),
( 'nid', 'weight-loss', 0, 'en-GB', 'category', 0, 21, NULL, NULL, NULL ),
( 'metaKeys', '', 0, 'en-GB', 'category', 0, 14, NULL, NULL, NULL ),
( 'metaDesc', '', 0, 'en-GB', 'category', 0, 14, NULL, NULL, NULL ),
( 'nid', 'card-games', 0, 'en-GB', 'category', 0, 14, NULL, NULL, NULL ),
( 'metaKeys', '', 0, 'en-GB', 'category', 0, 16, NULL, NULL, NULL ),
( 'metaDesc', '', 0, 'en-GB', 'category', 0, 16, NULL, NULL, NULL ),
( 'nid', 'puzzles', 0, 'en-GB', 'category', 0, 16, NULL, NULL, NULL ),
( 'metaKeys', '', 0, 'en-GB', 'category', 0, 15, NULL, NULL, NULL ),
( 'metaDesc', '', 0, 'en-GB', 'category', 0, 15, NULL, NULL, NULL ),
( 'nid', 'computer-games', 0, 'en-GB', 'category', 0, 15, NULL, NULL, NULL ),
( 'metaKeys', '', 0, 'en-GB', 'category', 0, 17, NULL, NULL, NULL ),
( 'metaDesc', '', 0, 'en-GB', 'category', 0, 17, NULL, NULL, NULL ),
( 'nid', 'video-games', 0, 'en-GB', 'category', 0, 17, NULL, NULL, NULL ),
( 'metaKeys', '', 0, 'en-GB', 'category', 0, 22, NULL, NULL, NULL ),
( 'metaDesc', '', 0, 'en-GB', 'category', 0, 22, NULL, NULL, NULL ),
( 'nid', 'do-it-yourself', 0, 'en-GB', 'category', 0, 22, NULL, NULL, NULL ),
( 'metaKeys', '', 0, 'en-GB', 'category', 0, 23, NULL, NULL, NULL ),
( 'metaDesc', '', 0, 'en-GB', 'category', 0, 23, NULL, NULL, NULL ),
( 'nid', 'moving-and-relocating', 0, 'en-GB', 'category', 0, 23, NULL, NULL, NULL ),
( 'metaKeys', '', 0, 'en-GB', 'category', 0, 24, NULL, NULL, NULL ),
( 'metaDesc', '', 0, 'en-GB', 'category', 0, 24, NULL, NULL, NULL ),
( 'nid', 'personal-finance', 0, 'en-GB', 'category', 0, 24, NULL, NULL, NULL ),
( 'metaKeys', '', 0, 'en-GB', 'category', 0, 25, NULL, NULL, NULL ),
( 'metaDesc', '', 0, 'en-GB', 'category', 0, 25, NULL, NULL, NULL ),
( 'nid', 'pets', 0, 'en-GB', 'category', 0, 25, NULL, NULL, NULL ),
( 'metaKeys', '', 0, 'en-GB', 'category', 0, 36, NULL, NULL, NULL ),
( 'metaDesc', '', 0, 'en-GB', 'category', 0, 36, NULL, NULL, NULL ),
( 'nid', 'cars', 0, 'en-GB', 'category', 0, 36, NULL, NULL, NULL ),
( 'metaKeys', '', 0, 'en-GB', 'category', 0, 31, NULL, NULL, NULL ),
( 'metaDesc', '', 0, 'en-GB', 'category', 0, 31, NULL, NULL, NULL ),
( 'nid', 'books', 0, 'en-GB', 'category', 0, 31, NULL, NULL, NULL ),
( 'metaKeys', '', 0, 'en-GB', 'category', 0, 32, NULL, NULL, NULL ),
( 'metaDesc', '', 0, 'en-GB', 'category', 0, 32, NULL, NULL, NULL ),
( 'nid', 'movies-music', 0, 'en-GB', 'category', 0, 32, NULL, NULL, NULL ),
( 'metaKeys', '', 0, 'en-GB', 'category', 0, 33, NULL, NULL, NULL ),
( 'metaDesc', '', 0, 'en-GB', 'category', 0, 33, NULL, NULL, NULL ),
( 'nid', 'toys', 0, 'en-GB', 'category', 0, 33, NULL, NULL, NULL ),
( 'metaKeys', '', 0, 'en-GB', 'category', 0, 34, NULL, NULL, NULL ),
( 'metaDesc', '', 0, 'en-GB', 'category', 0, 34, NULL, NULL, NULL ),
( 'nid', 'home-improvement', 0, 'en-GB', 'category', 0, 34, NULL, NULL, NULL ),
( 'metaKeys', '', 0, 'en-GB', 'category', 0, 26, NULL, NULL, NULL ),
( 'metaDesc', '', 0, 'en-GB', 'category', 0, 26, NULL, NULL, NULL ),
( 'nid', 'chats-and-forums', 0, 'en-GB', 'category', 0, 26, NULL, NULL, NULL ),
( 'metaKeys', '', 0, 'en-GB', 'category', 0, 27, NULL, NULL, NULL ),
( 'metaDesc', '', 0, 'en-GB', 'category', 0, 27, NULL, NULL, NULL ),
( 'nid', 'current-events', 0, 'en-GB', 'category', 0, 27, NULL, NULL, NULL ),
( 'metaKeys', '', 0, 'en-GB', 'category', 0, 28, NULL, NULL, NULL ),
( 'metaDesc', '', 0, 'en-GB', 'category', 0, 28, NULL, NULL, NULL ),
( 'nid', 'journalism', 0, 'en-GB', 'category', 0, 28, NULL, NULL, NULL ),
( 'metaKeys', '', 0, 'en-GB', 'category', 0, 29, NULL, NULL, NULL ),
( 'metaDesc', '', 0, 'en-GB', 'category', 0, 29, NULL, NULL, NULL ),
( 'nid', 'television', 0, 'en-GB', 'category', 0, 29, NULL, NULL, NULL ),
( 'metaKeys', '', 0, 'en-GB', 'category', 0, 30, NULL, NULL, NULL ),
( 'metaDesc', '', 0, 'en-GB', 'category', 0, 30, NULL, NULL, NULL ),
( 'nid', 'weather', 0, 'en-GB', 'category', 0, 30, NULL, NULL, NULL ),
( 'name', 'Company Name', 0, 'en-GB', 'field', 1, 0, NULL, NULL, NULL ),
( 'description', '', 0, 'en-GB', 'field', 1, 0, NULL, NULL, NULL ),
( 'name', 'Postcode', 0, 'en-GB', 'field', 2, 0, NULL, NULL, NULL ),
( 'description', '', 0, 'en-GB', 'field', 2, 0, NULL, NULL, NULL ),
( 'name', 'City', 0, 'en-GB', 'field', 3, 0, NULL, NULL, NULL ),
( 'description', '', 0, 'en-GB', 'field', 3, 0, NULL, NULL, NULL ),
( 'name', 'Contact Person', 0, 'en-GB', 'field', 4, 0, NULL, NULL, NULL ),
( 'description', '', 0, 'en-GB', 'field', 4, 0, NULL, NULL, NULL ),
( 'name', 'Phone', 0, 'en-GB', 'field', 5, 0, NULL, NULL, NULL ),
( 'description', '', 0, 'en-GB', 'field', 5, 0, NULL, NULL, NULL ),
( 'name', 'Fax', 0, 'en-GB', 'field', 6, 0, NULL, NULL, NULL ),
( 'description', '', 0, 'en-GB', 'field', 6, 0, NULL, NULL, NULL ),
( 'name', 'Email address', 0, 'en-GB', 'field', 7, 0, NULL, NULL, NULL ),
( 'description', 'The entered email address will not be visible on the site!', 0, 'en-GB', 'field', 7, 0, NULL, NULL, NULL ),
( 'name', 'Short Description', 0, 'en-GB', 'field', 8, 0, NULL, NULL, NULL ),
( 'description', 'The short description will be displayed at the category listing pages. Maximum length is 300 characters. ', 0, 'en-GB', 'field', 8, 0, NULL, NULL, NULL ),
( 'name', 'Full Description', 0, 'en-GB', 'field', 9, 0, NULL, NULL, NULL ),
( 'description', 'The full company description will be displayed at your company\\\'s page in the directory.', 0, 'en-GB', 'field', 9, 0, NULL, NULL, NULL ),
( 'name', 'Company Logo', 0, 'en-GB', 'field', 10, 0, NULL, NULL, NULL ),
( 'description',
  'Upload your company logo. The file types bmp, gif, jpg and png are allowed. The maximum file size is 40MB. Your image will be resized to 900px x 675px. You have the possibility to crop the image before you save the entry.',
  0, 'en-GB', 'field', 10, 0, NULL, NULL, NULL ),
( 'name', 'Website', 0, 'en-GB', 'field', 11, 0, NULL, NULL, NULL ),
( 'description', '', 0, 'en-GB', 'field', 11, 0, NULL, NULL, NULL ),
( 'name', 'Business Days', 0, 'en-GB', 'field', 12, 0, NULL, NULL, NULL ),
( 'description', '', 0, 'en-GB', 'field', 12, 0, NULL, NULL, NULL ),
( 'sunday', 'Sunday', 0, 'en-GB', 'field_option', 12, 0, NULL, NULL, NULL ),
( 'saturday', 'Saturday', 0, 'en-GB', 'field_option', 12, 0, NULL, NULL, NULL ),
( 'friday', 'Friday', 0, 'en-GB', 'field_option', 12, 0, NULL, NULL, NULL ),
( 'thursday', 'Thursday', 0, 'en-GB', 'field_option', 12, 0, NULL, NULL, NULL ),
( 'wednesday', 'Wednesday', 0, 'en-GB', 'field_option', 12, 0, NULL, NULL, NULL ),
( 'tuesday', 'Tuesday', 0, 'en-GB', 'field_option', 12, 0, NULL, NULL, NULL ),
( 'monday', 'Monday', 0, 'en-GB', 'field_option', 12, 0, NULL, NULL, NULL ),
( 'name', 'Country', 0, 'en-GB', 'field', 13, 0, NULL, NULL, NULL ),
( 'description', '', 0, 'en-GB', 'field', 13, 0, NULL, NULL, NULL ),
( 'johnston-atoll', 'Johnston Atoll', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'palau', 'Palau', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'jarvis-island', 'Jarvis Island', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'niue', 'Niue', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'howland-island', 'Howland Island', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'micronesia', 'Micronesia', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'french-polynesia', 'French Polynesia', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'nauru', 'Nauru', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'kiribati', 'Kiribati', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'coral-sea-islands', 'Coral Sea Islands', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'guam', 'Guam', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'cook-islands', 'Cook Islands', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'baker-island', 'Baker Island', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'fiji', 'Fiji', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'ashmore-and-cartier', 'Ashmore and Cartier Islands', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'american-samoa', 'American Samoa', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'oceania', 'Oceania', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'australia', 'Australia', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'french-guiana', 'French Guiana', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'falkland-islands', 'Falkland Islands', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'south-america', 'South America', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'venezuela', 'Venezuela', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'uruguay', 'Uruguay', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'suriname', 'Suriname', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'peru', 'Peru', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'paraguay', 'Paraguay', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'guyana', 'Guyana', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'virgin-islands', 'United States Virgin Islands', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'ecuador', 'Ecuador', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'colombia', 'Colombia', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'brazil', 'Brazil', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'chile', 'Chile', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'bolivia', 'Bolivia', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'turks-and-caicos-islands', 'Turks and Caicos Islands', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'argentina', 'Argentina', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'usa', 'United States', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'trinidad-and-tobago', 'Trinidad and Tobago', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'saint-vincent-grenadines', 'Saint Vincent and the Grenadines', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'saint-pierre-and-miquelon', 'Saint Pierre and Miquelon', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'saint-martin', 'Saint Martin', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'saint-lucia', 'Saint Lucia', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'saint-kitts-and-nevis', 'Saint Kitts and Nevis', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'saint-barthelemy', 'Saint Barthélemy', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'puerto-rico', 'Puerto Rico', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'nicaragua', 'Nicaragua', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'panama', 'Panama', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'netherlands-antilles', 'Netherlands Antilles', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'navassa-island', 'Navassa Island', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'montserrat', 'Montserrat', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'mexico', 'Mexico', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'martinique', 'Martinique', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'jamaica', 'Jamaica', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'honduras', 'Honduras', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'haiti', 'Haiti', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'guatemala', 'Guatemala', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'guadeloupe', 'Guadeloupe', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'grenada', 'Grenada', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'el-salvador', 'El Salvador', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'greenland', 'Greenland', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'dominican-republic', 'Dominican Republic', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'dominica', 'Dominica', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'cuba', 'Cuba', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'costa-rica', 'Costa Rica', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'clipperton-island', 'Clipperton Island', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'canada', 'Canada', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'cayman-islands', 'Cayman Islands', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'british-virgin-islands', 'British Virgin Islands', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'bermuda', 'Bermuda', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'belize', 'Belize', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'barbados', 'Barbados', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'aruba', 'Aruba', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'bahamas', 'Bahamas', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'antigua-and-barbuda', 'Antigua and Barbuda', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'anguilla', 'Anguilla', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'north-america', 'North America', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'vatican', 'Vatican City', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'ukraine', 'Ukraine', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'transnistria', 'Transnistria', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'switzerland', 'Switzerland', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'sweden', 'Sweden', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'svalbard', 'Svalbard', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'spain', 'Spain', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'slovenia', 'Slovenia', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'serbia', 'Serbia', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'slovakia', 'Slovakia', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'russia', 'Russia', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'united-kingdom', 'United Kingdom', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'romania', 'Romania', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'portugal', 'Portugal', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'poland', 'Poland', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'norway', 'Norway', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'netherlands', 'Netherlands', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'montenegro', 'Montenegro', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'monaco', 'Monaco', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'kosovo', 'Kosovo', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'latvia', 'Latvia', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'liechtenstein', 'Liechtenstein', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'lithuania', 'Lithuania', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'luxembourg', 'Luxembourg', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'macedonia', 'North Macedonia', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'malta', 'Malta', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'moldova', 'Moldova', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'jersey', 'Jersey', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'italy', 'Italy', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'ireland', 'Ireland', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'san-marino', 'San Marino', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'iceland', 'Iceland', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'hungary', 'Hungary', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'guernsey', 'Guernsey', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'greece', 'Greece', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'gibraltar', 'Gibraltar', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'germany', 'Germany', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'isle-of-man', 'Isle of Man', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'france', 'France', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'finland', 'Finland', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'estonia', 'Estonia', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'denmark', 'Denmark', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'faroe-islands', 'Faroe Islands', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'belgium', 'Belgium', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'czech-republic', 'Czech Republic', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'croatia', 'Croatia', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'bulgaria', 'Bulgaria', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'belarus', 'Belarus', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'andorra', 'Andorra', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'austria', 'Austria', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'albania', 'Albania', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'vietnam', 'Vietnam', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'yemen', 'Yemen', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'bosnia-herzegovina', 'Bosnia and Herzegovina', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'uzbekistan', 'Uzbekistan', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'aland-islands', 'Åland Islands', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'turkmenistan', 'Turkmenistan', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'turkey', 'Turkey', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'thailand', 'Thailand', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'timor-leste', 'Timor-Leste', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'tajikistan', 'Tajikistan', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'europe', 'Europe', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'syria', 'Syria', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'singapore', 'Singapore', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'philippines', 'Philippines', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'qatar', 'Qatar', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'united-arab-emirates', 'United Arab Emirates', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'sri-lanka', 'Sri Lanka', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'pakistan', 'Pakistan', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'nepal', 'Nepal', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'oman', 'Oman', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'south-ossetia', 'South Ossetia', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'nagorno-karabakh', 'Nagorno-Karabakh', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'maldives', 'Maldives', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'mongolia', 'Mongolia', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'myanmar', 'Myanmar', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'macau', 'Macau', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'malaysia', 'Malaysia', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'lebanon', 'Lebanon', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'laos', 'Laos', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'saudi-arabia', 'Saudi Arabia', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'kuwait', 'Kuwait', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'kyrgyzstan', 'Kyrgyzstan', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'kazakhstan', 'Kazakhstan', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'jordan', 'Jordan', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'japan', 'Japan', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'israel', 'Israel', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'iraq', 'Iraq', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'iran', 'Iran', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'palestinian-territories', 'Palestinian territories', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'india', 'India', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'indonesia', 'Indonesia', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'georgia', 'Georgia', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'cyprus', 'Cyprus', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'taiwan', 'China, Republic of - Taiwan', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'northern-cyprus', 'Northern Cyprus', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'china', 'China', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'cambodia', 'Cambodia', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'brunei', 'Brunei', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'korea-republic', 'Korea, Republic of', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'bhutan', 'Bhutan', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'bangladesh', 'Bangladesh', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'bahrain', 'Bahrain', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'azerbaijan', 'Azerbaijan', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'armenia', 'Armenia', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'north-korea', 'Korea, Democratic People\'s Republic of', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'afghanistan', 'Afghanistan', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'zambia', 'Zambia', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'zimbabwe', 'Zimbabwe', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'Asia', 'Asia', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'abkhazia', 'Abkhazia', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'hong-kong', 'Hong Kong', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'uganda', 'Uganda', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'tunisia', 'Tunisia', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'swaziland', 'Swaziland', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'sudan', 'Sudan', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'somalia', 'Somalia', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'somaliland', 'Somaliland', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'cocos-islands', 'Cocos (Keeling) Islands', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'senegal', 'Senegal', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'seychelles', 'Seychelles', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'christmas-island', 'Christmas Island', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'rwanda', 'Rwanda', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'niger', 'Niger', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'nigeria', 'Nigeria', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'namibia', 'Namibia', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'mozambique', 'Mozambique', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'mayotte', 'Mayotte', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'morocco', 'Morocco', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'mauritius', 'Mauritius', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'mauritania', 'Mauritania', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'mali', 'Mali', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'malawi', 'Malawi', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'madagascar', 'Madagascar', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'libya', 'Libya', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'liberia', 'Liberia', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'lesotho', 'Lesotho', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'kenya', 'Kenya', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'guinea-bissau', 'Guinea-Bissau', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'guinea', 'Guinea', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'ghana', 'Ghana', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'gambia', 'Gambia', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'gabon', 'Gabon', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'ethiopia', 'Ethiopia', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'eritrea', 'Eritrea', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'british-indian', 'British Indian Ocean Territory', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'egypt', 'Egypt', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'djibouti', 'Djibouti', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'akrotiri-and-dhekelia', 'Akrotiri and Dhekelia', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'western-sahara', 'Western Sahara', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'south-africa', 'South Africa', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'comoros', 'Comoros', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'chad', 'Chad', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'sierra-leone', 'Sierra Leone', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'cameroon', 'Cameroon', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'burundi', 'Burundi', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'sao-tome-and-principe', 'São Tomé and Príncipe', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'botswana', 'Botswana', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'benin', 'Benin', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'angola', 'Angola', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'algeria', 'Algeria', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'africa', 'Africa', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'reunion', 'Réunion', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'samoa', 'Samoa', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'equatorial-guinea', 'Equatorial Guinea', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'tokelau', 'Tokelau', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'tonga', 'Tonga', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'tuvalu', 'Tuvalu', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'vanuatu', 'Vanuatu', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'cote-d-ivoire', 'Côte d\'Ivoire', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'congo-republic-of', 'Congo, Republic of', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'congo-democratic', 'Congo, Democratic Republic of', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'central-african-republic', 'Central African Republic', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'burkina-faso', 'Burkina Faso', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'cape-verde', 'Cape Verde', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'kingman-reef', 'Kingman Reef', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'marshall-islands', 'Marshall Islands', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'midway-atoll', 'Midway Atoll', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'new-caledonia', 'New Caledonia', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'new-zealand', 'New Zealand', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'norfolk-island', 'Norfolk Island', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'northern-mariana-islands', 'Northern Mariana Islands', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'palmyra-atoll', 'Palmyra Atoll', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'papua-new-guinea', 'Papua New Guinea', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'pitcairn-islands', 'Pitcairn Islands', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'solomon-islands', 'Solomon Islands', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'wake-island', 'Wake Island', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'wallis-and-futuna', 'Wallis and Futuna', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'antarctica', 'Antarctica', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'bouvet-island', 'Bouvet Island', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'french-southern-territories', 'French Southern Territories', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'heard-island-mcdonald-islands', 'Heard Island and McDonald Islands', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'south-georgia-south-sandwich-islands', 'South Georgia and the South Sandwich Islands', 0, 'en-GB', 'field_option', 13, 0, NULL, NULL, NULL ),
( 'suffix', '', 0, 'en-GB', 'field', 6, 0, NULL, NULL, NULL ),
( 'name', 'Street', 0, 'en-GB', 'field', 14, 0, NULL, NULL, NULL ),
( 'name', 'Category', 0, 'en-GB', 'field', 15, 0, NULL, NULL, NULL ),
( 'field_contact_information-entryInfo', '<h4>Contact Information</h4>', 1, 'en-GB', 'field_info', 16, 1, '', '', '' ),
( 'field_contact_information-viewInfo',
  '<p class=\"mt-2\">\r\n<span class=\"fas fa-comments fa-lg\"></span> <em>If you have any questions, please get in contact with us.</em></p>', 1, 'en-GB', 'field_info', 16, 1, '',
  '', '' ),
( 'name', 'Contact Information', 0, 'en-GB', 'field', 16, 0, NULL, NULL, NULL ),
( 'suffix', '', 0, 'en-GB', 'field', 16, 0, NULL, NULL, NULL ),
( 'description', 'Enter your preferred contact data below. You can specify a contact person, a phone and fax number.', 0, 'en-GB', 'field', 16, 0, NULL, NULL, NULL ),
( 'description', '', 0, 'en-GB', 'field', 14, 0, NULL, NULL, NULL ),
( 'suffix', '', 0, 'en-GB', 'field', 14, 0, NULL, NULL, NULL ),
( 'suffix', '', 0, 'en-GB', 'field', 3, 0, NULL, NULL, NULL ),
( 'suffix', '', 0, 'en-GB', 'field', 13, 0, NULL, NULL, NULL ),
( 'suffix', '', 0, 'en-GB', 'field', 11, 0, NULL, NULL, NULL ),
( 'suffix', '', 0, 'en-GB', 'field', 10, 0, NULL, NULL, NULL ),
( 'suffix', '', 0, 'en-GB', 'field', 9, 0, NULL, NULL, NULL ),
( 'suffix', '', 0, 'en-GB', 'field', 2, 0, NULL, NULL, NULL ),
( 'suffix', '', 0, 'en-GB', 'field', 7, 0, NULL, NULL, NULL ),
( 'suffix', '', 0, 'en-GB', 'field', 1, 0, NULL, NULL, NULL ),
( 'suffix', '', 0, 'en-GB', 'field', 5, 0, NULL, NULL, NULL ),
( 'suffix', '', 0, 'en-GB', 'field', 4, 0, NULL, NULL, NULL ),
( 'suffix', '', 0, 'en-GB', 'field', 12, 0, NULL, NULL, NULL ),
( 'suffix', '', 0, 'en-GB', 'field', 8, 0, NULL, NULL, NULL ),
( 'field_name-placeholder', 'your company name', 1, 'en-GB', 'field_inbox', 1, 1, '', '', '' ),
( 'description', 'You can select up to 5 categories for your entry. Please note that parent categories are not selectable.', 0, 'en-GB', 'field', 15, 0, NULL, NULL, NULL ),
( 'suffix', '', 0, 'en-GB', 'field', 15, 0, NULL, NULL, NULL ),
( 'field_email-placeholder', '', 1, 'en-GB', 'field_inbox', 7, 1, '', '', '' ),
( 'field_street-placeholder', '', 1, 'en-GB', 'field_inbox', 14, 1, '', '', '' ),
( 'field_city-placeholder', 'City*', 1, 'en-GB', 'field_inbox', 3, 1, '', '', '' ),
( 'field_zip-placeholder', '', 1, 'en-GB', 'field_inbox', 2, 1, '', '', '' ),
( 'field_country-select-label', '--- select %s ---', 1, 'en-GB', 'field_select', 13, 1, '', '', '' ),
( 'field_contact-placeholder', '', 1, 'en-GB', 'field_inbox', 4, 1, '', '', '' ),
( 'field_phone-placeholder', '', 1, 'en-GB', 'field_inbox', 5, 1, '', '', '' ),
( 'name', 'Address Information', 0, 'en-GB', 'field', 17, 0, NULL, NULL, NULL ),
( 'description', 'Please fill in your address (street, city, postal code and country) below.', 0, 'en-GB', 'field', 17, 0, NULL, NULL, NULL ),
( 'suffix', '', 0, 'en-GB', 'field', 17, 0, NULL, NULL, NULL ),
( 'field_address_information-viewInfo', '', 1, 'en-GB', 'field_info', 17, 1, '', '', '' ),
( 'field_address_information-entryInfo', '<h4>Address Information</h4>', 1, 'en-GB', 'field_info', 17, 1, '', '', '' ),
( 'field_fax-placeholder', '', 1, 'en-GB', 'field_inbox', 6, 1, '', '', '' ),
( 'field_website-labels-label', 'Visit our Site', 1, 'en-GB', 'field_url', 11, 1, '', '', '' ),
( 'field_business_days-select-label', '--- select %s ---', 1, 'en-GB', 'field_chbxgroup', 12, 1, '', '', '' ),
( 'field_short_description-placeholder', '', 1, 'en-GB', 'field_textarea', 8, 1, '', '', '' ),
( 'field_full_description-placeholder', '', 1, 'en-GB', 'field_textarea', 9, 1, '', '', '' ),
( 'nid', 'sun-bookstore', 0, 'en-GB', 'entry', 0, 39, NULL, NULL, NULL ),
( 'metaDesc', '', 0, 'en-GB', 'entry', 0, 39, NULL, NULL, NULL ),
( 'metaKeys', '', 0, 'en-GB', 'entry', 0, 39, NULL, NULL, NULL ),
( 'nid', 'natural-communications', 0, 'en-GB', 'entry', 0, 38, NULL, NULL, NULL ),
( 'metaDesc', '', 0, 'en-GB', 'entry', 0, 38, NULL, NULL, NULL ),
( 'metaKeys', '', 0, 'en-GB', 'entry', 0, 38, NULL, NULL, NULL ),
( 'nid', 'neotrin-electronics', 0, 'en-GB', 'entry', 0, 37, NULL, NULL, NULL ),
( 'metaDesc', '', 0, 'en-GB', 'entry', 0, 37, NULL, NULL, NULL ),
( 'metaKeys', '', 0, 'en-GB', 'entry', 0, 37, NULL, NULL, NULL ),
( 'nid', 'good-health-ltd', 0, 'en-GB', 'entry', 0, 40, NULL, NULL, NULL ),
( 'metaDesc', '', 0, 'en-GB', 'entry', 0, 40, NULL, NULL, NULL ),
( 'metaKeys', '', 0, 'en-GB', 'entry', 0, 40, NULL, NULL, NULL ),
( 'nid', 'trinity-pet-supplies', 0, 'en-GB', 'entry', 0, 41, NULL, NULL, NULL ),
( 'metaDesc', '', 0, 'en-GB', 'entry', 0, 41, NULL, NULL, NULL ),
( 'metaKeys', '', 0, 'en-GB', 'entry', 0, 41, NULL, NULL, NULL );

# insert object data (for entries and categories; non-language dependant)

INSERT IGNORE INTO `#__sobipro_object`( `id`, `nid`, `name`, `approved`, `confirmed`, `counter`, `cout`, `coutTime`, `createdTime`, `defURL`, `metaDesc`, `metaKeys`, `metaAuthor`,
                                        `metaRobots`, `options`, `oType`, `owner`, `ownerIP`, `params`, `section`, `parent`, `state`, `stateExpl`, `updatedTime`, `updater`,
                                        `updaterIP`, `validSince`, `validUntil`, `version` )
VALUES
( 1, 'business-directory', '', 1, 1, 0, 0, '0000-00-00 00:00:00', '2024-01-01 00:00:00', '', 'Business Directory', 'Business, Directory', 'Sigsiu.NET GmbH', '', '', 'section', 0,
  '000.000.000.000', '', 0, 1, 1, '', '0000-00-00 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', '0000-00-00 00:00:00', 1 ),
( 2, 'computers-and-internet', '', 1, 0, 0, 0, '0000-00-00 00:00:00', '2024-01-01 00:00:00', '', '', '', '', '', '', 'category', 0, '000.000.000.000',
  'YToyOntzOjk6Imljb24tZm9udCI7czoxNDoiZm9udC1hd2Vzb21lLTUiO3M6MTk6Imljb24tZm9udC1hZGQtY2xhc3MiO3M6MDoiIjt9', 1, 1, 1, '', '2024-01-01 00:00:00', 0, '000.000.000.000',
  '2024-01-01 00:00:00', '0000-00-00 00:00:00', 1 ),
( 3, 'games', '', 1, 0, 0, 0, '0000-00-00 00:00:00', '2024-01-01 00:00:00', '', '', '', '', '', '', 'category', 0, '000.000.000.000',
  'YToyOntzOjk6Imljb24tZm9udCI7czoxNDoiZm9udC1hd2Vzb21lLTUiO3M6MTk6Imljb24tZm9udC1hZGQtY2xhc3MiO3M6MDoiIjt9', 1, 1, 1, '', '2024-01-01 00:00:00', 0, '000.000.000.000',
  '2024-01-01 00:00:00', '0000-00-00 00:00:00', 1 ),
( 4, 'health', '', 1, 0, 0, 0, '0000-00-00 00:00:00', '2024-01-01 00:00:00', '', '', '', '', '', '', 'category', 0, '000.000.000.000',
  'YToyOntzOjk6Imljb24tZm9udCI7czoxNDoiZm9udC1hd2Vzb21lLTUiO3M6MTk6Imljb24tZm9udC1hZGQtY2xhc3MiO3M6MDoiIjt9', 1, 1, 1, '', '2024-01-01 00:00:00', 0, '000.000.000.000',
  '2024-01-01 00:00:00', '0000-00-00 00:00:00', 1 ),
( 5, 'home-garden', '', 1, 0, 0, 0, '0000-00-00 00:00:00', '2024-01-01 00:00:00', '', '', '', '', '', '', 'category', 0, '000.000.000.000',
  'YToyOntzOjk6Imljb24tZm9udCI7czoxNDoiZm9udC1hd2Vzb21lLTUiO3M6MTk6Imljb24tZm9udC1hZGQtY2xhc3MiO3M6MDoiIjt9', 1, 1, 1, '', '2024-01-01 00:00:00', 0, '000.000.000.000',
  '2024-01-01 00:00:00', '0000-00-00 00:00:00', 1 ),
( 6, 'news', '', 1, 0, 0, 0, '0000-00-00 00:00:00', '2024-01-01 00:00:00', '', '', '', '', '', '', 'category', 0, '000.000.000.000',
  'YToyOntzOjk6Imljb24tZm9udCI7czoxNDoiZm9udC1hd2Vzb21lLTUiO3M6MTk6Imljb24tZm9udC1hZGQtY2xhc3MiO3M6MDoiIjt9', 1, 1, 1, '', '2024-01-01 00:00:00', 0, '000.000.000.000',
  '2024-01-01 00:00:00', '0000-00-00 00:00:00', 1 ),
( 7, 'shopping', '', 1, 0, 0, 0, '0000-00-00 00:00:00', '2024-01-01 00:00:00', '', '', '', '', '', '', 'category', 0, '000.000.000.000',
  'YToyOntzOjk6Imljb24tZm9udCI7czoxNDoiZm9udC1hd2Vzb21lLTUiO3M6MTk6Imljb24tZm9udC1hZGQtY2xhc3MiO3M6MDoiIjt9', 1, 1, 1, '', '2024-01-01 00:00:00', 0, '000.000.000.000',
  '2024-01-01 00:00:00', '0000-00-00 00:00:00', 1 ),
( 8, 'communications', '', 1, 0, 0, 0, '0000-00-00 00:00:00', '2024-01-01 00:00:00', '', '', '', '', '', '', 'category', 0, '000.000.000.000',
  'YToyOntzOjk6Imljb24tZm9udCI7czoxNDoiZm9udC1hd2Vzb21lLTUiO3M6MTk6Imljb24tZm9udC1hZGQtY2xhc3MiO3M6MDoiIjt9', 1, 2, 1, '', '2024-01-01 00:00:00', 0, '000.000.000.000',
  '2024-01-01 00:00:00', '0000-00-00 00:00:00', 1 ),
( 9, 'graphics', '', 1, 0, 0, 0, '0000-00-00 00:00:00', '2024-01-01 00:00:00', '', '', '', '', '', '', 'category', 0, '000.000.000.000',
  'YToyOntzOjk6Imljb24tZm9udCI7czoxNDoiZm9udC1hd2Vzb21lLTUiO3M6MTk6Imljb24tZm9udC1hZGQtY2xhc3MiO3M6MDoiIjt9', 1, 2, 1, '', '2024-01-01 00:00:00', 0, '000.000.000.000',
  '2024-01-01 00:00:00', '0000-00-00 00:00:00', 1 ),
( 10, 'hardware', '', 1, 0, 0, 0, '0000-00-00 00:00:00', '2024-01-01 00:00:00', '', '', '', '', '', '', 'category', 0, '000.000.000.000',
  'YToyOntzOjk6Imljb24tZm9udCI7czoxNDoiZm9udC1hd2Vzb21lLTUiO3M6MTk6Imljb24tZm9udC1hZGQtY2xhc3MiO3M6MDoiIjt9', 1, 2, 1, '', '2024-01-01 00:00:00', 0, '000.000.000.000',
  '2024-01-01 00:00:00', '0000-00-00 00:00:00', 1 ),
( 11, 'mobile-computing', '', 1, 0, 0, 0, '0000-00-00 00:00:00', '2024-01-01 00:00:00', '', '', '', '', '', '', 'category', 0, '000.000.000.000',
  'YToyOntzOjk6Imljb24tZm9udCI7czoxNDoiZm9udC1hd2Vzb21lLTUiO3M6MTk6Imljb24tZm9udC1hZGQtY2xhc3MiO3M6MDoiIjt9', 1, 2, 1, '', '2024-01-01 00:00:00', 0, '000.000.000.000',
  '2024-01-01 00:00:00', '0000-00-00 00:00:00', 1 ),
( 12, 'multimedia', '', 1, 0, 0, 0, '0000-00-00 00:00:00', '2024-01-01 00:00:00', '', '', '', '', '', '', 'category', 0, '000.000.000.000',
  'YToyOntzOjk6Imljb24tZm9udCI7czoxNDoiZm9udC1hd2Vzb21lLTUiO3M6MTk6Imljb24tZm9udC1hZGQtY2xhc3MiO3M6MDoiIjt9', 1, 2, 1, '', '2024-01-01 00:00:00', 0, '000.000.000.000',
  '2024-01-01 00:00:00', '0000-00-00 00:00:00', 1 ),
( 14, 'card-games', '', 1, 0, 0, 0, '0000-00-00 00:00:00', '2024-01-01 00:00:00', '', '', '', '', '', '', 'category', 0, '000.000.000.000',
  'YToyOntzOjk6Imljb24tZm9udCI7czoxNDoiZm9udC1hd2Vzb21lLTUiO3M6MTk6Imljb24tZm9udC1hZGQtY2xhc3MiO3M6MDoiIjt9', 1, 3, 1, '', '2024-01-01 00:00:00', 0, '000.000.000.000',
  '2024-01-01 00:00:00', '0000-00-00 00:00:00', 1 ),
( 15, 'computer-games', '', 1, 0, 0, 0, '0000-00-00 00:00:00', '2024-01-01 00:00:00', '', '', '', '', '', '', 'category', 0, '000.000.000.000',
  'YToyOntzOjk6Imljb24tZm9udCI7czoxNDoiZm9udC1hd2Vzb21lLTUiO3M6MTk6Imljb24tZm9udC1hZGQtY2xhc3MiO3M6MDoiIjt9', 1, 3, 1, '', '2024-01-01 00:00:00', 0, '000.000.000.000',
  '2024-01-01 00:00:00', '0000-00-00 00:00:00', 1 ),
( 16, 'puzzles', '', 1, 0, 0, 0, '0000-00-00 00:00:00', '2024-01-01 00:00:00', '', '', '', '', '', '', 'category', 0, '000.000.000.000',
  'YToyOntzOjk6Imljb24tZm9udCI7czoxNDoiZm9udC1hd2Vzb21lLTUiO3M6MTk6Imljb24tZm9udC1hZGQtY2xhc3MiO3M6MDoiIjt9', 1, 3, 1, '', '2024-01-01 00:00:00', 0, '000.000.000.000',
  '2024-01-01 00:00:00', '0000-00-00 00:00:00', 1 ),
( 17, 'video-games', '', 1, 0, 0, 0, '0000-00-00 00:00:00', '2024-01-01 00:00:00', '', '', '', '', '', '', 'category', 0, '000.000.000.000',
  'YToyOntzOjk6Imljb24tZm9udCI7czoxNDoiZm9udC1hd2Vzb21lLTUiO3M6MTk6Imljb24tZm9udC1hZGQtY2xhc3MiO3M6MDoiIjt9', 1, 3, 1, '', '2024-01-01 00:00:00', 0, '000.000.000.000',
  '2024-01-01 00:00:00', '0000-00-00 00:00:00', 1 ),
( 18, 'beauty', '', 1, 0, 0, 0, '0000-00-00 00:00:00', '2024-01-01 00:00:00', '', '', '', '', '', '', 'category', 0, '000.000.000.000',
  'YToyOntzOjk6Imljb24tZm9udCI7czoxNDoiZm9udC1hd2Vzb21lLTUiO3M6MTk6Imljb24tZm9udC1hZGQtY2xhc3MiO3M6MDoiIjt9', 1, 4, 1, '', '2024-01-01 00:00:00', 0, '000.000.000.000',
  '2024-01-01 00:00:00', '0000-00-00 00:00:00', 1 ),
( 19, 'fitness', '', 1, 0, 0, 0, '0000-00-00 00:00:00', '2024-01-01 00:00:00', '', '', '', '', '', '', 'category', 0, '000.000.000.000',
  'YToyOntzOjk6Imljb24tZm9udCI7czoxNDoiZm9udC1hd2Vzb21lLTUiO3M6MTk6Imljb24tZm9udC1hZGQtY2xhc3MiO3M6MDoiIjt9', 1, 4, 1, '', '2024-01-01 00:00:00', 0, '000.000.000.000',
  '2024-01-01 00:00:00', '0000-00-00 00:00:00', 1 ),
( 20, 'pharmacy', '', 1, 0, 0, 0, '0000-00-00 00:00:00', '2024-01-01 00:00:00', '', '', '', '', '', '', 'category', 0, '000.000.000.000',
  'YToyOntzOjk6Imljb24tZm9udCI7czoxNDoiZm9udC1hd2Vzb21lLTUiO3M6MTk6Imljb24tZm9udC1hZGQtY2xhc3MiO3M6MDoiIjt9', 1, 4, 1, '', '2024-01-01 00:00:00', 0, '000.000.000.000',
  '2024-01-01 00:00:00', '0000-00-00 00:00:00', 1 ),
( 21, 'weight-loss', '', 1, 0, 0, 0, '0000-00-00 00:00:00', '2024-01-01 00:00:00', '', '', '', '', '', '', 'category', 0, '000.000.000.000',
  'YToyOntzOjk6Imljb24tZm9udCI7czoxNDoiZm9udC1hd2Vzb21lLTUiO3M6MTk6Imljb24tZm9udC1hZGQtY2xhc3MiO3M6MDoiIjt9', 1, 4, 1, '', '2024-01-01 00:00:00', 0, '000.000.000.000',
  '2024-01-01 00:00:00', '0000-00-00 00:00:00', 1 ),
( 22, 'do-it-yourself', '', 1, 0, 0, 0, '0000-00-00 00:00:00', '2024-01-01 00:00:00', '', '', '', '', '', '', 'category', 0, '000.000.000.000',
  'YToyOntzOjk6Imljb24tZm9udCI7czoxNDoiZm9udC1hd2Vzb21lLTUiO3M6MTk6Imljb24tZm9udC1hZGQtY2xhc3MiO3M6MDoiIjt9', 1, 5, 1, '', '2024-01-01 00:00:00', 0, '000.000.000.000',
  '2024-01-01 00:00:00', '0000-00-00 00:00:00', 1 ),
( 23, 'moving-and-relocating', '', 1, 0, 0, 0, '0000-00-00 00:00:00', '2024-01-01 00:00:00', '', '', '', '', '', '', 'category', 0, '000.000.000.000',
  'YToyOntzOjk6Imljb24tZm9udCI7czoxNDoiZm9udC1hd2Vzb21lLTUiO3M6MTk6Imljb24tZm9udC1hZGQtY2xhc3MiO3M6MDoiIjt9', 1, 5, 1, '', '2024-01-01 00:00:00', 0, '000.000.000.000',
  '2024-01-01 00:00:00', '0000-00-00 00:00:00', 1 ),
( 24, 'personal-finance', '', 1, 0, 0, 0, '0000-00-00 00:00:00', '2024-01-01 00:00:00', '', '', '', '', '', '', 'category', 0, '000.000.000.000',
  'YToyOntzOjk6Imljb24tZm9udCI7czoxNDoiZm9udC1hd2Vzb21lLTUiO3M6MTk6Imljb24tZm9udC1hZGQtY2xhc3MiO3M6MDoiIjt9', 1, 5, 1, '', '2024-01-01 00:00:00', 0, '000.000.000.000',
  '2024-01-01 00:00:00', '0000-00-00 00:00:00', 1 ),
( 25, 'pets', '', 1, 0, 0, 0, '0000-00-00 00:00:00', '2024-01-01 00:00:00', '', '', '', '', '', '', 'category', 0, '000.000.000.000',
  'YToyOntzOjk6Imljb24tZm9udCI7czoxNDoiZm9udC1hd2Vzb21lLTUiO3M6MTk6Imljb24tZm9udC1hZGQtY2xhc3MiO3M6MDoiIjt9', 1, 5, 1, '', '2024-01-01 00:00:00', 0, '000.000.000.000',
  '2024-01-01 00:00:00', '0000-00-00 00:00:00', 1 ),
( 26, 'chats-and-forums', '', 1, 0, 0, 0, '0000-00-00 00:00:00', '2024-01-01 00:00:00', '', '', '', '', '', '', 'category', 0, '000.000.000.000',
  'YToyOntzOjk6Imljb24tZm9udCI7czoxNDoiZm9udC1hd2Vzb21lLTUiO3M6MTk6Imljb24tZm9udC1hZGQtY2xhc3MiO3M6MDoiIjt9', 1, 6, 1, '', '2024-01-01 00:00:00', 0, '000.000.000.000',
  '2024-01-01 00:00:00', '0000-00-00 00:00:00', 1 ),
( 27, 'current-events', '', 1, 0, 0, 0, '0000-00-00 00:00:00', '2024-01-01 00:00:00', '', '', '', '', '', '', 'category', 0, '000.000.000.000',
  'YToyOntzOjk6Imljb24tZm9udCI7czoxNDoiZm9udC1hd2Vzb21lLTUiO3M6MTk6Imljb24tZm9udC1hZGQtY2xhc3MiO3M6MDoiIjt9', 1, 6, 1, '', '2024-01-01 00:00:00', 0, '000.000.000.000',
  '2024-01-01 00:00:00', '0000-00-00 00:00:00', 1 ),
( 28, 'journalism', '', 1, 0, 0, 0, '0000-00-00 00:00:00', '2024-01-01 00:00:00', '', '', '', '', '', '', 'category', 0, '000.000.000.000',
  'YToyOntzOjk6Imljb24tZm9udCI7czoxNDoiZm9udC1hd2Vzb21lLTUiO3M6MTk6Imljb24tZm9udC1hZGQtY2xhc3MiO3M6MDoiIjt9', 1, 6, 1, '', '2024-01-01 00:00:00', 0, '000.000.000.000',
  '2024-01-01 00:00:00', '0000-00-00 00:00:00', 1 ),
( 29, 'television', '', 1, 0, 0, 0, '0000-00-00 00:00:00', '2024-01-01 00:00:00', '', '', '', '', '', '', 'category', 0, '000.000.000.000',
  'YToyOntzOjk6Imljb24tZm9udCI7czoxNDoiZm9udC1hd2Vzb21lLTUiO3M6MTk6Imljb24tZm9udC1hZGQtY2xhc3MiO3M6MDoiIjt9', 1, 6, 1, '', '2024-01-01 00:00:00', 0, '000.000.000.000',
  '2024-01-01 00:00:00', '0000-00-00 00:00:00', 1 ),
( 30, 'weather', '', 1, 0, 0, 0, '0000-00-00 00:00:00', '2024-01-01 00:00:00', '', '', '', '', '', '', 'category', 0, '000.000.000.000',
  'YToyOntzOjk6Imljb24tZm9udCI7czoxNDoiZm9udC1hd2Vzb21lLTUiO3M6MTk6Imljb24tZm9udC1hZGQtY2xhc3MiO3M6MDoiIjt9', 1, 6, 1, '', '2024-01-01 00:00:00', 0, '000.000.000.000',
  '2024-01-01 00:00:00', '0000-00-00 00:00:00', 1 ),
( 31, 'books', '', 1, 0, 0, 0, '0000-00-00 00:00:00', '2024-01-01 00:00:00', '', '', '', '', '', '', 'category', 0, '000.000.000.000',
  'YToyOntzOjk6Imljb24tZm9udCI7czoxNDoiZm9udC1hd2Vzb21lLTUiO3M6MTk6Imljb24tZm9udC1hZGQtY2xhc3MiO3M6MDoiIjt9', 1, 7, 1, '', '2024-01-01 00:00:00', 0, '000.000.000.000',
  '2024-01-01 00:00:00', '0000-00-00 00:00:00', 1 ),
( 32, 'movies-music', '', 1, 0, 0, 0, '0000-00-00 00:00:00', '2024-01-01 00:00:00', '', '', '', '', '', '', 'category', 0, '000.000.000.000',
  'YToyOntzOjk6Imljb24tZm9udCI7czoxNDoiZm9udC1hd2Vzb21lLTUiO3M6MTk6Imljb24tZm9udC1hZGQtY2xhc3MiO3M6MDoiIjt9', 1, 7, 1, '', '2024-01-01 00:00:00', 0, '000.000.000.000',
  '2024-01-01 00:00:00', '0000-00-00 00:00:00', 1 ),
( 33, 'toys', '', 1, 0, 0, 0, '0000-00-00 00:00:00', '2024-01-01 00:00:00', '', '', '', '', '', '', 'category', 0, '000.000.000.000',
  'YToyOntzOjk6Imljb24tZm9udCI7czoxNDoiZm9udC1hd2Vzb21lLTUiO3M6MTk6Imljb24tZm9udC1hZGQtY2xhc3MiO3M6MDoiIjt9', 1, 7, 1, '', '2024-01-01 00:00:00', 0, '000.000.000.000',
  '2024-01-01 00:00:00', '0000-00-00 00:00:00', 1 ),
( 34, 'home-improvement', '', 1, 0, 0, 0, '0000-00-00 00:00:00', '2024-01-01 00:00:00', '', '', '', '', '', '', 'category', 0, '000.000.000.000',
  'YToyOntzOjk6Imljb24tZm9udCI7czoxNDoiZm9udC1hd2Vzb21lLTUiO3M6MTk6Imljb24tZm9udC1hZGQtY2xhc3MiO3M6MDoiIjt9', 1, 7, 1, '', '2024-01-01 00:00:00', 0, '000.000.000.000',
  '2024-01-01 00:00:00', '0000-00-00 00:00:00', 1 ),
( 36, 'cars', '', 1, 0, 0, 0, '0000-00-00 00:00:00', '2024-01-01 00:00:00', '', '', '', '', '', '', 'category', 0, '000.000.000.000',
  'YToyOntzOjk6Imljb24tZm9udCI7czoxNDoiZm9udC1hd2Vzb21lLTUiO3M6MTk6Imljb24tZm9udC1hZGQtY2xhc3MiO3M6MDoiIjt9', 1, 7, 1, '', '2024-01-01 00:00:00', 0, '000.000.000.000',
  '2024-01-01 00:00:00', '0000-00-00 00:00:00', 1 ),
( 37, 'neotrin-electronics', '', 1, 0, 0, 0, '0000-00-00 00:00:00', '2024-01-01 00:00:00', '', '', '', '', '', '', 'entry', 0, '000.000.000.000', '', 1, 0, 1, '',
  '2024-01-01 00:00:00',
  0, '000.000.000.000', '2024-01-01 00:00:00', '0000-00-00 00:00:00', 1 ),
( 38, 'natural-communications', '', 1, 0, 0, 0, '0000-00-00 00:00:00', '2024-01-01 00:00:00', '', '', '', '', '', '', 'entry', 0, '000.000.000.000', '', 1, 0, 1, '',
  '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', '0000-00-00 00:00:00', 1 ),
( 39, 'sun-bookstore', '', 1, 0, 0, 0, '0000-00-00 00:00:00', '2024-01-01 00:00:00', '', '', '', '', '', '', 'entry', 0, '000.000.000.000', '', 1, 0, 1, '', '2024-01-01 00:00:00',
  0,
  '000.000.000.000', '2024-01-01 00:00:00', '0000-00-00 00:00:00', 1 ),
( 40, 'good-health-ltd', '', 1, 0, 0, 0, '0000-00-00 00:00:00', '2024-01-01 00:00:00', '', '', '', '', '', '', 'entry', 0, '000.000.000.000', '', 1, 0, 1, '',
  '2024-01-01 00:00:00',
  0, '000.000.000.000', '2024-01-01 00:00:00', '0000-00-00 00:00:00', 1 ),
( 41, 'trinity-pet-supplies', '', 1, 0, 0, 0, '0000-00-00 00:00:00', '2023-05-06 13:01:08', '', '', '', '', '', '', 'entry', 0, '000.000.000.000', '', 1, 0, 1, '',
  '2024-01-01 00:00:00', 0, '000.000.000.000', '2024-01-01 00:00:00', '0000-00-00 00:00:00', 1 );

# add the payments data

INSERT IGNORE INTO `#__sobipro_payments`( `pid`, `refNum`, `sid`, `fid`, `subject`, `dateAdded`, `datePaid`, `validUntil`, `paid`, `amount`, `params` )
VALUES
( 1, '1282745518.37', 37, 11, 'Website', '2024-01-01 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 10, '' ),
( 2, '1282745518.37', 37, 9, 'Full Description', '2024-01-01 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 20, '' ),
( 3, '1282748655.38', 38, 11, 'Website', '2024-01-01 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 10, '' ),
( 4, '1282748655.38', 38, 9, 'Full Description', '2024-01-01 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 20, '' ),
( 5, '1282750744.39', 39, 11, 'Website', '2024-01-01 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 10, '' ),
( 6, '1282750744.39', 39, 9, 'Full Description', '2024-01-01 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 20, '' ),
( 7, '1620300268.40', 40, 11, 'Website', '2024-01-01 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 10, '' ),
( 8, '1620300268.40', 40, 9, 'Full Description', '2024-01-01 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 20, '' ),
( 9, '1620306071.41', 41, 11, 'Website', '2024-01-01 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 10, '' ),
( 10, '1620306235.41', 41, 9, 'Full Description', '2024-01-01 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 20, '' );

# add necessary permission groups

INSERT IGNORE INTO `#__sobipro_permissions_groups`( `rid`, `gid` )
VALUES
( 1, 0 ),
( 2, 2 ),
( 2, 29 );

# add necessary permission map

INSERT IGNORE INTO `#__sobipro_permissions_map`( `rid`, `sid`, `pid` )
VALUES
( 1, 1, 4 ),
( 1, 1, 7 ),
( 1, 1, 10 ),
( 1, 1, 16 ),
( 1, 1, 26 ),
( 2, 1, 16 ),
( 2, 1, 17 );

# add necessary permission rules

INSERT IGNORE INTO `#__sobipro_permissions_rules`( `rid`, `name`, `nid`, `validSince`, `validUntil`, `note`, `state` )
VALUES
( 1, 'Visitor', 'visitor', '2024-01-01 00:00:00', '0000-00-00 00:00:00', '', 1 ),
( 2, 'Registered', 'registered', '2024-01-01 00:00:00', '0000-00-00 00:00:00', '', 1 );

# add section dependant applications

INSERT IGNORE INTO `#__sobipro_plugin_section`( `section`, `pid`, `type`, `enabled`, `position` )
VALUES
( 1, 'bank_transfer', 'payment', 1, 0 ),
( 1, 'paypal', 'payment', 1, 0 );

# add data relations

INSERT IGNORE INTO `#__sobipro_relations`( `id`, `pid`, `oType`, `position`, `validSince`, `validUntil`, `copy` )
VALUES
( 1, 0, 'section', 1, '2024-01-01 00:00:00', '0000-00-00 00:00:00', 0 ),
( 2, 1, 'category', 1, '2024-01-01 00:00:00', '0000-00-00 00:00:00', 0 ),
( 3, 1, 'category', 2, '2024-01-01 00:00:00', '0000-00-00 00:00:00', 0 ),
( 4, 1, 'category', 3, '2024-01-01 00:00:00', '0000-00-00 00:00:00', 0 ),
( 5, 1, 'category', 4, '2024-01-01 00:00:00', '0000-00-00 00:00:00', 0 ),
( 6, 1, 'category', 5, '2024-01-01 00:00:00', '0000-00-00 00:00:00', 0 ),
( 7, 1, 'category', 6, '2024-01-01 00:00:00', '0000-00-00 00:00:00', 0 ),
( 8, 2, 'category', 1, '2024-01-01 00:00:00', '0000-00-00 00:00:00', 0 ),
( 9, 2, 'category', 2, '2024-01-01 00:00:00', '0000-00-00 00:00:00', 0 ),
( 10, 2, 'category', 3, '2024-01-01 00:00:00', '0000-00-00 00:00:00', 0 ),
( 11, 2, 'category', 4, '2024-01-01 00:00:00', '0000-00-00 00:00:00', 0 ),
( 12, 2, 'category', 5, '2024-01-01 00:00:00', '0000-00-00 00:00:00', 0 ),
( 14, 3, 'category', 1, '2024-01-01 00:00:00', '0000-00-00 00:00:00', 0 ),
( 15, 3, 'category', 2, '2024-01-01 00:00:00', '0000-00-00 00:00:00', 0 ),
( 16, 3, 'category', 3, '2024-01-01 00:00:00', '0000-00-00 00:00:00', 0 ),
( 17, 3, 'category', 4, '2024-01-01 00:00:00', '0000-00-00 00:00:00', 0 ),
( 18, 4, 'category', 1, '2024-01-01 00:00:00', '0000-00-00 00:00:00', 0 ),
( 19, 4, 'category', 2, '2024-01-01 00:00:00', '0000-00-00 00:00:00', 0 ),
( 20, 4, 'category', 3, '2024-01-01 00:00:00', '0000-00-00 00:00:00', 0 ),
( 21, 4, 'category', 4, '2024-01-01 00:00:00', '0000-00-00 00:00:00', 0 ),
( 22, 5, 'category', 5, '2024-01-01 00:00:00', '0000-00-00 00:00:00', 0 ),
( 23, 5, 'category', 6, '2024-01-01 00:00:00', '0000-00-00 00:00:00', 0 ),
( 24, 5, 'category', 7, '2024-01-01 00:00:00', '0000-00-00 00:00:00', 0 ),
( 25, 5, 'category', 8, '2024-01-01 00:00:00', '0000-00-00 00:00:00', 0 ),
( 26, 6, 'category', 9, '2024-01-01 00:00:00', '0000-00-00 00:00:00', 0 ),
( 27, 6, 'category', 10, '2024-01-01 00:00:00', '0000-00-00 00:00:00', 0 ),
( 28, 6, 'category', 11, '2024-01-01 00:00:00', '0000-00-00 00:00:00', 0 ),
( 29, 6, 'category', 12, '2024-01-01 00:00:00', '0000-00-00 00:00:00', 0 ),
( 30, 6, 'category', 13, '2024-01-01 00:00:00', '0000-00-00 00:00:00', 0 ),
( 31, 7, 'category', 2, '2024-01-01 00:00:00', '0000-00-00 00:00:00', 0 ),
( 32, 7, 'category', 3, '2024-01-01 00:00:00', '0000-00-00 00:00:00', 0 ),
( 33, 7, 'category', 4, '2024-01-01 00:00:00', '0000-00-00 00:00:00', 0 ),
( 34, 7, 'category', 5, '2024-01-01 00:00:00', '0000-00-00 00:00:00', 0 ),
( 36, 7, 'category', 1, '2024-01-01 00:00:00', '0000-00-00 00:00:00', 0 ),
( 37, 10, 'entry', 3, '2024-01-01 00:00:00', '0000-00-00 00:00:00', 0 ),
( 37, 11, 'entry', 5, '2024-01-01 00:00:00', '0000-00-00 00:00:00', 0 ),
( 37, 12, 'entry', 3, '2024-01-01 00:00:00', '0000-00-00 00:00:00', 0 ),
( 38, 8, 'entry', 4, '2024-01-01 00:00:00', '0000-00-00 00:00:00', 0 ),
( 38, 9, 'entry', 4, '2024-01-01 00:00:00', '0000-00-00 00:00:00', 0 ),
( 38, 11, 'entry', 6, '2024-01-01 00:00:00', '0000-00-00 00:00:00', 0 ),
( 39, 31, 'entry', 6, '2024-01-01 00:00:00', '0000-00-00 00:00:00', 0 ),
( 39, 32, 'entry', 6, '2024-01-01 00:00:00', '0000-00-00 00:00:00', 0 ),
( 39, 33, 'entry', 6, '2024-01-01 00:00:00', '0000-00-00 00:00:00', 0 ),
( 40, 20, 'entry', 1, '2024-01-01 00:00:00', '0000-00-00 00:00:00', 0 ),
( 40, 21, 'entry', 1, '2024-01-01 00:00:00', '0000-00-00 00:00:00', 0 ),
( 41, 33, 'entry', 7, '2024-01-01 00:00:00', '0000-00-00 00:00:00', 0 );
