/*!
* Tagin v2.0.2 (https://tagin.netlify.app/)
* Copyright 2020-2021 Erwin Heldy G
* Licensed under MIT (https://github.com/erwinheldy/tagin/blob/master/LICENSE)
*
* Sigrid Suski, Sigsiu.NET, 2022
* Extended by:
* - the event triggers 'tagin:tagAdded' and 'tagin:beforeRemove'
* - option 'maxchars': maximum number of characters for each tag
* - option 'maxtags': number of maximum tags
* - option 'addtags': user may add new tags (other than from autocomplete list)
* - method autowidth() corrected
* - type of tags input field is 'tag' instead of 'text'
*
* @modified 01 July 2022 by Sigrid Suski
*/
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?module.exports=e():"function"==typeof define&&define.amd?define(e):(t="undefined"!=typeof globalThis?globalThis:t||self).Tagin=e()}(this,(function(){"use strict";class Tagin{classElement="tagin";classWrapper="tagin-wrapper";classTag="tagin-tag";classRemove="tagin-tag-remove";classInput="tagin-input";classInputHidden="tagin-input-hidden";target;wrapper;input;separator;placeholder;duplicate;transform;enter;maxchars;maxtags;addtags;constructor(t,e){this.target=t,this.separator=e?.separator||t.dataset.taginSeparator||",",this.placeholder=e?.placeholder||t.dataset.taginPlaceholder||"",this.duplicate=e?.duplicate||void 0!==t.dataset.taginDuplicate,this.transform=e?.transform||t.dataset.taginTransform||"input => input",this.enter=e?.enter||void 0!==t.dataset.taginEnter,this.maxchars=e?.maxchars||void 0!==t.dataset.taginMaxchars||0,this.maxtags=e?.maxtags||void 0!==t.dataset.taginMaxtags||0,this.addtags=e?.addtags||void 0!==t.dataset.taginAddtags||!0,this.createWrapper(),this.autowidth(),this.addEventListener()}createWrapper(){const t=""===this.getValue()?"":this.getValues().map((t=>this.createTag(t))).join(""),e=document.createElement("input");e.type="tag",e.className=this.classInput,e.placeholder=this.placeholder;const a=document.createElement("div");a.className=`${this.classWrapper} ${this.target.className}`,a.classList.remove(this.classElement),a.insertAdjacentHTML("afterbegin",t),a.insertAdjacentElement("beforeend",e),this.target.insertAdjacentElement("afterend",a),this.wrapper=a,this.input=e}createTag(t){return`<span class="${this.classTag}">${t}<span onclick="this.closest('div').dispatchEvent(new CustomEvent('tagin:remove', { detail: this }))" class="${this.classRemove}"></span></span>`}getValue(){return this.target.value.trim()}getValues(){return this.getValue().split(this.separator)}getTags(){return Array.from(this.wrapper.getElementsByClassName(this.classTag)).map((t=>t.textContent))}getTag(){return this.getTags().join(this.separator)}updateValue(){this.target.value=this.getTag(),this.maxtags>0&&this.getTags().length>=this.maxtags?(this.input.classList.add(this.classInputHidden),this.input.setAttribute("disabled","disabled")):(this.input.classList.remove(this.classInputHidden),this.input.removeAttribute("disabled")),this.target.dispatchEvent(new Event("change"))}autowidth(){const t=document.createElement("div");t.classList.add(this.classInput,this.classInputHidden);const e=this.input.value||this.input.placeholder||"";t.innerHTML=e.replace(/ /g,"&nbsp;"),document.body.appendChild(t),this.input.style.setProperty("width",Math.ceil(8*(parseInt(e.length)+1))+"px"),t.remove()}addEventListener(){const t=this.wrapper,e=this.input;t.addEventListener("click",(()=>e.focus())),e.addEventListener("focus",(()=>t.classList.add("focus"))),e.addEventListener("blur",(()=>t.classList.remove("focus"))),e.addEventListener("input",(()=>{this.appendTag(),this.autowidth()})),e.addEventListener("blur",(()=>{"1"===this.addtags?this.appendTag(!0):(e.value="",e.removeAttribute("style")),this.autowidth()})),e.addEventListener("keydown",(a=>{""===e.value&&"Backspace"===a.key&&t.getElementsByClassName(this.classTag).length&&(t.querySelector(`.${this.classTag}:last-of-type`).remove(),this.updateValue()),(""!==e.value&&"Enter"===a.key&&this.enter||this.maxchars>0&&e.value.length>=this.maxchars)&&(this.appendTag(!0),this.autowidth(),a.preventDefault())})),t.addEventListener("tagin:remove",(e=>{if(e.detail instanceof HTMLSpanElement){let a=new CustomEvent("tagin:beforeRemove",{detail:{tag:e.detail.parentElement.textContent,cancel:!1}});if(t.dispatchEvent(a),a.detail.cancel)return;e.detail.parentElement.remove(),this.updateValue()}})),this.target.addEventListener("change",(()=>this.updateTag()))}appendTag(force=!1){const input=this.input,value=eval(this.transform)(input.value.trim());""===value&&(input.value="");const original=input.value;(input.value.includes(this.separator)&&"1"===this.addtags||force&&""!==input.value)&&(value.split(this.separator).filter((t=>""!==t)).forEach((t=>{this.getTags().includes(t)&&!1===this.duplicate?this.alertExist(t):(input.insertAdjacentHTML("beforebegin",this.createTag(t)),this.updateValue(),this.wrapper.dispatchEvent(new CustomEvent("tagin:tagAdded",{detail:t})))})),input.value="",input.removeAttribute("style"),this.autowidth()),original.includes(this.separator)&&"0"===this.addtags&&!force&&(input.value=value.replace(this.separator,""))}alertExist(t){for(const e of this.wrapper.getElementsByClassName(this.classTag))e.textContent===t&&e instanceof HTMLSpanElement&&(e.style.transform="scale(1.09)",setTimeout((()=>{e.removeAttribute("style")}),220))}updateTag(){this.getValue()!==this.getTag()&&([...this.wrapper.getElementsByClassName(this.classTag)].map((t=>t.remove())),""!==this.getValue().trim()&&this.input.insertAdjacentHTML("beforebegin",this.getValues().map((t=>this.createTag(t))).join("")))}addTag(t){this.input.value=(Array.isArray(t)?t.join(this.separator):t)+this.separator,this.input.dispatchEvent(new Event("input"))}}return Tagin}));