/**
 * SobiPro datepicker; it will work only with SobiPro
 * Based mainly on: >>
 * @license
 * =========================================================
 * bootstrap-datetimepicker.js
 * http://www.eyecon.ro/bootstrap-datepicker
 * =========================================================
 * Copyright 2012 Stefan Petre
 *
 * Contributions:
 *  - Andrew Rowls
 *  - Thiago de Arruda (2013)
 *  - Radek Suski (2014)
 *  - Sigrid Suski (2021) : Modified to work with all Bootstrap and font versions
 *  - Sigrid Suski (2022) : Positioning corrected
 *  - Sigrid Suski (2022) : timepicker corrected
 *  - Sigrid Suski (2024) : Picker position on small devices corrected
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =========================================================
 * http://tarruda.github.io/bootstrap-datetimepicker/
 *
 * @created Tue, Mar 25, 2014 by Radek Suski
 * @modified 26 April 2024 by Sigrid Suski
 */
$=SobiPro.jQuery,function(){window.orientation;var t=function(t,i){this.id=e++,this.init(t,i)};t.prototype={constructor:t,init:function(t,e){var a;if(!e.pickTime&&!e.pickDate)throw new Error("Must choose at least one picker");this.options=e,this.$element=SobiPro.jQuery(t),this.language=e.language in i?e.language:"en",this.pickDate=e.pickDate,this.pickTime=e.pickTime,this.isInput=this.$element.is("input"),this.component=!1,this.component=this.$element.find(".spctrl-trigger"),this.widgetTime="time",this.widgetDate="calendar",this.format=e.format,this.format||(this.isInput?this.format=this.$element.data("format"):this.format=this.$element.find("input").data("format"),this.format||(this.format="MM/dd/yyyy")),e.pick12HourFormat=this.$element.find("input").data("am-pm"),this._compileFormat(),this.component&&(a=this.component.find(".spctrl-trigger-icon")),a&&a.length&&(this.pickTime&&(this.timeIcon=a.data("time-icon"),a.addClass(this.timeIcon)),this.pickDate&&(this.dateIcon=a.data("date-icon"),a.removeClass(this.timeIcon),a.addClass(this.dateIcon)));var s=this.$element.find("input").data("append-to")&&this.$element.find("input").data("append-to").length?this.$element.find("input").data("append-to"):"body";if(this.widget=SobiPro.jQuery(this._getPickerSwitch(this.widgetTime,e)).appendTo(s),this.minViewMode=e.minViewMode||this.$element.data("date-minviewmode")||0,"string"==typeof this.minViewMode)switch(this.minViewMode){case"months":this.minViewMode=1;break;case"years":this.minViewMode=2;break;default:this.minViewMode=0}if(this.viewMode=e.viewMode||this.$element.data("date-viewmode")||0,"string"==typeof this.viewMode)switch(this.viewMode){case"months":this.viewMode=1;break;case"years":this.viewMode=2;break;default:this.viewMode=0}this.startViewMode=this.viewMode,this.weekStart=e.weekStart||this.$element.data("date-weekstart")||0,this.weekEnd=0===this.weekStart?6:this.weekStart-1,this.setStartDate(e.startDate||this.$element.data("date-startdate")),this.setEndDate(e.endDate||this.$element.data("date-enddate")),this.fillDow(),this.fillMonths(),this.fillHours(),this.fillMinutes(),this.fillSeconds(),this.update(),this.showMode(),this._attachDatePickerEvents(),this._attachSpecialButtons()},show:function(t){this.widget.show(),this.height=this.component?this.component.outerHeight():this.$element.outerHeight(),this.place(),this.$element.trigger({type:"show",date:this._date}),this._attachDatePickerGlobalEvents(),t&&(t.stopPropagation(),t.preventDefault())},disable:function(){this.$element.find("input").prop("disabled",!0),this._detachDatePickerEvents()},enable:function(){this.$element.find("input").prop("disabled",!1),this._attachDatePickerEvents()},hide:function(){for(var t=this.widget.find(".collapse"),e=0;e<t.length;e++){var i=t.eq(e).data("collapse");if(i&&i.transitioning)return}this.widget.hide(),this.viewMode=this.startViewMode,this.showMode(),this.set(),this._detachDatePickerGlobalEvents(),this.notifyChange()},set:function(){var t="";if(this._unset||(t=this.formatDate(this._date)),this.isInput)this.$element.val(t),this._resetMaskPos(this.$element);else{if(this.component){var e=this.$element.find("input:text");e.val(t),this._resetMaskPos(e)}this.$element.data("date",t)}},setValue:function(t){this._unset=!t,"string"==typeof t?this._date=this.parseDate(t):t&&(this._date=new Date(t)),this.set(),this.viewDate=l(this._date.getUTCFullYear(),this._date.getUTCMonth(),1,0,0,0,0),this.fillDate(),this.fillTime()},getDate:function(){return this._unset?null:new Date(this._date.valueOf())},setDate:function(t){t?this.setValue(t.valueOf()):this.setValue(null)},setStartDate:function(t){t instanceof Date?this.startDate=t:"string"==typeof t?(this.startDate=new l(t),this.startDate.getUTCFullYear()||(this.startDate=-1/0)):this.startDate=-1/0,this.viewDate&&this.update()},setEndDate:function(t){t instanceof Date?this.endDate=t:"string"==typeof t?(this.endDate=new l(t),this.endDate.getUTCFullYear()||(this.endDate=1/0)):this.endDate=1/0,this.viewDate&&this.update()},getLocalDate:function(){if(this._unset)return null;var t=this._date;return new Date(t.getUTCFullYear(),t.getUTCMonth(),t.getUTCDate(),t.getUTCHours(),t.getUTCMinutes(),t.getUTCSeconds(),t.getUTCMilliseconds())},setLocalDate:function(t){t?this.setValue(Date.UTC(t.getFullYear(),t.getMonth(),t.getDate(),t.getHours(),t.getMinutes(),t.getSeconds(),t.getMilliseconds())):this.setValue(null)},place:function(){var t="absolute",e=this.component?this.component.offset():this.$element.offset();this.width=this.component?this.component.outerWidth():this.$element.outerWidth(),e.top=e.top+this.height,null!=this.options.width&&this.widget.width(this.options.width),"left"==this.options.orientation&&(e.left=e.left-this.widget.width()+20),this._isInFixed()&&(t="fixed",e.top-=window.scrollTop(),e.left-=window.scrollLeft()),window.innerWidth<e.left+this.widget.outerWidth()?(e.right=window.innerWidth-e.left-this.width,e.left="auto",this.widget.addClass("pull-right")):(e.right="auto",this.widget.removeClass("pull-right")),this.widget.css({position:t,top:e.top,left:e.left,right:e.right})},notifyChange:function(){this.$element.trigger({type:"changeDate",date:this.getDate(),localDate:this.getLocalDate()})},update:function(t){var e=t;if(!e&&((e=this.isInput?this.$element.val():this.$element.find("input").val())&&(this._date=this.parseDate(e)),!this._date)){var i=new Date;this._date=l(i.getFullYear(),i.getMonth(),i.getDate(),i.getHours(),i.getMinutes(),i.getSeconds(),i.getMilliseconds())}this.viewDate=l(this._date.getUTCFullYear(),this._date.getUTCMonth(),1,0,0,0,0),this.fillDate(),this.fillTime()},fillDow:function(){for(var t=this.weekStart,e=SobiPro.jQuery("<tr>");t<this.weekStart+7;)e.append('<th class="dow">'+i[this.language].daysMin[t++%7]+"</th>");this.widget.find(".datepicker-days thead").append(e)},fillMonths:function(){for(var t="",e=0;e<12;)t+='<span class="month" role="button">'+i[this.language].monthsShort[e++]+"</span>";this.widget.find(".datepicker-months td").append(t)},fillDate:function(){var t=this.viewDate.getUTCFullYear(),e=this.viewDate.getUTCMonth(),a=l(this._date.getUTCFullYear(),this._date.getUTCMonth(),this._date.getUTCDate(),0,0,0,0),s="object"==typeof this.startDate?this.startDate.getUTCFullYear():-1/0,n="object"==typeof this.startDate?this.startDate.getUTCMonth():-1,o="object"==typeof this.endDate?this.endDate.getUTCFullYear():1/0,r="object"==typeof this.endDate?this.endDate.getUTCMonth():12;this.widget.find(".datepicker-days").find(".disabled").removeClass("disabled").removeAttr("aria-label"),this.widget.find(".datepicker-months").find(".disabled").removeClass("disabled").removeAttr("aria-label"),this.widget.find(".datepicker-years").find(".disabled").removeClass("disabled").removeAttr("aria-label"),this.widget.find(".datepicker-days th:eq(1)").text(i[this.language].months[e]+" "+t);var h=l(t,e-1,28,0,0,0,0),d=c.getDaysInMonth(h.getUTCFullYear(),h.getUTCMonth());h.setUTCDate(d),h.setUTCDate(d-(h.getUTCDay()-this.weekStart+7)%7),(t==s&&e<=n||t<s)&&this.widget.find(".datepicker-days th:eq(0)").addClass("disabled").attr("aria-label",i[this.language].states[1]),(t==o&&e>=r||t>o)&&this.widget.find(".datepicker-days th:eq(2)").addClass("disabled").attr("aria-label",i[this.language].states[1]);var u=new Date(h.valueOf());u.setUTCDate(u.getUTCDate()+42),u=u.valueOf();for(var p,g,f,m=[];h.valueOf()<u;)h.getUTCDay()===this.weekStart&&(p=SobiPro.jQuery("<tr>"),m.push(p)),g=f="",h.getUTCFullYear()<t||h.getUTCFullYear()==t&&h.getUTCMonth()<e?g+=" old":(h.getUTCFullYear()>t||h.getUTCFullYear()==t&&h.getUTCMonth()>e)&&(g+=" new"),h.valueOf()===a.valueOf()&&(g+=" active",f+=i[this.language].states[0]),h.valueOf()+864e5<=this.startDate&&(g+=" disabled",f+=i[this.language].states[1]),h.valueOf()>this.endDate&&(g+=" disabled",f+=i[this.language].states[1]),f=f?' aria-label="'+f+'"':"",p.append('<td class="day'+g+'"'+f+' role="button">'+h.getUTCDate()+"</td>"),h.setUTCDate(h.getUTCDate()+1);this.widget.find(".datepicker-days tbody").empty().append(m);var b=this._date.getUTCFullYear(),w=this.widget.find(".datepicker-months").find("th:eq(1)").text(t).end().find("span").removeClass("active").removeAttr("aria-label");b===t&&w.eq(this._date.getUTCMonth()).addClass("active").attr("aria-label",i[this.language].states[0]),b-1<s&&this.widget.find(".datepicker-months th:eq(0)").addClass("disabled").attr("aria-label",i[this.language].states[1]),b+1>o&&this.widget.find(".datepicker-months th:eq(2)").addClass("disabled").attr("aria-label",i[this.language].states[1]);for(var k=0;k<12;k++)(t==s&&n>k||t<s||t==o&&r<k||t>o)&&SobiPro.jQuery(w[k]).addClass("disabled").attr("aria-label",i[this.language].states[1]);m="",t=10*parseInt(t/10,10);var v=this.widget.find(".datepicker-years").find("th:eq(1)").text(t+"-"+(t+9)).end().find("td");this.widget.find(".datepicker-years").find("th").removeClass("disabled"),s>t&&this.widget.find(".datepicker-years").find("th:eq(0)").addClass("disabled").attr("aria-label",i[this.language].states[1]),o<t+9&&this.widget.find(".datepicker-years").find("th:eq(2)").addClass("disabled").attr("aria-label",i[this.language].states[1]),t-=1;for(k=-1;k<11;k++){var y=-1===k?" old":10===k?" new":"",T=t<s||t>o?i[this.language].states[1]:"",C=b===t?i[this.language].states[0]:"";m+='<span class="year'+y+(b===t?" active":"")+(t<s||t>o?" disabled":"")+'" '+(f=T||C?' aria-label="'+C+" "+T+'"':"")+' role="button">'+t+"</span>",t+=1}v.html(m)},fillHours:function(){var t=this.widget.find(".timepicker .timepicker-hours table");t.parent().hide();var e="";if(this.options.pick12HourFormat)for(var i=1,a=0;a<3;a+=1){e+="<tr>";for(var s=0;s<4;s+=1){e+='<td class="hour" role="button">'+d(i.toString(),2,"0")+"</td>",i++}e+="</tr>"}else for(i=0,a=0;a<6;a+=1){e+="<tr>";for(s=0;s<4;s+=1){e+='<td class="hour" role="button">'+d(i.toString(),2,"0")+"</td>",i++}e+="</tr>"}t.html(e)},fillMinutes:function(){var t=this.widget.find(".timepicker .timepicker-minutes table");t.parent().hide();for(var e="",i=0,a=0;a<5;a++){e+="<tr>";for(var s=0;s<4;s+=1){e+='<td class="minute" role="button">'+d(i.toString(),2,"0")+"</td>",i+=3}e+="</tr>"}t.html(e)},fillSeconds:function(){var t=this.widget.find(".timepicker .timepicker-seconds table");t.parent().hide();for(var e="",i=0,a=0;a<5;a++){e+="<tr>";for(var s=0;s<4;s+=1){e+='<td class="second" role="button">'+d(i.toString(),2,"0")+"</td>",i+=3}e+="</tr>"}t.html(e)},fillTime:function(){if(this._date){var t=this.widget.find(".timepicker span[data-time-component]"),e=(t.closest("table"),this.options.pick12HourFormat),i=this._date.getUTCHours(),a="AM";e&&(i>=12&&(a="PM"),0===i?i=12:12!=i&&(i%=12),this.widget.find(".timepicker [data-action=togglePeriod]").text(a)),i=d(i.toString(),2,"0");var s=d(this._date.getUTCMinutes().toString(),2,"0"),n=d(this._date.getUTCSeconds().toString(),2,"0");t.filter("[data-time-component=hours]").text(i),t.filter("[data-time-component=minutes]").text(s),t.filter("[data-time-component=seconds]").text(n)}},click:function(t){t.stopPropagation(),t.preventDefault(),this._unset=!1;var e=SobiPro.jQuery(t.target).closest("span, td, th");if(1===e.length&&!e.is(".disabled"))switch(e[0].nodeName.toLowerCase()){case"th":switch(e[0].className){case"switch":this.showMode(1);break;case"prev":case"next":var i=this.viewDate,a=c.modes[this.viewMode].navFnc,s=c.modes[this.viewMode].navStep;"prev"===e[0].className&&(s*=-1),i["set"+a](i["get"+a]()+s),this.fillDate(),this.set()}break;case"span":if(e.is(".month")){var n=e.parent().find("span").index(e);this.viewDate.setUTCMonth(n)}else{var o=parseInt(e.text(),10)||0;this.viewDate.setUTCFullYear(o)}0!==this.viewMode&&(this._date=l(this.viewDate.getUTCFullYear(),this.viewDate.getUTCMonth(),this.viewDate.getUTCDate(),this._date.getUTCHours(),this._date.getUTCMinutes(),this._date.getUTCSeconds(),this._date.getUTCMilliseconds()),this.notifyChange()),this.showMode(-1),this.fillDate(),this.set();break;case"td":if(e.is(".day")){var r=parseInt(e.text(),10)||1;n=this.viewDate.getUTCMonth(),o=this.viewDate.getUTCFullYear();e.is(".old")?0===n?(n=11,o-=1):n-=1:e.is(".new")&&(11==n?(n=0,o+=1):n+=1),this._date=l(o,n,r,this._date.getUTCHours(),this._date.getUTCMinutes(),this._date.getUTCSeconds(),this._date.getUTCMilliseconds()),this.viewDate=l(o,n,Math.min(28,r),0,0,0,0),this.fillDate(),this.set(),this.notifyChange()}}},actions:{incrementHours:function(t){this._date.setUTCHours(this._date.getUTCHours()+1)},incrementMinutes:function(t){this._date.setUTCMinutes(this._date.getUTCMinutes()+1)},incrementSeconds:function(t){this._date.setUTCSeconds(this._date.getUTCSeconds()+1)},decrementHours:function(t){this._date.setUTCHours(this._date.getUTCHours()-1)},decrementMinutes:function(t){this._date.setUTCMinutes(this._date.getUTCMinutes()-1)},decrementSeconds:function(t){this._date.setUTCSeconds(this._date.getUTCSeconds()-1)},togglePeriod:function(t){var e=this._date.getUTCHours();e>=12?e-=12:e+=12,this._date.setUTCHours(e)},showPicker:function(){this.widget.find(".timepicker > div:not(.timepicker-picker)").hide(),this.widget.find(".timepicker .timepicker-picker").show()},showHours:function(){this.widget.find(".timepicker .timepicker-picker").hide(),this.widget.find(".timepicker .timepicker-hours").show()},showMinutes:function(){this.widget.find(".timepicker .timepicker-picker").hide(),this.widget.find(".timepicker .timepicker-minutes").show()},showSeconds:function(){this.widget.find(".timepicker .timepicker-picker").hide(),this.widget.find(".timepicker .timepicker-seconds").show()},selectHour:function(t){var e=SobiPro.jQuery(t.target),i=parseInt(e.text(),10);this.options.pick12HourFormat&&(this._date.getUTCHours()>=12?12!=i&&(i=(i+12)%24):12===i?i=0:i%=12);this._date.setUTCHours(i),this.actions.showPicker.call(this)},selectMinute:function(t){var e=SobiPro.jQuery(t.target),i=parseInt(e.text(),10);this._date.setUTCMinutes(i),this.actions.showPicker.call(this)},selectSecond:function(t){var e=SobiPro.jQuery(t.target),i=parseInt(e.text(),10);this._date.setUTCSeconds(i),this.actions.showPicker.call(this)}},doAction:function(t){t.stopPropagation(),t.preventDefault(),this._date||(this._date=l(1970,0,0,0,0,0,0));var e=SobiPro.jQuery(t.currentTarget).data("action"),i=this.actions[e].apply(this,arguments);return this.set(),this.fillTime(),this.notifyChange(),i},stopEvent:function(t){t.stopPropagation(),t.preventDefault()},keydown:function(t){var e=this,i=t.which,a=SobiPro.jQuery(t.target);8!=i&&46!=i||setTimeout((function(){e._resetMaskPos(a)}))},keypress:function(t){var e=t.which;if(8!=e&&46!=e){var i=SobiPro.jQuery(t.target),a=String.fromCharCode(e),s=i.val()||"";s+=a;var n=this._mask[this._maskPos];if(!n)return!1;if(n.end==s.length){if(!n.pattern.test(s.slice(n.start))){for(s=s.slice(0,s.length-1);(n=this._mask[this._maskPos])&&n.character;)s+=n.character,this._maskPos++;return s+=a,n.end!=s.length?(i.val(s),!1):n.pattern.test(s.slice(n.start))?(i.val(s),this._maskPos++,!1):(i.val(s.slice(0,n.start)),!1)}this._maskPos++}}},change:function(t){var e=SobiPro.jQuery(t.target),i=e.val();this._formatPattern.test(i)?(this.update(),this.setValue(this._date.getTime()),this.notifyChange(),this.set()):i&&i.trim()?(this.setValue(this._date.getTime()),this._date?this.set():e.val("")):this._date&&(this.setValue(null),this.notifyChange(),this._unset=!0),this._resetMaskPos(e)},showMode:function(t){t&&(this.viewMode=Math.max(this.minViewMode,Math.min(2,this.viewMode+t))),this.widget.find(".datepicker > div").hide().filter(".datepicker-"+c.modes[this.viewMode].clsName).show()},destroy:function(){this._detachDatePickerEvents(),this._detachDatePickerGlobalEvents(),this.widget.remove(),this.$element.removeData("datetimepicker"),this.component.removeData("datetimepicker")},formatDate:function(t){return this.format.replace(r,(function(e){var i,s,n,o=e.length;if("ms"===e&&(o=1),"Hours12"===(s=a[e].property))0===(n=t.getUTCHours())?n=12:12!==n&&(n%=12);else{if("Period12"===s)return t.getUTCHours()>=12?"PM":"AM";n="UTCYear"===s?(n=t.getUTCFullYear()).toString().substr(2):t[i="get"+s]()}return"getUTCMonth"===i&&(n+=1),d(n.toString(),o,"0")}))},parseDate:function(t){var e,i,a,s,n={};if(!(e=this._formatPattern.exec(t)))return null;for(i=1;i<e.length;i++)(a=this._propertiesByIndex[i])&&(s=e[i],/^\d+$/.test(s)&&(s=parseInt(s,10)),n[a]=s);return this._finishParsingDate(n)},_resetMaskPos:function(t){for(var e=t.val(),i=0;i<this._mask.length;i++){if(this._mask[i].end>e.length){this._maskPos=i;break}if(this._mask[i].end===e.length){this._maskPos=i+1;break}}},_finishParsingDate:function(t){var e,i,a,s,n,o,r;return e=t.UTCFullYear,t.UTCYear&&(e=2e3+t.UTCYear),e||(e=1970),i=t.UTCMonth?t.UTCMonth-1:0,a=t.UTCDate||1,s=t.UTCHours||0,n=t.UTCMinutes||0,o=t.UTCSeconds||0,r=t.UTCMilliseconds||0,t.Hours12&&(s=t.Hours12),t.Period12&&(/pm/i.test(t.Period12)?12!=s&&(s=(s+12)%24):s%=12),l(e,i,a,s,n,o,r)},_compileFormat:function(){for(var t,e,i=[],s=[],n=this.format,r={},d=0,l=0;t=o.exec(n);)(e=t[0])in a?(r[++d]=a[e].property,i.push("\\s*"+a[e].getPattern(this)+"\\s*"),s.push({pattern:new RegExp(a[e].getPattern(this)),property:a[e].property,start:l,end:l+=e.length})):(i.push(h(e)),s.push({pattern:new RegExp(h(e)),character:e,start:l,end:++l})),n=n.slice(e.length);this._mask=s,this._maskPos=0,this._formatPattern=new RegExp("^\\s*"+i.join("")+"\\s*$"),this._propertiesByIndex=r},_attachSpecialButtons:function(){var t=this;this.widget.on("click",".ctrl-set-now",(function(){var e=new Date;t.update(e),t.$element.find("input:text").data("timeOffset")&&0!=parseInt(t.$element.find("input:text").data("timeOffset"))?e=new Date(Date.now()+1e3*t.$element.find("input:text").data("timeOffset")):0!=parseInt(t.$element.find("input:text").data("timeOffset"))&&(e=new Date(Date.now()-6e4*e.getTimezoneOffset()),t.update(e)),t._date=e,t.fillDate(),t.set(),t.notifyChange()})),this.widget.on("click",".ctrl-reset-date",(function(){t.hide();var e=t.$element.find("input:text");e.val(""),t._resetMaskPos(e),t.$element.data("date",""),t.notifyChange()}))},_attachDatePickerEvents:function(){var t=this;this.widget.on("click",".datepicker *",SobiPro.jQuery.proxy(this.click,this)),this.widget.on("click","[data-action]",SobiPro.jQuery.proxy(this.doAction,this)),this.widget.on("mousedown",SobiPro.jQuery.proxy(this.stopEvent,this)),this.pickDate&&this.pickTime&&this.widget.on("click.togglePicker",".ctrl-toggle-type",(function(e){e.stopPropagation();var a=SobiPro.jQuery(this),s=a.closest("ul"),n=s.find(".collapse.show"),o=s.find(".collapse:not(.show)");if(n&&n.length){var r=n.data("collapse");if(r&&r.transitioning)return;n.removeClass("show").removeClass("in"),o.addClass("show").addClass("in");var h=a.data("widget-icon");h=h==t.widgetTime?t.widgetDate:t.widgetTime,a.data("widget-icon",h),a.html(SobiPro.Ico(h));var d=h==t.widgetTime?i[t.language].buttons[2]:i[t.language].buttons[3];a.attr("title",d).attr("aria-label",d),t.$element.find(".spctrl-trigger-icon").toggleClass(t.timeIcon+" "+t.dateIcon)}})),this.isInput?(this.$element.on({focus:SobiPro.jQuery.proxy(this.show,this),change:SobiPro.jQuery.proxy(this.change,this)}),this.options.maskInput&&this.$element.on({keydown:SobiPro.jQuery.proxy(this.keydown,this),keypress:SobiPro.jQuery.proxy(this.keypress,this)})):(this.$element.on({change:SobiPro.jQuery.proxy(this.change,this)},"input"),this.options.maskInput&&this.$element.on({keydown:SobiPro.jQuery.proxy(this.keydown,this),keypress:SobiPro.jQuery.proxy(this.keypress,this)},"input"),this.component?this.component.on("click",SobiPro.jQuery.proxy(this.show,this)):this.$element.on("click",SobiPro.jQuery.proxy(this.show,this)))},_attachDatePickerGlobalEvents:function(){SobiPro.jQuery(window).on("resize.datetimepicker"+this.id,SobiPro.jQuery.proxy(this.place,this)),this.isInput||SobiPro.jQuery(document).on("mousedown.datetimepicker"+this.id,SobiPro.jQuery.proxy(this.hide,this))},_detachDatePickerEvents:function(){this.widget.off("click",".datepicker *",this.click),this.widget.off("click","[data-action]"),this.widget.off("mousedown",this.stopEvent),this.pickDate&&this.pickTime&&this.widget.off("click.togglePicker"),this.isInput?(this.$element.off({focus:this.show,change:this.change}),this.options.maskInput&&this.$element.off({keydown:this.keydown,keypress:this.keypress})):(this.$element.off({change:this.change},"input"),this.options.maskInput&&this.$element.off({keydown:this.keydown,keypress:this.keypress},"input"),this.component?this.component.off("click",this.show):this.$element.off("click",this.show))},_detachDatePickerGlobalEvents:function(){SobiPro.jQuery(window).off("resize.datetimepicker"+this.id),this.isInput||SobiPro.jQuery(document).off("mousedown.datetimepicker"+this.id)},_isInFixed:function(){if(this.$element){for(var t=this.$element.parents(),e=!1,i=0;i<t.length;i++)if("fixed"==SobiPro.jQuery(t[i]).css("position")){e=!0;break}return e}return!1},_getPickerSwitch:function(t,e){return e.pickDate&&e.pickTime?'<div class="SobiPro bootstrap-datetimepicker-widget"><ul><li'+(e.collapse?' class="collapse show in"':"")+'><div class="datepicker">'+this._createDateTemplate(e)+"</div></li><li"+(e.collapse?' class="collapse"':"")+'><div class="timepicker">'+this._createTimeTemplate(e)+'</div></li><li class="picker-switch"><a class="btn ctrl-reset-date" role="button" title="'+i[this.language].buttons[0]+'" aria-label="'+i[this.language].buttons[0]+'">'+SobiPro.Ico("remove")+'</a><a class="btn ctrl-set-now" role="button" title="'+i[this.language].buttons[1]+'" aria-label="'+i[this.language].buttons[1]+'">'+SobiPro.Ico("ok")+'</a><a class="btn ctrl-toggle-type" role="button" title="'+i[this.language].buttons[2]+'" aria-label="'+i[this.language].buttons[2]+'" data-widget-icon="'+t+'">'+SobiPro.Ico(t)+"</a></li></ul></div>":e.pickTime?'<div class="SobiPro bootstrap-datetimepicker-widget"><div class="timepicker">'+this._createTimeTemplate(e)+"</div></div>":'<div class="SobiPro bootstrap-datetimepicker-widget"><ul><div class="datepicker">'+this._createDateTemplate(e)+'</div></li><li class="picker-switch"><a class="btn ctrl-reset-date" role="button" title="'+i[this.language].buttons[0]+'" aria-label="'+i[this.language].buttons[0]+'">'+SobiPro.Ico("remove")+'</a><a class="btn ctrl-set-now" role="button" title="'+i[this.language].buttons[1]+'" aria-label="'+i[this.language].buttons[1]+'">'+SobiPro.Ico("ok")+"</a></li></ul></div>"},_createDateTemplate:function(t){var e='<tbody><tr><td colspan="7"></td></tr></tbody>';return'<div class="datepicker-days" aria-label="'+i[this.language].picks[3]+'"><table class="table-condensed">'+this._createHeadTemplate(i[this.language].prevs[0],i[this.language].nexts[0],i[this.language].switches[3])+'<tbody></tbody></table></div><div class="datepicker-months" aria-label="'+i[this.language].picks[4]+'"><table class="table-condensed">'+this._createHeadTemplate(i[this.language].prevs[1],i[this.language].nexts[1],i[this.language].switches[4])+e+'</table></div><div class="datepicker-years" aria-label="'+i[this.language].picks[5]+'"><table class="table-condensed">'+this._createHeadTemplate(i[this.language].prevs[2],i[this.language].nexts[2],"")+e+"</table></div>"},_createTimeTemplate:function(t){return'<div class="timepicker-picker"><table class="table-condensed"'+(t.pick12HourFormat?' data-hour-format="12"':"")+'><tr><td><a href="#" class="btn" role="button" title="'+i[this.language].countup[2]+'" aria-label="'+i[this.language].countup[2]+'" data-action="incrementHours">'+SobiPro.Ico("chevron-up")+'</a></td><td class="separator"></td><td><a href="#" class="btn" role="button" title="'+i[this.language].countup[1]+'" aria-label="'+i[this.language].countup[1]+'" data-action="incrementMinutes">'+SobiPro.Ico("chevron-up")+"</a></td>"+(t.pickSeconds?'<td class="separator"></td><td><a href="#" class="btn" role="button" title="'+i[this.language].countup[0]+'" aria-label="'+i[this.language].countup[0]+'" data-action="incrementSeconds">'+SobiPro.Ico("chevron-up")+"</a></td>":"")+(t.pick12HourFormat?'<td class="separator"></td>':"")+"</tr><tr><td>"+this._createHourTemplate()+'</td> <td class="separator">:</td><td>'+this._createMinuteTemplate()+"</td> "+(t.pickSeconds?'<td class="separator">:</td><td>'+this._createSecondTemplate()+"</td>":"")+(t.pick12HourFormat?'<td class="separator"></td><td><button type="button" class="btn ampm" data-action="togglePeriod"></button></td>':"")+'</tr><tr><td><a href="#" class="btn" role="button" title="'+i[this.language].countdown[2]+'" aria-label="'+i[this.language].countdown[2]+'" data-action="decrementHours">'+SobiPro.Ico("chevron-down")+'</a></td><td class="separator"></td><td><a href="#" class="btn" role="button" title="'+i[this.language].countdown[1]+'" aria-label="'+i[this.language].countdown[1]+'" data-action="decrementMinutes">'+SobiPro.Ico("chevron-down")+"</a></td>"+(t.pickSeconds?'<td class="separator"></td><td><a href="#" class="btn" role="button" title="'+i[this.language].countdown[0]+'" aria-label="'+i[this.language].countdown[0]+'" data-action="decrementSeconds">'+SobiPro.Ico("chevron-down")+"</a></td>":"")+(t.pick12HourFormat?'<td class="separator"></td>':"")+'</tr></table></div><div class="timepicker-hours" aria-label="'+i[this.language].picks[2]+'" data-action="selectHour"><table class="table-condensed"></table></div><div class="timepicker-minutes" aria-label="'+i[this.language].picks[1]+'" data-action="selectMinute"><table class="table-condensed"></table></div>'+(t.pickSeconds?'<div class="timepicker-seconds" aria-label="'+i[this.language].picks[0]+'" data-action="selectSecond"><table class="table-condensed"></table></div>':"")},_createHourTemplate:function(){return'<span data-action="showHours" data-time-component="hours" class="timepicker-hour" role="button" title="'+i[this.language].switches[2]+'" aria-label="'+i[this.language].switches[2]+'"></span>'},_createMinuteTemplate:function(){return'<span data-action="showMinutes" data-time-component="minutes" class="timepicker-minute" role="button" title="'+i[this.language].switches[1]+'" aria-label="'+i[this.language].switches[1]+'"></span>'},_createSecondTemplate:function(){return'<span data-action="showSeconds" data-time-component="seconds" class="timepicker-second" role="button" title="'+i[this.language].switches[0]+'" aria-label="'+i[this.language].switches[0]+'"></span>'},_createHeadTemplate:function(t,e,i){return'<thead><tr><th class="prev" title="'+t+'" aria-label="'+t+'" role="button">&lsaquo;</th><th colspan="5" class="switch" '+(i?'title="'+i+'" aria-label="'+i+'"role="button"':"")+'></th><th class="next" title="'+e+'" aria-label="'+e+'" role="button">&rsaquo;</th></tr></thead>'}},SobiPro.jQuery.fn.SpDateTimePicker=function(e,i){return this.each((function(){var a=SobiPro.jQuery(this),s=a.data("datetimepicker"),n="object"==typeof e&&e;s||a.data("datetimepicker",s=new t(this,SobiPro.jQuery.extend({},SobiPro.jQuery.fn.SpDateTimePicker.defaults,n))),"string"==typeof e&&s[e](i)}))},SobiPro.jQuery.fn.SpDateTimePicker.defaults={maskInput:!1,pickDate:!0,pickTime:!0,pick12HourFormat:!1,pickSeconds:!0,startDate:-1/0,endDate:1/0,collapse:!0},SobiPro.jQuery.fn.SpDateTimePicker.Constructor=t;var e=0,i=SobiPro.jQuery.fn.SpDateTimePicker.strings={en:spDatePickerLang},a={dd:{property:"UTCDate",getPattern:function(){return"(0?[1-9]|[1-2][0-9]|3[0-1])\\b"}},MM:{property:"UTCMonth",getPattern:function(){return"(0?[1-9]|1[0-2])\\b"}},yy:{property:"UTCYear",getPattern:function(){return"(\\d{2})\\b"}},yyyy:{property:"UTCFullYear",getPattern:function(){return"(\\d{4})\\b"}},hh:{property:"UTCHours",getPattern:function(){return"(0?[0-9]|1[0-9]|2[0-3])\\b"}},mm:{property:"UTCMinutes",getPattern:function(){return"(0?[0-9]|[1-5][0-9])\\b"}},ss:{property:"UTCSeconds",getPattern:function(){return"(0?[0-9]|[1-5][0-9])\\b"}},ms:{property:"UTCMilliseconds",getPattern:function(){return"([0-9]{1,3})\\b"}},HH:{property:"Hours12",getPattern:function(){return"(0?[1-9]|1[0-2])\\b"}},PP:{property:"Period12",getPattern:function(){return"(AM|PM|am|pm|Am|aM|Pm|pM)\\b"}}},s=[];for(var n in a)s.push(n);s[s.length-1]+="\\b",s.push(".");var o=new RegExp(s.join("\\b|"));s.pop();var r=new RegExp(s.join("\\b|"),"g");function h(t){return t.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g,"\\$&")}function d(t,e,i){return e<t.length?t:Array(e-t.length+1).join(i||" ")+t}function l(){return new Date(Date.UTC.apply(Date,arguments))}var c={modes:[{clsName:"days",navFnc:"UTCMonth",navStep:1},{clsName:"months",navFnc:"UTCFullYear",navStep:1},{clsName:"years",navFnc:"UTCFullYear",navStep:10}],isLeapYear:function(t){return t%4==0&&t%100!=0||t%400==0},getDaysInMonth:function(t,e){return[31,c.isLeapYear(t)?29:28,31,30,31,30,31,31,30,31,30,31][e]}}}(SobiPro.jQuery),SobiCore.Ready((function(){SobiPro.jQuery(".spctrl-datepicker").each((function(t,e){var i=this;SobiPro.jQuery(e).SpDateTimePicker(SobiPro.jQuery(e).find("input[type=text]").data()).on("changeDate",(function(t){var e="";t.date.valueOf()&&SobiPro.jQuery(i).find(":text").val()&&(e=t.date.valueOf(),SobiPro.jQuery(i).find("input:text").data("timeOffset")&&0!=parseInt(SobiPro.jQuery(i).find("input:text").data("timeOffset"))&&(e=new Date(e-1e3*SobiPro.jQuery(i).find("input:text").data("timeOffset")).getTime())),SobiPro.jQuery(i).find(":hidden").val(e),SobiPro.jQuery(i).trigger("OnDateChanged",[e,SobiPro.jQuery(this)])}))}))}));