jQuery(document).ready(function (jQuery) {
    // Declara $ para evitar conflito
    $ = jQuery;
    // Scripts que são necessários estarem carregados na página
    var scripts = [
        "https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.0/jquery-confirm.min.js",
        "../libraries/noboss/assets/plugins/stylesheets/css/jquery-confirm.min.css",
    ];
    // Carrega os scripts que ainda não estão na página 
    var queue = scripts.map(function (script) {
        if (script.slice(-2) === 'js' && jQuery("script[src*='" + script.slice(-30) + "']").length === 0) {
            return jQuery("head").append('<script type="text/javascript" src="' + script + '"></script>');
        } else if (script.slice(-3) === 'css' && jQuery("link[href*='" + script.slice(-30) + "']").length === 0) {
            return jQuery("head").append('<link rel="stylesheet" href="' + script + '"/>');
        }
    });

    // Todos scripts necessário estão carregados
    jQuery.when.apply(null, queue).done(function () {
        // Executa somente apos estar carregada biblioteca slimScroll na pagina
        (function() {
            var nTimer = setInterval(function() {
                if (jQuery().confirm != undefined) {                    
                    clearInterval(nTimer);
                    nobossCalendarSubform.CONSTRUCTOR();
                }
            }, 50);
        })();
    });
});

var nobossCalendarSubform = {};

nobossCalendarSubform.CONSTRUCTOR = function () {
    // Obtem id do modulo a partir da Url da pagina
    nobossCalendarSubform.idModule = window.location.href.split("id=");

    // Criar atributo 'id_calendar_original' no campo 'id_calendar' para guardar seu valor original (para sabermos se usuario mudar)
    jQuery('input[name$="\\[id_calendar\\]"]').attr('id_calendar_original', jQuery('input[name$="\\[id_calendar\\]"]').val());

    // Id do modulo definido: edicao de registro
    if (((nobossCalendarSubform.idModule.length) > 1) && nobossCalendarSubform.idModule[1] != 0 && nobossCalendarSubform.idModule[1] != ''){
        // Obtem o id especificamente
        nobossCalendarSubform.idModule = nobossCalendarSubform.idModule[1].split("&")[0];

        // Executa funcao que carrega as categorias
        nobossCalendarSubform.loadCategories();
    }
    // Parametro nao definido: eh um novo registro
    else{
        nobossCalendarSubform.idModule = 0;
    }
    
    // Declara array de controle de eventos a serem removidos
    nobossCalendarSubform.eventsToRemove = [];
    
    // Ativa evento de alteracao nos filtros de ano ou mes
    jQuery('[data-id="items-filter"]').on('change', '[data-id="month-filter"], [data-id="year-filter"], [data-id="limit-filter"]', nobossCalendarSubform.applyFilter);

    // Aciona evento de clique em botão de duplicar um item de subform
    jQuery(document).on('click', '[data-bt="duplicate-item"]', function () {
        // Executa funcao que fara o clone
        nobossCalendarSubform.cloneEvent(jQuery(this));
    });

    // Aciona evento de clique no botao de limpar eventos antigos
    jQuery('section#content').on('click', '[data-id="cleanoldevents"]', nobosssubform.cleanOldEvents);

    // Aciona evento de clique na aba 'Eventos' [primeiras classes sao do J3 e as ultimas J4]
    jQuery('#content').on('click', "[href='#attrib-items'], [aria-controls='attrib-items']", function(){
        // Executa trigger no filtro do mes para trazer resultados
        jQuery('[data-id="items-filter"]').find('[data-id="month-filter"]').trigger('change');
        // Mata evento de clique da aba para nao carregar novamente se usuario sair e voltar
        jQuery('#content').off('click', "[href='#attrib-items'], [aria-controls='attrib-items']");
    });

    // Pagina foi carregada com aba 'Eventos' ja selecionada [primeiras classes sao do J3 e as ultimas J4]
    if((jQuery("[href='#attrib-items'], [aria-controls='attrib-items']").attr('aria-expanded') !== undefined) && (jQuery("[aria-controls='attrib-items']").attr('aria-expanded') == 'true')){
        // Executa trigger no filtro do mes para trazer resultados
        jQuery('[data-id="items-filter"]').find('[data-id="month-filter"]').trigger('change');
    }

    // Joomla 3
    if(majorVersionJoomla !== undefined && majorVersionJoomla == '3'){
        // Evento quando novo item eh adicionado no subform
        jQuery(document).on('subform-row-add', function (event, row) {
            nobossCalendarSubform.changeRequiredDateFields(jQuery(row));
        });
    }
    // Joomla 4
    else{
        // Evento quando uma parte da pagina for atualizada (serve para o subform)
        document.addEventListener('joomla:updated', function (_ref) {
            var row = _ref.target;
            
            // Acoes comuns para J3 e J4
            nobossCalendarSubform.commonEventListener(row);       
        });
    }
};

/**
 * Acoes comuns do evento EventListener de novo item subform adicional para j3 e j4
 */
nobossCalendarSubform.commonEventListener = function(row){
    // Ativa eventos que alteram required's de campos de data conforme opcao de recorrencia escolhida
    nobossCalendarSubform.changeRequiredDateFields(jQuery(row));

    // Adiciona qnt minima de 10 caracteres nos campos de data com calendario
    jQuery('.field-calendar input').attr('minlength', '10');

    // Novo item do subform de eventos
    if(jQuery(row).data('base-name') == 'events'){
        // Verifica se data preenchida no campo multiplo (qnd usuario da enter) atinge limite minimo de caracteres. Se nao atingir, remove o valor preenchido [primeiras classes sao do J3 e as ultimas J4]
        jQuery(row).find('.nb-suform__fields .chzn-choices .search-field input[type="text"], .nb-suform__fields .choices__input.choices__input--cloned').keydown(function (e) {
            if ((e.keyCode == 13) && (jQuery(this).val().length < 10)) {
                jQuery(this).val('');
            }
        });

        // Adiciona maskara nos campos multiplooptionsinputs ('datas especificas' e 'datas a ignorar') [primeiras classes sao do J3 e as ultimas J4]
        jQuery(row).find('.nb-suform__fields .chzn-choices .search-field input[type="text"], .nb-suform__fields .choices__input.choices__input--cloned').mask("TCE9-M9-D9", {
            placeholder: "____-__-__",
            'translation': {                  
                D: {pattern: /[0-3]/}, // permite entre 0 e 3
                M: {pattern: /[01]/}, // permite 0 ou 1
                T: {pattern: /[2]/}, // permite somente 2
                C: {pattern: /[0]/},
                E: {pattern: /[2-9]/}, // permite entre 2 e 9
            }
        });

        // Adiciona maskara nos campos de data
        jQuery(row).find('.field-calendar input').mask("TCE9-M9-D9", {
            placeholder: "____-__-__",
            'translation': {                  
                D: {pattern: /[0-3]/}, // permite entre 0 e 3
                M: {pattern: /[01]/}, // permite 0 ou 1
                T: {pattern: /[2]/}, // permite somente 2
                C: {pattern: /[0]/},
                E: {pattern: /[2-9]/}, // permite entre 2 e 9
            }
        });

        // Esconde mensagem de que nao ha eventos para o filtro aplicado (caso esteja sendo exibida)
        jQuery('[data-id="no-results-alert"]').slideUp();
    }

    // Novo item do subform de horarios
    else if(jQuery(row).data('base-name') == 'hours'){
        // Adiciona maskara nos campos de horas
        jQuery(row).find('.clockpicker .hour-input').mask("h9:m9", {
            placeholder: "__:__",
            'translation': {                  
                h: {pattern: /[0-2]/},
                m: {pattern: /[0-5]/}
            }
        });
    }
    // Novo item do subform de datas e horarios
    else if(jQuery(row).data('base-name') == 'specific-dates-hours'){
        // Adiciona maskara nos campos de horas
        jQuery(row).find('.clockpicker .hour-input').mask("h9:m9", {
            placeholder: "__:__",
            'translation': {                  
                h: {pattern: /[0-2]/},
                m: {pattern: /[0-5]/}
            }
        });
        // Adiciona maskara nos campos de data
        jQuery(row).find('.field-calendar .date-hour-input').mask("TCE9-M9-D9", {
            placeholder: "____-__-__",
            'translation': {                  
                D: {pattern: /[0-3]/}, // permite entre 0 e 3
                M: {pattern: /[01]/}, // permite 0 ou 1
                T: {pattern: /[2]/}, // permite somente 2
                C: {pattern: /[0]/},
                E: {pattern: /[2-9]/}, // permite entre 2 e 9
            }
        });
    }

}

/**
 * Intercepta o save do Joomla
 */
nobossCalendarSubform.interceptSave = function(){
    // Obtem subform de eventos
    var subform = jQuery('[data-id="items-filter"]').siblings('[data-subform-collapse-wrapper]').first();

    // Existem items exibidos no subform de eventos
    if (subform.find('.subform-repeatable-group[data-base-name="events"]').length || nobossCalendarSubform.eventsToRemove.length) {
        // // Valida campos obrigatorios
        // if(!nobossCalendarSubform.validateRequiredSubformFields()){
        //     return false;
        // }
        // Erro ao salvar eventos
        if(!nobossCalendarSubform.saveEvents(subform)){
            return false;
        }        
    }

    // Salva as categorias
    nobossCalendarSubform.saveCategories();

    var idCalendar = jQuery('input[name$="\\[id_calendar\\]"]').val();
    var idCalendarOriginal = jQuery('input[name$="\\[id_calendar\\]"]').attr('id_calendar_original');

    // Id calendar foi alterado
    if(idCalendar != idCalendarOriginal){
        // Executa funcao para atualizar todos eventos e categorias no banco para o novo id calendar
        nobossCalendarSubform.updateIdCalendarDataBase(idCalendar, idCalendarOriginal);
    }
};

/**
 * Obtem eventos do banco de dados conforme filtros selecionados
 */
nobossCalendarSubform.getEvents = function (year, month) {
    // Obtem id do calendario (que eh gerado randomicamente)
    var idCalendar = jQuery('input[name$="\\[id_calendar\\]"]').val();

    var events = '';

    // Monta a url de requisição
    var request = {
        'option': 'com_nobossajax',
        'module': 'nobosscalendar',
        'method': 'getEventsAdmin',
        'format': 'raw',
        'lang': sefLanguage
    };
    // Monta os dados a serem enviados
    var data = {
        'id_calendar': idCalendar,
        'id_calendar_original': jQuery('input[name$="\\[id_calendar\\]"]').attr('id_calendar_original')
    };

    // Definido ano
    if(year != 'all'){
        data.year = year;
    }
    else{
        data.year = '';
    }
    // Definido mes
    if(month != 'all'){
        data.month = month;
    }
    else{
        data.month = '';
    }

    try{
        // Executa requisicao ajax
        jQuery.ajax({
            url: baseNameUrl+ "administrator/index.php?" + jQuery.param(request),
            type: "POST",
            dataType: 'JSON',
            async: false,
            data: data
        }).done(function (result) {
            // Se nao estiver definido, nao faz nada.
            if((result == null) || (result == '')){
            } 
            // Ocorreu um erro
            else if (result.success == 0){
                // Exibe um alerta avisando que teve erro
                jQuery.alert({
                    title: 'Error',
                    content: result.error_database,
                    type: 'red',
                    buttons: {
                        ok: {
                            keys: ['enter']
                        }
                    }
                });
                return false;
            }
            else if((result.events == undefined) || (result.events.length == 0)){
                return false;
            }
            
            // Dados obtidos com sucesso
            events = result.events;
        });
    }
    // Trata eventuais erros
    catch (e) {
        // Erro de sintaxe (normalmente ocorre por problema de caracter invalido nos dados retornados do curso)
        if (e instanceof SyntaxError) {
            jQuery.alert({
                title: 'Error',
                content: result.error_json + e.message,
                type: 'red',
                buttons: {
                    ok: {
                        keys: ['enter']
                    }
                }
            });

        }
        // Ocorreu algum outro erro de JS
        else {
            jQuery.alert({
                title: 'Error',
                content: result.error_js + e.message,
                type: 'red',
                buttons: {
                    ok: {
                        keys: ['enter']
                    }
                }
            });
        }
        return false;
   }

   return events;
};


/**
 * Funcao que valida campos obrigadorios dos subforms
 */
nobossCalendarSubform.validateRequiredSubformFields = function () {
    var is_empty = false;

    // Percorre todos os campos do subform que estao com required
    jQuery('[name="jform[params][events]"]').parent().find('[required]').each( function(idx, elem) {
        // Verifica se campo esta vazio OU se atingiu limite minimo de caracteres (qnd definido)
        if((jQuery.trim(jQuery(elem).val()) == '') || ((jQuery(elem).attr('minlength') !== undefined) && (jQuery(elem).val().length < jQuery(elem).attr('minlength')))){
            is_empty = true;
        }
        
    });
    
    // Existem campos obrigatorios nao preenchidos: exibe mensagem de erro em modal de aviso e interrompe script
    if (is_empty) {
        jQuery.alert({
            title: 'Notice',
            content: Joomla.JText._("MOD_NOBOSSCALENDAR_MANDATORY_FIELDS_EVENTS"),
            type: 'red',
            buttons: {
                ok: {
                    keys: ['enter']
                }
            }
        });
        return false;
    }

    return true;
}

/**
 * Funcao executada quando um filtro eh aplicado
 * 
 * Pega o ano e mes selecionado e exibe os eventos que se aplicam ao filtro
 */
nobossCalendarSubform.applyFilter = function () {
    // Valida campos obrigatorios
    if(!nobossCalendarSubform.validateRequiredSubformFields()){
        return false;
    }

    // Adiciona loader durante carregamento dos dados (se ja nao estiver exibido)
    if (jQuery("div.loader--fullpage").length == 0){
        jQuery('body').append('<div class="loader loader--fullpage"></div>');
        jQuery('body').append('<div class="loader-fade"></div>');
    }

    relatedTheme = jQuery('[name$="\\[theme\\]"]').val();
    
    // Esconde botoes de collapse (soh vai exibir se tiver resultados a carregar)
    jQuery('#attrib-items [data-id=noboss-collapse-button]').hide();

    // Remove botao de exibicao de todos resultados (caso esteja exibido)
    jQuery('[data-bt="show-all-results"]').remove();

    // botao clicado
    var clicked = jQuery(this);
    // secao de filtro desse botao especifico
    var filterSection = clicked.closest('[data-id="items-filter"]');
    // elemento do subform desse tema
    var subform = filterSection.siblings('[data-subform-collapse-wrapper], [data-subform-single-wrapper]');
    // botao de limpar os itens
    var resetButton = subform.find('[data-id="noboss-subform-reset"]');
    // botoes de abrir e fechar o collapse
    var collapseButtons = resetButton.closest('[data-subform-collapse-wrapper], [data-subform-single-wrapper]').find('[data-id="noboss-collapse-button"]');

    // Existem items exibidos no subform de eventos
    if (subform.find('.subform-repeatable-group[data-base-name="events"]').length || nobossCalendarSubform.eventsToRemove.length) {
        // Salva eventos que estao sendo exibidos no subform
        nobossCalendarSubform.saveEvents(subform);
    }
    // Selecionada opcao 'todos os anos': esconde o filtro de mes
    if (filterSection.find('[data-id="year-filter"]').val() == "all"){
        filterSection.find('[data-id="month-filter"]').val('all').parent().hide();
    }
    // Selecionada opcao de um ano válido: exibe o filtro de mes
    else{
        filterSection.find('[data-id="month-filter"]').parent().show();
    }
    // se um mes nao foi selecionado sai da funcao
    if (filterSection.find('[data-id="month-filter"]').val() == "") {
        // exibe alerta de selecionar mes
        filterSection.find('[data-id="no-month-alert"]').slideDown();
        // esconde alerta de sem eventos encontrados
        filterSection.find('[data-id="no-results-alert"]').slideUp();
        // esconde o botao de limpar dados do subform pois nao ha itens
        resetButton.hide();
        // aproveita requisicao para pegar botoes de expandir e recolher que tambem seguem mesma regra
        collapseButtons.hide();
        // remove o loader
        jQuery('body').find('.loader.loader--fullpage').remove();
        jQuery('body').find('.loader-fade').remove();
        return;
    }
    // esconde o aviso de selecionar mes
    filterSection.find('[data-id="no-month-alert"]').slideUp();
    
    // guarda o ano selecionado
    var year = filterSection.find('[data-id="year-filter"]').val();
    // guarda o mes selecionado
    var month = filterSection.find('[data-id="month-filter"]').val();
    // Limite de eventos a exibir no subform
    var limitEvents = filterSection.find('[data-id="limit-filter"]').val();
    
    // Obtem eventos do banco conforme filtro selecionado
    var events = nobossCalendarSubform.getEvents(year, month);

    // Atualiza cookie que guarda ultimos filtros de ano e meses selecionados
    nobosssubform.setCookie('cache-filter', year+"|"+month+"|"+limitEvents, 1);
    
    // Array para armazenar eventos que nao serao exibidos por conta do limite
    var eventsToDisplay = [];
        
    // Coloca timeout para que loader seja exibido antes de 'travar' a pagina
    setTimeout(function () {
    
        if(events.length > 0){
            try{
                // Percorre os eventos retornados
                jQuery.each(events, function (i, obj) {
                    // Converte o json do evento para um objeto
                    // TODO: qnd tirarmos a coluna data_json, esse parse nao eh mais necessario
                    obj = JSON.parse(obj);

                    // Converte o json do campo recurrent_days em um objeto
                    if((obj.recurrent_days !== undefined) && (obj.recurrent_days.length > 0)){
                        obj.recurrent_days = JSON.parse(obj.recurrent_days);
                    }
                    // Converte o json do campo specific_dates em um objeto
                    if((obj.specific_dates !== undefined) && (obj.specific_dates.length > 0)){
                        obj.specific_dates = JSON.parse(obj.specific_dates);
                    }
                    // Converte o json do campo hours em um objeto
                    if((obj.hours !== undefined) && (obj.hours.length > 0)){
                        // Converte ## em aspas (foi alterado antes para nao dar problema no json transitando via js)
                        obj.hours = obj.hours.replace(/"/g, '\\"');
                        //obj.hours = JSON.parse(obj.hours);
                    }
                    // Converte o json do campo recurrent_days_ignore em um objeto
                    if((obj.recurrent_days_ignore !== undefined) && (obj.recurrent_days_ignore.length > 0)){
                        obj.recurrent_days_ignore = JSON.parse(obj.recurrent_days_ignore);
                    }

                    // Esta dentro do limite: exibe subform
                    if((limitEvents == 'all') || (i<limitEvents)){
                        // adiciona novo item do subform
                        nobosssubform.addSubform(subform);

                        // Insere os dados do objeto no ultimo subform criado na pagina
                        nobossCalendarSubform.objectToSubform(obj, subform.find('[data-new="true"][data-base-name="events"], [data-new="1"][data-base-name="events"]').last());
                    }
                    // Coloca evento em array para ser exibido com paginacao
                    else{
                        // Armazenar obj em array para ser exibido depois a partir de botao de paginacao
                        eventsToDisplay.push(obj);
                    }
                });

                // Existem eventos que nao foram exibidos
                if(eventsToDisplay.length > 0){
                    // Exibe botao de 'Ver todos resultados'
                    subform.append('<a data-bt="show-all-results" class="btn btn-nb" style="margin: auto;display: table;margin-top: 30px;"><span class="icon-plus-circle" aria-hidden="true"></span> '+Joomla.JText._("MOD_NOBOSSCALENDAR_ITEMS_FILTER_BT_ALL_DIPLAY")+'</a>');

                    // Mata eventos de clique do botao que possam existir
                    jQuery(document).off('click', '[data-bt="show-all-results"]');

                    // Cria evento para botao
                    jQuery(document).on('click', '[data-bt="show-all-results"]', function () {
                        // Adiciona loader durante carregamento dos dados (se ja nao estiver exibido)
                        if (jQuery("div.loader--fullpage").length == 0){
                            jQuery('body').append('<div class="loader loader--fullpage"></div>');
                            jQuery('body').append('<div class="loader-fade"></div>');
                        }

                        // Coloca timeout para que loader seja exibido antes de 'travar' a pagina
                        setTimeout(function () {
                            // Percorre os eventos que faltam
                            jQuery.each(eventsToDisplay, function (i, obj) {
                                // adiciona novo item do subform
                                nobosssubform.addSubform(subform);

                                // Insere os dados do objeto no ultimo subform criado na pagina
                                nobossCalendarSubform.objectToSubform(obj, subform.find('[data-new="true"][data-base-name="events"], [data-new="1"][data-base-name="events"]').last());
                            });

                            // Remove botao de exibicao de todos resultados
                            jQuery('[data-bt="show-all-results"]').remove();

                            // Faz itens adicionados ficarem 'fechados'
                            nobosssubform.toggleCollapseAll('shrink', subform);

                            // remove o loader
                            jQuery('body').find('.loader.loader--fullpage').remove();
                            jQuery('body').find('.loader-fade').remove();
                        }, 200);
                    });
                }
            }

            // Trata eventuais erros
            catch (e) {
                jQuery.alert({
                    title: 'Error',
                    content: e.message,
                    type: 'red',
                    buttons: {
                        ok: {
                            keys: ['enter']
                        }
                    }
                });
            }
        }
        

        // verifica se nao ha itens sendo exibidos
        if (!subform.find('.subform-repeatable-group[data-base-name="events"]').length) {
            // exibe aviso de que nao ha eventos para exibir
            filterSection.find('[data-id="no-results-alert"]').slideDown();
            // esconde o botao de limpar dados do subform pois nao ha itens
            resetButton.hide();
                // aproveita requisicao para pegar botoes de expandir e recolher que tambem seguem mesma regra
            collapseButtons.hide();
        }
        // Tem itens sendo exibidos
        else {
            // caso tenha itens colapsa todos eles
            if (typeof nobosssubform !== "undefined") {
                nobosssubform.toggleCollapseAll('shrink', subform);
            }
            // e esconde a mensagem de sem resultados encontrados
            filterSection.find('[data-id="no-results-alert"]').slideUp();

            // Tema eh de cards
            if (relatedTheme == 'model2'){
                // Remove do subform o campo que permite duplicar eventos por data
                subform.find('[id$="one_event_schedule"]').parent().parent().remove();
            }
        }

        // Exibe botoes de collapse
        jQuery('#attrib-items [data-id=noboss-collapse-button]').show();

        // remove o loader
        jQuery('body').find('.loader.loader--fullpage').remove();
        jQuery('body').find('.loader-fade').remove();

        // Ativa evento para quando usuario clicar em botao de remover um item do subform
        jQuery(document).on('click', '[data-bt="remove-item"]', function () {
            var id_event = jQuery(this).closest('.subform-repeatable-group').find('input[name$="\\[id_event\\]"]').val();
            
            // Id de evento definido: armazena em array para saber que deve ser removido do banco
            if ((id_event !== undefined) && (id_event != '')){
                nobossCalendarSubform.eventsToRemove.push(id_event);
            }
        });
    }, 200);
};

/**
 * Obtem as categorias vinculadas ao id_calendar e exibe no subform
 */
nobossCalendarSubform.loadCategories = function () {
    // Obtem id do calendario (que eh gerado randomicamente)
    var idCalendar = jQuery('input[name$="\\[id_calendar\\]"]').val();

    // Monta a url de requisição
    var request = {
        'option': 'com_nobossajax',
        'module': 'nobosscalendar',
        'method': 'getCategories',
        'format': 'raw',
        'lang': sefLanguage
    };
    // Monta os dados a serem enviados
    var data = {
        'id_calendar': idCalendar
    };

    try{
        // Executa requisicao ajax
        jQuery.ajax({
            url: baseNameUrl+ "administrator/index.php?" + jQuery.param(request),
            type: "POST",
            dataType: 'JSON',
            async: false,
            data: data
        }).done(function (result) {
            // Se nao estiver definido, nao faz nada.
            if((result == null) || (result == '')){
            } 
            // Ocorreu um erro
            else if (result.success == 0){
                // Exibe um alerta avisando que teve erro
                jQuery.alert({
                    title: 'Error',
                    content: result.error,
                    type: 'red',
                    buttons: {
                        ok: {
                            keys: ['enter']
                        }
                    }
                });
                return false;
            }
            else if((result.categories == undefined) || (result.categories.length == 0)){
                return false;
            }
            
            //console.log(result.categories);

            // Subform de categorias
            var subformCategories = jQuery('input[name$="\\[categories\\]"]').parent().find('.subform-repeatable, .subform-table-layout');

            // Percorre as categorias para adicionar no subform
            jQuery.each(result.categories, function (i, obj) {
                // Adiciona novo item do subform
                nobosssubform.addSubform(subformCategories);
                
                // Obtem ultimo item recem adicionado no subform
                var lastItemSubform = subformCategories.find('[data-new="true"][data-base-name="categories"], [data-new="1"][data-base-name="categories"]').last();

                // Atualiza campo de ID
                lastItemSubform.find('input[name$="\\[id\\]"]').first().val(obj.id);

                // Adiciona legenda no item do subform
                lastItemSubform.find('input[name$="\\[legend\\]"]').first().val(obj.legend);

                // Adiciona cor da categoria no item do subform
                if (typeof obj.category_color != "undefined") {
                    lastItemSubform.find('input[name$="\\[category_color\\]"]').first().minicolors('value', obj.category_color);
                }
                
                // Seleciona opcao no campo radio 'Exibir legendas' (sim / nao)
                var showInLegends = lastItemSubform.find('input[name$="\\[show_in_legends\\]"][value="' + obj.show_in_legends + '"]');
                showInLegends.siblings('label[for="' + showInLegends.attr('id') + '"]').click();
            });
        });
    }
    // Trata eventuais erros
    catch (e) {
        jQuery.alert({
            title: 'Error',
            content: e.message,
            type: 'red',
            buttons: {
                ok: {
                    keys: ['enter']
                }
            }
        });
        return false;
   }
};

/**
 * Salva as categorias exibidas no subform
 */
nobossCalendarSubform.saveCategories = function () {
    // Subform de categorias
    var subformCategories = jQuery('input[name$="\\[categories\\]"]').parent().find('.subform-repeatable');

    // Array que ira guardar as categorias para salvar
    var categories = [];

    // Percorre os items do subform para salvar
    subformCategories.find('.subform-repeatable-group[data-base-name="categories"]').each(function () {
        var obj = {};

        // ID
        obj.id = jQuery(this).find('input[name$="\\[id\\]"]').first().val();

        // Legenda
        obj.legend = jQuery(this).find('input[name$="\\[legend\\]"]').first().val();

        // Cor da categoria
        obj.category_color = jQuery(this).find('input[name$="\\[category_color\\]"]').first().val();

        // Campo radio 'Exibir legendas' (sim / nao)
        obj.show_in_legends = jQuery(this).find('input[name$="\\[show_in_legends\\]"]:checked').val();

        // Adiciona o objeto no array de categorias
        categories.push(obj);
    });
    
    // TODO:
    //console.log(categories);

    //if(categories.length > 0){
        // Obtem id do calendario
        var idCalendar = jQuery('input[name$="\\[id_calendar\\]"]').val();
    
        // Obtem id original do calendario (antes do usuario poder alterar)
        var idCalendarOriginal = jQuery('input[name$="\\[id_calendar\\]"]').attr('id_calendar_original');
    
        var error = false;
        
        // Monta a url de requisição
        var request = {
            'option': 'com_nobossajax',
            'module': 'nobosscalendar',
            'method': 'saveCategories',
            'format': 'raw',
            'lang': sefLanguage
        };
        // Monta os dados a serem enviados
        var data = {
            'id_calendar': idCalendar,
            'id_calendar_original': idCalendarOriginal,
            'categories': categories
        };
        
        // Executa requisicao ajax
        jQuery.ajax({
            url: baseNameUrl+ "administrator/index.php?" + jQuery.param(request),
            type: "POST",
            dataType: 'JSON',
            async: false,
            data: data
        }).done(function (result) {
            // Se retorno nao estiver definido, nao faz nada
            if (result == undefined){
        
            }
            // Ocorreu um erro: exibe mensagem e retorna false para que formulario nao seja submetido
            else if (result.success == 0){
                // Exibe um alerta com o erro
                jQuery.alert({
                    title: 'Error',
                    content: result.error,
                    type: 'red',
                    buttons: {
                        ok: {
                            keys: ['enter']
                        }
                    }
                });
        
                // Remove loader (caso esteja sendo exibido)
                jQuery('body').find('.loader.loader--fullpage').remove();
                jQuery('body').find('.loader-fade').remove();
                error = true;
            }
        });

        if (error == true){
            return false;
        }
        else{
            // Remove input e subform de categorias para evitar que Joomla salve como parametro do modulo
            jQuery('input[name$="\\[categories\\]"]').parent().remove();
        }
   // }   
};

/**
 * Salva eventos que estao exibidos no subform
 */ 
nobossCalendarSubform.saveEvents = function (subform) {
    var saveEvents = [];

    // Percorre os subforms exibidos para organizar os dados a serem salvos
    subform.find('.subform-repeatable-group[data-base-name="events"]').each(function () {
        // Coloca no array um objeto que contem os dados extraidos do item do subform
        saveEvents.push(nobossCalendarSubform.subformToObject(jQuery(this)));

        // Remove campo da pagina
        jQuery(this).remove();
    });

    // Adiciona loader durante carregamento dos dados (se ja nao estiver exibido)
    if (jQuery("div.loader--fullpage").length == 0){
        jQuery('body').append('<div class="loader loader--fullpage"></div>');
        jQuery('body').append('<div class="loader-fade"></div>');
    }

    var error = false;

    // Obtem id do calendario (que eh gerado randomicamente)
    var idCalendar = jQuery('input[name$="\\[id_calendar\\]"]').val();
    
    // Monta a url de requisição
    var request = {
        'option': 'com_nobossajax',
        'module': 'nobosscalendar',
        'method': 'saveEvents',
        'format': 'raw',
        'lang': sefLanguage
    };
    // Monta os dados a serem enviados
    var data = {
        'data_json': saveEvents,
        'id_module': nobossCalendarSubform.idModule,
        'id_calendar': idCalendar,
        'events_to_remove': nobossCalendarSubform.eventsToRemove
    };
    
    // Executa requisicao ajax
    jQuery.ajax({
        url: baseNameUrl+ "administrator/index.php?" + jQuery.param(request),
        type: "POST",
        dataType: 'JSON',
        async: false,
        data: data
    }).done(function (result) {
        // Se retorno nao estiver definido, nao faz nada
        if (result == undefined){
    
        }
        // Ocorreu um erro: exibe mensagem e retorna false para que formulario nao seja submetido
        else if (result.success == 0){
            // Exibe um alerta com o erro
            jQuery.alert({
                title: 'Error',
                content: result.message,
                type: 'red',
                buttons: {
                    ok: {
                        keys: ['enter']
                    }
                }
            });
    
            // Remove loader
            jQuery('body').find('.loader.loader--fullpage').remove();
            jQuery('body').find('.loader-fade').remove();
            error = true;
        }
    });

    if (error == true){
        return false;
    }

    // Limpa o array de eventos a remover
    nobossCalendarSubform.eventsToRemove = [];
    
    return true;   
 };

/**
 * Adiciona dados em um item de subform ja criado
 */
nobossCalendarSubform.objectToSubform = function (obj, subformItem) {
    // Insere botao de duplicacao no item do subform
    // TODO: no futuro migrar esse botao para o layout do nobosssubform vinculado a library
        // - la deveremos ter um parametro que soh exibe botao se estiver definido no xml, como fazemos para os botoes de criar e remover
        // - ajustar tb a classe css colocada que esta com 'btn-success' e um style fixo para right. Devemos ter uma classe css propria para esse botao
        // - o maior desafio eh migrar a parte que clona o obejeto e depois insere os dados

    //FIXME: coloquei o campo no 'nobosssubform' original, mas as acoes de duplicacao continuam existindo somente aqui
    //subformItem.find(".btn-toolbar .btn-group").prepend('<a data-bt="duplicate-item" class="btn btn-mini button btn-success" style="right: 92px !important;"><span class="icon-copy" aria-hidden="true"></span></a>');

    // Joomla 3
    if(majorVersionJoomla !== undefined && majorVersionJoomla == '3'){
        // Cria evento de 'enter' em formato jquery p/ usar nos campos de select multiplo
        var keyboardEventEnter = jQuery.Event('keyup');
        keyboardEventEnter.which = 13;
    }
    // Joomla 4
    else{
        // Cria evento de 'enter' em formato javascript puro p/ usar nos campos de select multiplo
        var keyboardEventEnter = new KeyboardEvent('keydown', {
            code: 'Enter',
            key: 'Enter',
            charCode: 13,
            keyCode: 13,
            view: window,
            bubbles: true
        });
    }

    // Evento eh recorrente (campo radio sim/nao)
    var isRecurrent = subformItem.find('input[name$="\\[is_recurrent\\]"][value="' + obj.is_recurrent + '"]');
    isRecurrent.siblings('label[for="' + isRecurrent.attr('id') + '"]').click();  

    if ((typeof obj.recurrence_type == "undefined") || (obj.recurrence_type == '')) {
        obj.recurrence_type = 0;
    }
    // Tipo de recorrencia
    subformItem.find('select[name$="\\[recurrence_type\\]"]').first().val(obj.recurrence_type);
    
    subformItem.find('select[name$=\\[recurrence_type\\]] option').removeAttr('selected');
    subformItem.find('select[name$=\\[recurrence_type\\]] option[value='+obj.recurrence_type+']').attr('selected','selected');

    // Joomla 3
    if(majorVersionJoomla !== undefined && majorVersionJoomla == '3'){
        // Trigger chosen
        subformItem.find('select[name$="\\[recurrence_type\\]"]').trigger('liszt:updated');
        subformItem.find('select[name$="\\[recurrence_type\\]"]').trigger('change');
    }
    // Joomla 4
    else{
        subformItem.find('select[name$="\\[recurrence_type\\]"]').trigger('change').trigger('click');
    }
  
    // Dias da semana
    if((obj.recurrent_days !== undefined) && (obj.recurrent_days !== '')){
        // Marca todos inputs como nao selecionado para entao selecionar os que devem
        subformItem.find('input[name$="\\[recurrent_days][]"]').attr('checked', false);

        // Pecorre inputs e preenche corretamente no subform
        Object.keys(obj.recurrent_days).forEach(function(key){
            if (obj.recurrent_days[key] === 1){
                // Seleciona o checkbox            
                subformItem.find('input[name$="\\[recurrent_days][]"][data-recurrent-day="'+key+'"]').attr('checked', true);
            }
        });
    }

    // Horarios do evento: prepara dados em json para ser adicionado posteriormente nos subforms
    if((obj.hours !== undefined) && (obj.hours !== '')){
        // Retira '\' antes das aspas duplas
        obj.hours = obj.hours.replace(/\\"/g, '"');
        //Converte de json para objeto para poder percorrer
        obj.hours = JSON.parse(obj.hours);
    }

    // Recorrencia por datas especificas
    if (obj.recurrence_type == 'specific-dates'){
        // Datas especificas da recorrencia
        if((obj.specific_dates !== undefined) && (obj.specific_dates !== '')){
            // Pecorre opcoes e preenche corretamente no subform
            jQuery.each(obj.specific_dates, function(index, value){
                // Adiciona data corrente no campo input text
                subformItem.find('select[name*="[specific_dates]"]').parent().find('input[type="text"]').focus().val(value);

                // Joomla 3
                if(majorVersionJoomla !== undefined && majorVersionJoomla == '3'){
                    // Dispara evento de 'enter' no campo input text usando jquery
                    subformItem.find('select[name*="[specific_dates]"]').parent().find('input[type="text"]').trigger(keyboardEventEnter);
                }
                // Joomla 4
                else{
                    // Dispara evento de 'enter' no campo input text usando javascript puro
                    subformItem[0].querySelectorAll('select[name*="[specific_dates]')[0].parentElement.querySelectorAll('input[type="text"]')[0].dispatchEvent(keyboardEventEnter);
                }
            });
        }  
    }
    
    // Recorrencia para data e horarios especificos: preenche subform especifico de datas e horarios
    if (obj.recurrence_type == 'specific-dates-hours'){
        // Datas estao definidas (utilizamos o campo de datas especificas para salvar e aqui colocamos no subform correto)
        if((obj.specific_dates !== undefined) && (obj.specific_dates !== '')){
            // Pecorre opcoes e preenche corretamente no subform
            jQuery.each(obj.specific_dates, function(index, value){
                // Adiciona nova linha no subform de horas
                subformItem.find('input[name$="\\[specific-dates-hours\\]"]').parent().find('a.group-add, .group-add').first().click();

                // Adiciona a data no campo do ultimo subform exibido
                subformItem.find('[data-base-name="specific-dates-hours"]').last().find('input[name$="\\[date\\]"]').val(value).attr('data-alt-value', value).attr('data-local-value', value);

                // Adiciona hora inicial no campo do ultimo subform exibido
                if ((obj.hours[index].initial !== undefined) && (obj.hours[index].initial != '')){
                    subformItem.find('[data-base-name="specific-dates-hours"]').last().find('input[name$="\\[initial_time\\]"]').val(obj.hours[index].initial);
                }

                // Adiciona hora final no campo do ultimo subform exibido
                if ((obj.hours[index].final !== undefined) && (obj.hours[index].final != '')){
                    subformItem.find('[data-base-name="specific-dates-hours"]').last().find('input[name$="\\[final_time\\]"]').val(obj.hours[index].final);
                }
            });
        }
    }
    // Demais tipos de eventos
    else{
        // Adiciona nova linha no subform de horas para ficar aparecendo para preenchimento
        subformItem.find('input[name$="\\[hours\\]"]').parent().find('a.group-add, .group-add').first().click();
        
        // Horarios do evento: insere em subform normal
        if((obj.hours !== undefined) && (obj.hours !== '')){
            // Pecorre opcoes e preenche corretamente no subform
            jQuery.each(obj.hours, function(index, value){
                // Somente a partir do segundo item devemos dar trigger para exibir nova linha no subform de horas (primeira linha ja vem exibida)
                if(index > 0){
                    // Adiciona nova linha no subform de horas
                    subformItem.find('input[name$="\\[hours\\]"]').parent().find('a.group-add, .group-add').first().click();
                }

                // Adiciona hora inicial no campo do ultimo subform exibido
                subformItem.find('[data-base-name="hours"]').last().find('input[name$="\\[initial_time\\]"]').val(value.initial);

                // Adiciona hora final no campo do ultimo subform exibido
                subformItem.find('[data-base-name="hours"]').last().find('input[name$="\\[final_time\\]"]').val(value.final);
            });
        }

        // Campo de exibir um evento para cada horario preenchido
        var oneEventSchedule = subformItem.find('input[name$="\\[one_event_schedule\\]"][value="' + obj.one_event_schedule + '"]');
        oneEventSchedule.siblings('label[for="' + oneEventSchedule.attr('id') + '"]').click();
        
    }

    // Dias a ignorar na recorrencia
    if((obj.recurrent_days_ignore !== undefined) && (obj.recurrent_days_ignore !== '')){
        // Pecorre opcoes e preenche corretamente no subform
        jQuery.each(obj.recurrent_days_ignore, function(index, value){
            // Adiciona data corrente no campo input text
            subformItem.find('select[name*="[recurrent_days_ignore]"]').parent().find('input[type="text"]').focus().val(value);
            // Joomla 3
            if(majorVersionJoomla !== undefined && majorVersionJoomla == '3'){
                // Dispara evento de 'enter' no campo input text usando jquery
                subformItem.find('select[name*="[recurrent_days_ignore]"]').parent().find('input[type="text"]').trigger(keyboardEventEnter);
            }
            // Joomla 4
            else{
                // Dispara evento de 'enter' no campo input text usando javascript puro
                subformItem[0].querySelectorAll('select[name*="[recurrent_days_ignore]')[0].parentElement.querySelectorAll('input[type="text"]')[0].dispatchEvent(keyboardEventEnter);
            }
            
        });
    }
    
    // Data inicial
    subformItem.find('input[name$="\\[initial_date\\]"]').first().val(obj.initial_date).attr('data-alt-value', obj.initial_date).attr('data-local-value', obj.initial_date);

    // Data final
    subformItem.find('input[name$="\\[final_date\\]"]').first().val(obj.final_date).attr('data-alt-value', obj.final_date).attr('data-local-value', obj.final_date);

    // Titulo
    // Altera '##' para aspas simples (eh convertido pra '##' na hora de salvar para ficar compatível)
    //FIXME:johnny: fazer replaceall
    obj.event_title    = obj.event_title.replace(/##/g, "'");
    subformItem.find('textarea[name$="\\[event_title\\]"]').first().val(obj.event_title);

    // Texto de apoio
    if (typeof obj.event_subtitle != "undefined") {
        //FIXME:johnny: fazer replaceall
        obj.event_subtitle = obj.event_subtitle.replace(/##/g, "'");
        subformItem.find('textarea[name$="\\[event_subtitle\\]"]').first().val(obj.event_subtitle);
    }

    // Local
    if (typeof obj.event_place != "undefined") {
        //FIXME:johnny: fazer replaceall
        obj.event_place    = obj.event_place.replace(/##/g, "'");
        subformItem.find('textarea[name$="\\[event_place\\]"]').first().val(obj.event_place);
    }  

    // Link do local
    if ((typeof obj.event_place_link != "undefined") && (obj.event_place_link != '')) {
        subformItem.find('select[name$="\\[event_place_link\\]"]').first().val(obj.event_place_link);
        subformItem.find('select[name$=\\[event_place_link\\]] option').removeAttr('selected');
        subformItem.find('select[name$=\\[event_place_link\\]] option[value='+obj.event_place_link+']').attr('selected','selected');

        // Joomla 3
        if(majorVersionJoomla !== undefined && majorVersionJoomla == '3'){
            // Trigger chosen
            subformItem.find('select[name$="\\[event_place_link\\]"]').trigger('liszt:updated');
            subformItem.find('select[name$="\\[event_place_link\\]"]').trigger('change');
        }
        // Joomla 4
        else{
            subformItem.find('select[name$="\\[event_place_link\\]"]').trigger('change').trigger('click');
        }
    }

    // Url manual do local
    if (typeof obj.event_place_link_href != "undefined") {
        subformItem.find('input[name$="\\[event_place_link_href\\]"]').first().val(obj.event_place_link_href);
    }
    
    // Categoria
    if ((typeof obj.event_category != "undefined") && (obj.event_category != '')) {
        subformItem.find('select[name$="\\[event_category\\]"]').first().val(obj.event_category);

            subformItem.find('select[name$=\\[event_category\\]] option').removeAttr('selected');
        subformItem.find('select[name$=\\[event_category\\]] option[value='+obj.event_category+']').attr('selected','selected');

        // Joomla 3
        if(majorVersionJoomla !== undefined && majorVersionJoomla == '3'){
            // Trigger chosen
            subformItem.find('select[name$="\\[event_category\\]"]').trigger('liszt:updated');
            subformItem.find('select[name$="\\[event_category\\]"]').trigger('change');
        }
        // Joomla 4
        else{
            subformItem.find('select[name$="\\[event_category\\]"]').trigger('change').trigger('click');
        }
    }

    // Cor de fundo manual
    if (typeof obj.event_manual_color != "undefined") {
        subformItem.find('input[name$="\\[event_manual_color\\]"]').first().minicolors('value', obj.event_manual_color);
    }
    
    // Sobreescrita da cor dos textos
    if (typeof obj.event_text_color != "undefined") {
        subformItem.find('input[name$="\\[event_text_color\\]"]').first().minicolors('value', obj.event_text_color);
    }

    // Opcao de link (select)
    if ((typeof obj.link_option != "undefined") && (obj.link_option != '')) {
        subformItem.find('select[name$="\\[link_option\\]"]').first().val(obj.link_option);

            subformItem.find('select[name$=\\[link_option\\]] option').removeAttr('selected');
        subformItem.find('select[name$=\\[link_option\\]] option[value='+obj.link_option+']').attr('selected','selected');

        // Joomla 3
        if(majorVersionJoomla !== undefined && majorVersionJoomla == '3'){
            // Trigger chosen
            subformItem.find('select[name$="\\[link_option\\]"]').trigger('liszt:updated');
            subformItem.find('select[name$="\\[link_option\\]"]').trigger('change');
        }
        // Joomla 4
        else{
            subformItem.find('select[name$="\\[link_option\\]"]').trigger('change').trigger('click');
        }
    }

    // Opcoes de modal do conteudo (select)
    if ((typeof obj.modal_option != "undefined") && (obj.modal_option != '')) {
        subformItem.find('select[name$="\\[modal_option\\]"]').first().val(obj.modal_option);

            subformItem.find('select[name$=\\[modal_option\\]] option').removeAttr('selected');
        subformItem.find('select[name$=\\[modal_option\\]] option[value='+obj.modal_option+']').attr('selected','selected');

        // Joomla 3
        if(majorVersionJoomla !== undefined && majorVersionJoomla == '3'){
            // Trigger chosen
            subformItem.find('select[name$="\\[modal_option\\]"]').trigger('liszt:updated');
            subformItem.find('select[name$="\\[modal_option\\]"]').trigger('change');
        }
        // Joomla 4
        else{
            subformItem.find('select[name$="\\[modal_option\\]"]').trigger('change').trigger('click');
        }
    }

    // Modal de conteudo com artigo
    if (typeof obj.modal_article != "undefined") {
        subformItem.find('input[name$="\\[modal_article\\]"]').first().val(obj.modal_article);
    }

    // Modal de conteudo com modulo
    if ((typeof obj.modal_module != "undefined") && (obj.modal_module != '')) {
        subformItem.find('select[name$="\\[modal_module\\]"]').first().val(obj.modal_module);

        subformItem.find('select[name$=\\[modal_module\\]] option').removeAttr('selected');
        subformItem.find('select[name$=\\[modal_module\\]] option[value='+obj.modal_module+']').attr('selected','selected');
    
        // Joomla 3
        if(majorVersionJoomla !== undefined && majorVersionJoomla == '3'){
            // Trigger chosen
            subformItem.find('select[name$="\\[modal_module\\]"]').trigger('liszt:updated');
            subformItem.find('select[name$="\\[modal_module\\]"]').trigger('change');
        }
        // Joomla 4
        else{
            subformItem.find('select[name$="\\[modal_module\\]"]').trigger('change').trigger('click');
        }
    }

    // Url externa
    if (typeof obj.link_external != "undefined") {
        subformItem.find('input[name$="\\[link_external\\]"]').first().val(obj.link_external);
    }

    // Modal de link interno (menu)
    if (typeof obj.link_internal != "undefined") {
        subformItem.find('input[name$="\\[link_internal\\]"]').first().val(obj.link_internal);
    }

    // Title para link
    if (typeof obj.link_title != "undefined") {
        subformItem.find('textarea[name$="\\[link_title\\]"]').first().val(obj.link_title);
    }
       
    // Abrir link em nova guia (radio sim/nao)
    if (typeof obj.link_target != "undefined") {
        var linkTarget = subformItem.find('input[name$="\\[link_target\\]"][value="' + obj.link_target + '"]');
        linkTarget.siblings('label[for="' + linkTarget.attr('id') + '"]').click();
    }

    // Publicado (select)
    if ((typeof obj.published != "undefined") && (obj.published != '')) {
        subformItem.find('select[name$="\\[published\\]"]').first().val(obj.published);

            subformItem.find('select[name$=\\[published\\]] option').removeAttr('selected');
        subformItem.find('select[name$=\\[published\\]] option[value='+obj.published+']').attr('selected','selected');

        // Joomla 3
        if(majorVersionJoomla !== undefined && majorVersionJoomla == '3'){
            // Trigger chosen
            subformItem.find('select[name$="\\[published\\]"]').trigger('liszt:updated');
            subformItem.find('select[name$="\\[published\\]"]').trigger('change');
        }
        // Joomla 4
        else{
            subformItem.find('select[name$="\\[published\\]"]').trigger('change').trigger('click');
        }
    }

    // ID do evento
    if (typeof obj.id_event != "undefined") {
        subformItem.find('input[name$="\\[id_event\\]"]').first().val(obj.id_event);
    }
};

/**
 * Obtem dados de um item do subform e retorna em objeto organizado p/ salvar ou clonar
 */
nobossCalendarSubform.subformToObject = function (element) {
    // monta objeto com os valores setados no subform
    var obj = {};

    // evento eh recorrente (campo radio sim/nao)
    var isRecurrent = element.find('input[name$="\\[is_recurrent\\]"]:checked').val();

    // Campo de tipo de recorrencia
    var recurrenceType = element.find('select[name$="\\[recurrence_type\\]"]').first().val();

    // Objeto com itens do dia da semana
    var recurrentDays = {};
    // Percorre cada dia da semana para ver quais estao marcados
    element.find('input[name$="\\[recurrent_days][]"]').each(function() {
        // Item selecionado: adiciona no array com valor 1
        if ($(this).is(':checked')) {
            recurrentDays[$(this).attr('data-recurrent-day')] = 1;
        }
        // Item nao selecionado: adiciona no array com valor 0
        else{
            recurrentDays[$(this).attr('data-recurrent-day')] = 0;
        }
    });  

    // Array com datas especificas da recorrencia
    var specificDates = [];

    // Objeto que armazenara os horarios
    var hours = [];

    // Evento do tipo recorrente por data especifica (sem horas)
    if(recurrenceType == 'specific-dates'){
        // Percorre os options de datas especificas para adicionar em array/
        element.find('select[name*="[specific_dates]"] option:selected').each(function() {
            specificDates.push($(this).val())
        });
    }

    // Evento recorrente de dadas especificas com horas
    if(recurrenceType == 'specific-dates-hours'){
    
        // Percorre cada linha do subform de datas especificas com horas
        element.find('[data-base-name="specific-dates-hours"]').each(function() {
            // Hora inicial
            var initialTime = jQuery(this).find('input[name$="\\[initial_time\\]"]').val();
            
            // Hora inicial esta em branco: pula item sem armazenar
            if (initialTime == ''){
                return;
            }
            
            // Armazena horarios em objeto
            var hour = {};
            hour.initial = initialTime;
            hour.final = jQuery(this).find('input[name$="\\[final_time\\]"]').val();
            hours.push(hour);

            // Adiciona data no array de datas especificas
            specificDates.push(jQuery(this).find('input[name$="\\[date\\]"]').val())
        });
    }
    // Demais tipos de eventos (possuem campo de horas normais)
    else{
        // Percorre cada linha do subform de horas
        element.find('[data-base-name="hours"]').each(function() {
            // Hora inicial
            var initialTime = jQuery(this).find('input[name$="\\[initial_time\\]"]').val();
            
            // Hora inicial esta em branco: pula item sem armazenar
            if (initialTime == ''){
                return;
            }
            
            // Armazena horarios em objeto
            var hour = {};
            hour.initial = initialTime;
            hour.final = jQuery(this).find('input[name$="\\[final_time\\]"]').val();
            hours.push(hour);
        });

        // Campo que define se deve ser exibido um evento por horario
        var oneEventSchedule = element.find('input[name$="\\[one_event_schedule\\]"]:checked').val();
    }

    // Converte array de datas especificas para objeto
    specificDates = Object.values(specificDates);

    // Converte os horarios para um json
    hours = JSON.stringify(hours);

    // Array com dias a ignorar na recorrencia
    var recurrentDaysIgnore = [];
    // Percorre os options informados para adicionar em array
    element.find('select[name*="[recurrent_days_ignore]"] option:selected').each(function() {
        recurrentDaysIgnore.push($(this).val())
    });
    if(recurrentDaysIgnore.length > 0){
        // Converte para objeto
        obj.recurrent_days_ignore = Object.values(recurrentDaysIgnore);
    }
    else{
        obj.recurrent_days_ignore = '';
    }

    // Campo para selecionar tipo de conteudo da modal
    var modalOption = element.find('select[name$="\\[modal_option\\]"]').first().val();
    // Campo de modal de artigo
    var modalArticle = element.find('input[name$="\\[modal_article\\]"]').first().val();
    // Campo de modal de modulo
    var modalModule = element.find('select[name$="\\[modal_module\\]"]').first().val();
    // data inicial
    var initialDate = element.find('input[name$="\\[initial_date\\]"]').first().val();
    // data final
    var finalDate = element.find('input[name$="\\[final_date\\]"]').first().val();
    // titulo
    var title = element.find('textarea[name$="\\[event_title\\]"]').first().val();
    // texto de apoio
    var subtitle = element.find('textarea[name$="\\[event_subtitle\\]"]').first().val();
    // categoria
    var category = element.find('select[name$="\\[event_category\\]"]').first().val();
    // cor de fundo manual
    var eventColor = element.find('input[name$="\\[event_manual_color\\]"]').first().minicolors('value');
    // local
    var place = element.find('textarea[name$="\\[event_place\\]"]').first().val();
    // link do local
    var placeLink = element.find('select[name$="\\[event_place_link\\]"]').first().val();
    // url manual do local
    var placeUrlManual = element.find('input[name$="\\[event_place_link_href\\]"]').first().val();
    // cor dos textos manual
    var textColor = element.find('input[name$="\\[event_text_color\\]"]').first().val();
    // opcao de link
    var linkOption = element.find('select[name$="\\[link_option\\]"]').first().val();
    // url externa
    var externalUrl = element.find('input[name$="\\[link_external\\]"]').first().val();
    // link interno
    var internalLink = element.find('input[name$="\\[link_internal\\]"]').first().val();
    // title html
    var linkTitle = element.find('textarea[name$="\\[link_title\\]"]').first().val();
    // id evento
    var idEvent = element.find('input[name$="\\[id_event\\]"]').first().val();
    // abrir em nova guia
    var isTargetLink = element.find('input[name$="\\[link_target\\]"]:checked').val();
    // Status
    var published = element.find('select[name$="\\[published\\]"]').first().val();


    // OBS: foram colocadas verificacoes abaixo para armazenar apenas os campos que realmente sao necessarios (ex: se usuario nao habilitou evento recorrente, nao ira salvar campos sobre evento recorrente). Isso eh para ocupar menos espaco nos dados salvos

    obj.is_recurrent = isRecurrent;

    obj.specific_dates = '';

    // Evento recorrente
    if (obj.is_recurrent == 1){
        obj.recurrence_type = recurrenceType;
        // Recorrencia por datas especificas
        if((obj.recurrence_type == 'specific-dates') || (obj.recurrence_type == 'specific-dates-hours')){
            obj.specific_dates = specificDates;
        }
        // Recorrencia por dia da semana
        else if (obj.recurrence_type == 'week-days'){
            obj.recurrent_days = recurrentDays;
        }
    }

    // Json com array de objeto dos horarios
    obj.hours = hours.replace(/"/g, '\\"');

    obj.one_event_schedule = oneEventSchedule;

    obj.initial_date = initialDate;
    obj.final_date = finalDate;

    obj.link_option = linkOption;
    
    // Evento possui modal de conteudo
    if (obj.link_option == 'modal'){
        obj.modal_option = modalOption;
        // Modal de conteudo do tipo artigo
        if (obj.modal_option == 'article'){
            obj.modal_article = modalArticle;
        }
        // Modal de conteudo do tipo modulo
        else if (obj.modal_option == 'module'){
            obj.modal_module = modalModule;
        }
    }
    // Evento possui link para pagina interna
    else if (obj.link_option == 'internal'){
        obj.link_internal = internalLink;
        obj.link_title = linkTitle;
        obj.link_target = isTargetLink;
    }
    // Evento possui link para pagina interna
    else if (obj.link_option == 'external'){
        obj.link_external = externalUrl;
        obj.link_title = linkTitle;
        obj.link_target = isTargetLink;
    }
    
    obj.event_title = title.replace(/'/g, "##");
    obj.event_title = title.replace(/"/g, "##");

    // Texto de apoio do evento definido
    if (subtitle != ''){
        obj.event_subtitle = subtitle.replace(/'/g, "##");
        obj.event_subtitle = subtitle.replace(/"/g, "##");
    }

    // Local do evento definido
    if (place != ''){
        obj.event_place = place.replace(/'/g, "##");
        obj.event_place = place.replace(/"/g, "##");
        
        // Definido link para local
        if (placeLink != 'none'){
            obj.event_place_link = placeLink;

            // Link manual definido
            if((placeLink == 'manual') && (placeUrlManual != '')){
                obj.event_place_link_href = placeUrlManual;
            }
        }
    }

    obj.event_category = category;

    // Evento sem categoria: define a cor manualmente
    if (obj.event_category == 'none' || obj.event_category == ''){
        obj.event_manual_color = eventColor;
    }

    // Sobreescrita da cor dos textos
    if ((textColor != undefined) && (textColor != '')){
        obj.event_text_color = textColor;
    }
    
    obj.published = published;

    // Data de fim de publicacao foi definido
    if (idEvent != ''){
        obj.id_event = idEvent;
    }

    // retorna objeto completo
    return obj;
};

/**
 *  Atualiza o titulo do collapse
 * 
 *  OBS: essa funcao eh executada a partir do arquivo nobosssubform.js
 */
var nobossSubformCustom = {};
nobossSubformCustom.updateCollapseTitle = function(parentGroup){
    // pega o titulo do evento
    var collapseValueTitle = jQuery(parentGroup).find('textarea[name$="\\[event_title\\]"]').val();

    var returnCollapse = '';

    if(collapseValueTitle !== undefined){
        //pega o valor default para quando esta vazio
        if(collapseValueTitle.trim().length === 0){
            returnCollapse = jQuery('[data-collapse-default-value]').data('collapse-default-value');
        }else{
            // Define titulo do evento
            returnCollapse = collapseValueTitle+' | ';
            
            // Obtem informacao se eh evento recorrente
            var isRecurrence = jQuery(parentGroup).find('input[name$="\\[is_recurrent\\]"]:checked').val();

            // Evento recorrente: coloca no titulo
            if(isRecurrence == '1'){
                // Adiciona informacao que eh evento recorrente no label do subform
                returnCollapse += Joomla.JText._("MOD_NOBOSSCALENDAR_SUBFORM_COLLAPSE_TITLE_RECURRENT_INFO");
                
                // Obtem tipo de recorrencia que eh (no caso de evento recorrente)
                var recurrenceType = jQuery(parentGroup).find('select[name$="\\[recurrence_type\\]"]').val();

                // Adiciona o tipo de recorrencia
                switch (recurrenceType) {
                    case 'week-days':
                        returnCollapse += ' ('+Joomla.JText._("MOD_NOBOSSCALENDAR_EVENT_RECURRENCE_TYPE_OPT_WEEK_DAYS").toLowerCase()+')';
                        break;
                
                    case 'specific-dates':
                        returnCollapse += ' ('+Joomla.JText._("MOD_NOBOSSCALENDAR_EVENT_RECURRENCE_TYPE_OPT_SPECIFIC_DATES").toLowerCase()+')';
                        break;

                    case 'specific-dates-hours':
                        returnCollapse += ' ('+Joomla.JText._("MOD_NOBOSSCALENDAR_EVENT_RECURRENCE_TYPE_OPT_SPECIFIC_DATES_HOURS").toLowerCase()+')';
                        break;
                }
            }

            // Evento com data normal
            else{
                // Obtem a data inicial
                var collapseValueInitialDate =  jQuery(parentGroup).find('input[name$="\\[initial_date\\]"]').val();

                // Obtem a data final
                var collapseValueFinalDate =  jQuery(parentGroup).find('input[name$="\\[final_date\\]"]').val();

                // Data inicial definida
                if(collapseValueInitialDate.trim().length != 0){
                    // Acesso eh via navegador Safari em um dispositivo da Apple (para o safari precisa estar no formato mm/dd/aaaa hh:mm ao inves de aaaa-mm-dd hh:mm)
                    if (navigator.userAgent.match(/(iPhone|iPod|iPad|Mac)/) != null) {
                        var dateParts = collapseValueInitialDate.substring(0,10).split('-');        
                        var timePart = collapseValueInitialDate.substring(11);
                        // converte para objeto data (acrescentado a hora 15:59 no final pq sem ela estava reduzindo um dia na conversao da data)
                        dateInitial = new Date(dateParts[1] + '/' + dateParts[2] + '/' + dateParts[0] + timePart);
                    } else {
                        // converte para objeto data (acrescentado a hora 15:59 no final pq sem ela estava reduzindo um dia na conversao da data)
                        var dateInitial = new Date(collapseValueInitialDate + ' 15:59');
                    } 
                    
                    returnCollapse += dateInitial.toLocaleDateString();
                }

                // Data final definida e diferente de data inicial
                if((collapseValueFinalDate.trim().length != 0) && (collapseValueFinalDate != collapseValueInitialDate)){
                    // Acesso eh via navegador Safari em um dispositivo da Apple (para o safari precisa estar no formato mm/dd/aaaa hh:mm ao inves de aaaa-mm-dd hh:mm)
                    if (navigator.userAgent.match(/(iPhone|iPod|iPad|Mac)/) != null) {
                        var dateParts = collapseValueFinalDate.substring(0,10).split('-');        
                        var timePart = collapseValueFinalDate.substring(11);
                        // converte para objeto data (acrescentado a hora 15:59 no final pq sem ela estava reduzindo um dia na conversao da data)
                        dateFinal = new Date(dateParts[1] + '/' + dateParts[2] + '/' + dateParts[0] + timePart);
                    } else {
                        // converte para objeto data (acrescentado a hora 15:59 no final pq sem ela estava reduzindo um dia na conversao da data)
                        var dateFinal = new Date(collapseValueFinalDate + ' 15:59');
                    } 

                    returnCollapse += ' - ' + dateFinal.toLocaleDateString();
                }
            }
        }
    }

    //modifica o titulo do collapse adicionando titulo da label e o respectivo valor
    jQuery(parentGroup).find('.noboss-collapse__title').text(returnCollapse);
};

/**
 *  Altera required's dos campos de datas conforme opcao de recorrencia escolhida
 */
nobossCalendarSubform.changeRequiredDateFields = function(element){
    // Evento ativado na troca de 'tipo de recorrencia'
    element.on('change', 'select[name$="\\[recurrence_type\\]"]', function () {
       // Datas especificas
        if (jQuery(this).val() == 'specific-dates'){
            // Remove required do campo de data inicial (nao eh usado o campo nestes casos)
            element.find('input[name$="\\[initial_date\\]"]').removeAttr("required").removeClass('required');
            // Adciona required no campo de datas a especificar
            element.find('select[name*="[specific_dates]"]').attr("required", "true").addClass('required').closest('joomla-field-fancy-select').attr("required", "true").addClass('required');
            // Remove registros do subform de datas e horas
            element.find('[data-base-name="specific-dates-hours"]').remove();
        }
        // Datas e horas especificas
        else if (jQuery(this).val() == 'specific-dates-hours'){
            // Remove required do campo de data inicial (nao eh usado o campo nestes casos)
            element.find('input[name$="\\[initial_date\\]"]').removeAttr("required").removeClass('required');
            // Remove required no campo de datas a especificar
            element.find('select[name*="[specific_dates]"]').removeAttr("required").removeClass('required').closest('joomla-field-fancy-select').removeAttr("required").removeClass('required');
            // Joomla 3
            // if(majorVersionJoomla !== undefined && majorVersionJoomla == '3'){
            //     // Deixa um item do subform sendo exibido para iniciar preenchimento
            //     element.find('input[name$="\\[specific-dates-hours\\]"]').parent().find('a.group-add, .group-add').first().click();
            // }
        }
        // Demais recorrencias
        else{
            // Garante que o campo de data inicial esteja com required   
            element.find('input[name$="\\[initial_date\\]"]').attr("required", "true").addClass('required');
            // Remove required no campo de datas a especificar
            element.find('select[name*="[specific_dates]"]').removeAttr("required").removeClass('required').closest('joomla-field-fancy-select').removeAttr("required").removeClass('required');
            // Remove registros do subform de datas e horas
            element.find('[data-base-name="specific-dates-hours"]').remove();
        }
    });
    // Executa trigger no campo de 'tipo de recorrencia' para que execute a funcao acima em todos casos (mesmo qnd nao for evento recorrente)
    if(majorVersionJoomla !== undefined && majorVersionJoomla == '3'){
        // Trigger chosen
        element.find('select[name$="\\[recurrence_type\\]"]').trigger('liszt:updated');
        element.find('select[name$="\\[recurrence_type\\]"]').trigger('change');
    }
    // Joomla 4
    else{
        element.find('select[name$="\\[recurrence_type\\]"]').trigger('change').trigger('click');
    }
}

/**
 * Funcao que realiza o clone de um evento conforme solicitacao feita pelo usuario
 */
nobossCalendarSubform.cloneEvent = function(btClicked){
    // Obtem o subform
    var subform = jQuery('[data-id="items-filter"]').siblings('[data-subform-collapse-wrapper]').first();

    // Adiciona novo item no subform
    nobosssubform.addSubform(subform);

    // Novo item adicionado no subform
    var newEventSubform = subform.find('[data-new="true"][data-base-name="events"], [data-new="1"][data-base-name="events"]').last();

    // Cria um objeto com os dados do item do subform passado como parametro (item copiado)
    var objEventCopy = nobossCalendarSubform.subformToObject(btClicked.closest('.subform-repeatable-group'));

    // Sera o id do evento antes de inserir no novo item do subform
    objEventCopy.id_event = 0;

    // insere os valores desse objeto nos campos do item de subform recem criado
    nobossCalendarSubform.objectToSubform(objEventCopy, newEventSubform);
};

/**
 * Funcao que abre uma modal para usuario informar uma data limite e limpar eventos antigos
 */
nobosssubform.cleanOldEvents = function(){
    $.confirm({
        title: Joomla.JText._("MOD_NOBOSSCALENDAR_CLEAN_OLD_EVENTS_MODAL_TITLE"),
        content: '' +
        '<form action="" class="formName">' +
            '<div class="form-group">' +
                '<label>'+Joomla.JText._("MOD_NOBOSSCALENDAR_CLEAN_OLD_EVENTS_MODAL_TEXT") + '<br /><br />' + Joomla.JText._("MOD_NOBOSSCALENDAR_CLEAN_OLD_EVENTS_MODAL_REQUIRED")+'</label><br />' +
                '<input type="text" name="cleanevents" value="" maxlength="10" placeholder="AAAA-MM-DD" style="min-width: 85px; max-width: 135px;" class="form-control" required>' + 
            '</div>' +
        '</form>',
        buttons: {
            formSubmit: {
                text: Joomla.JText._("MOD_NOBOSSCALENDAR_CLEAN_OLD_EVENTS_MODAL_BUTTON_SUBMIT"),
                btnClass: 'btn-blue',
                action: function () {
                    // Pega o valor da data limite
                    var dateLimit = this.$content.find('[name="cleanevents"]').val();
                    // Data limite nao informado
                    if(!dateLimit){
                        $.alert(Joomla.JText._("MOD_NOBOSSCALENDAR_CLEAN_OLD_EVENTS_MODAL_REQUIRED"));
                        return false;
                    }

                    // Monta a url de requisição
                    var request = {
                        'option': 'com_nobossajax',
                        'module': 'nobosscalendar',
                        'method': 'removeOldEvents',
                        'format': 'raw'
                    };

                    // Monta os dados a serem enviados
                    var data = {
                        'dateLimit': dateLimit,
                        'id_calendar_original': jQuery('input[name$="\\[id_calendar\\]"]').attr('id_calendar_original')
                    };

                    // Executa requisicao ajax
                    jQuery.ajax({
                        url: baseNameUrl+ "administrator/index.php?" + jQuery.param(request),
                        type: "POST",
                        dataType: 'JSON',
                        async: false,
                        data: data
                    });

                    // Exibe mensagem de sucesso
                    $.alert(Joomla.JText._("MOD_NOBOSSCALENDAR_CLEAN_OLD_EVENTS_MODAL_SUCCESS"));
                            
                    // Executa trigger no filtro do mes para trazer resultados
                    jQuery('[data-id="items-filter"]').find('[data-id="month-filter"]').trigger('change');
                }
            },
            cancel: function () {
                //close
            },
        },
        onContentReady: function () {
            // bind to events
            var jc = this;
            this.$content.find('form').on('submit', function (e) {
                // if the user submits the form by pressing enter in the field.
                e.preventDefault();
                jc.$$formSubmit.trigger('click'); // reference the button and click it
            });
        }
    });

    setTimeout(function () {
        // Aplica markara no campo
        jQuery('[name="cleanevents"]').mask("TCE9-M9-D9", {
            placeholder: "____-__-__",
            'translation': {                  
                D: {pattern: /[0-3]/}, // permite entre 0 e 3
                M: {pattern: /[01]/}, // permite 0 ou 1
                T: {pattern: /[2]/}, // permite somente 2
                C: {pattern: /[0]/},
                E: {pattern: /[2-9]/}, // permite entre 2 e 9
            }
        });
    }, 200);
};

/**
 * Funcao que altera o id calendar dos eventos e categorias existentes no banco
 */
nobossCalendarSubform.updateIdCalendarDataBase = function(idCalendar, idCalendarOriginal){
    // Monta a url de requisição
    var request = {
        'option': 'com_nobossajax',
        'module': 'nobosscalendar',
        'method': 'updateIdCalendar',
        'format': 'raw',
        'lang': sefLanguage
    };
    
    // Monta os dados a serem enviados
    var data = {
        'id_calendar': idCalendar,
        'id_calendar_original': idCalendarOriginal
    };

    // Executa requisicao ajax
    jQuery.ajax({
        url: baseNameUrl+ "administrator/index.php?" + jQuery.param(request),
        type: "POST",
        dataType: 'JSON',
        data: data
    }).done(function (result) {
        // Se nao estiver definido, nao faz nada.
        if((result == null) || (result == '')){
        } 
        // Ocorreu um erro
        else if (result.success == 0){
            // Exibe um alerta avisando que teve erro
            jQuery.alert({
                title: 'Error',
                content: result.error,
                type: 'red',
                buttons: {
                    ok: {
                        keys: ['enter']
                    }
                }
            });
            return false;
        }
    });
    
};

/**
 * Funcao que gera um cookie
 */
nobosssubform.setCookie = function(cname, cvalue, exdays){
    var d = new Date();
    d.setTime(d.getTime() + (exdays*24*60*60*1000));
    var expires = "expires="+ d.toUTCString();
    document.cookie = cname + "=" + cvalue + ";" + expires + ";";
};
