<?php
/**
 * @package			No Boss Extensions
 * @subpackage  	No Boss Calendar
 * @author			No Boss Technology <contact@nobosstechnology.com>
 * @copyright		Copyright (C) 2020 No Boss Technology. All rights reserved.
 * @license			GNU Lesser General Public License version 3 or later; see <https://www.gnu.org/licenses/lgpl-3.0.en.html>
 */

defined("JPATH_PLATFORM") or die;

jimport('joomla.form.helper');

class JFormFieldNobossapiimportermanual extends JFormField
{

    protected $type = "nobossapiimportermanual";

	protected function getInput(){
        $html = '';
        
        $doc = JFactory::getDocument();
        $doc->addScript(JURI::root()."modules/mod_nobosscalendar/fields/assets/js/min/nobossapiimportermanual.min.js");
        $doc->addStylesheet(JURI::root()."modules/mod_nobosscalendar/fields/assets/stylesheets/css/nobossapiimportermanual.min.css");
        
        // Obtem o alias da api que deseja requisicao
        $api = $this->element->attributes()->api;
        
        $displayLastDate = false;
        
        // Ja houve importacao manual antes: obtem a data
        if(!empty($this->value)){
            // Pega a data no formato a ser exibido
            $lastDate = JFactory::getDate($this->value)->format('Y-m-d - H:i');
            $displayLastDate = true;
        }
        else{
            $lastDate = NULL;
        }       

        // Declara div mais externa colocando como attr o alias da api requisitada
        $html .= '<div data-api="'.$api.'" class="importer-manual">';

        // Exibe os inputs, botao e mensagem da ultima atualizacao
        $html .= '
        <input type="text" value="" class="form-control" data-importer="dt-initial" class="default" autocomplete="off" placeholder="____/__/__" maxlength="10">
        <span class="importer-separator">-</span>
        <input type="text" value="" class="form-control" data-importer="dt-final" class="default" autocomplete="off" placeholder="____/__/__" maxlength="10">

        <a class="btn btn-nb" data-importer="btn">
            <span>'.JText::_('MOD_NOBOSSCALENDAR_INTEGRATION_IMPORT_MANUAL_BTN').'</span>
        </a>

        <span style="display: none;" data-importer="msg-not-connected" class="importer-manual__msg">
            '.JText::_('MOD_NOBOSSCALENDAR_INTEGRATION_IMPORT_NOT_CONNECTED').'
        </span>

        <span style="display: none;" data-importer="msg-error" class="importer-manual__msg"></span>

        <span style="display: none;" data-importer="msg-success" class="importer-manual__msg">'.JText::_('MOD_NOBOSSCALENDAR_INTEGRATION_IMPORT_SUCCESS').'</span>

        <div style="display:'.(($displayLastDate) ? 'block': 'none').';" class="importer-manual__msg importer-manual__last-date">
            '.JText::_('MOD_NOBOSSCALENDAR_INTEGRATION_IMPORT_LAST_DATE').' 
            <span data-importer="last-date-display">'.$lastDate.'</span>
        </div>

        <input type="hidden" data-importer="last-date-input" name="'.$this->name.'" value="'.$this->value.'">';

        $html .= '</div>';

		return $html;
    }
}
