<?php
/**
 * @package			No Boss Extensions
 * @subpackage  	No Boss Calendar
 * @author			No Boss Technology <contact@nobosstechnology.com>
 * @copyright		Copyright (C) 2020 No Boss Technology. All rights reserved.
 * @license			GNU Lesser General Public License version 3 or later; see <https://www.gnu.org/licenses/lgpl-3.0.en.html>
 */

defined("JPATH_PLATFORM") or die;

jimport('joomla.form.helper');

class JFormFieldNobossapischedule extends JFormField
{

    protected $type = "nobossapischedule";

	protected function getInput(){
        $html = '';
        
        $doc = JFactory::getDocument();
        $doc->addScript(JURI::root()."modules/mod_nobosscalendar/fields/assets/js/min/nobossapischedule.min.js");

        // Obtem o alias da api que deseja requisicao
        $api = $this->element->attributes()->api;
        
        $options = '';

        // Traz itens salvos no banco
        if(!empty($this->value)){
            foreach (json_decode($this->value) as $option) {
                $options .= '<option value="'.$option.'" selected>'.$option.'</option>';
            }
        }

        // Declara div mais externa colocando como attr o alias da api requisitada
        $html .= '<div data-api="'.$api.'">';

        // Select fake que servira para selecionar uma ou mais agendas
        $html .= '<select data-schedule="select" multiple="multiple" class="custom-select">
                    '.$options.'
                  </select>';

        // Input hidden que armazena os itens selecionados em json encode
        $html .= '<input type="hidden" data-schedule="input" name="'.$this->name.'" value="'.htmlspecialchars($this->value).'" />';

        // Deixa uma mensagem escondida sobre erro de qnd api nao estiver conectada
        $html .= '<span style="font-size: 11px; color: red; margin-top: 8px; display: none;" data-schedule="msg-not-connected">
                    '.JText::_('MOD_NOBOSSCALENDAR_INTEGRATION_SCHEDULE_MESSAGE_NOT_CONNECTED').'
                </span>';

        // Deixa uma div para exibicao de mensagens de retorno de erro
        $html .= '<span style="font-size: 11px; color: red; margin-top: 8px; display: none;" data-schedule="msg-error"></span>';

        $html .= '</div>';

		return $html;
    }
}
