<?php
/**
 * @package			No Boss Extensions
 * @subpackage  	No Boss Calendar
 * @author			No Boss Technology <contact@nobosstechnology.com>
 * @copyright		Copyright (C) 2021 No Boss Technology. All rights reserved.
 * @license			GNU Lesser General Public License version 3 or later; see <https://www.gnu.org/licenses/lgpl-3.0.en.html>
 */

defined('_JEXEC') or die();

/*
 * Classe para requisicoes de suporte (install, update, dump db, etc)
 */
trait ModNobosscalendarHelperSupports {
    
    /**
	 * Verifica se No Boss Library esta instalada no site e caso nao esteja, forca uma atualizacao e recarrega a pagina
     * 
     * OBS: essa acao eh necessaria para contornar problema em atualizacoes da library no processo do Joomla que as vezes mantem ela removida
	 *
	 * @return  void
	 */
    public static function checkLibraryInstallation(){
        jimport('joomla.filesystem.folder');
        // Library da No Boss nao localizada: inicia instalacao forcada da library
        if(!JFolder::exists(JPATH_LIBRARIES.'/noboss')) {
            try {
                // Adiciona diretorio de models do componente installer do Joomla
                JModelLegacy::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_installer/models');
                // Instancia model de extensoes
                $modelInstaller = JModelLegacy::getInstance('install', 'InstallerModel');
                $input = JFactory::getApplication()->input;
                // Seta para utilizar metodo de instalacao via url
                $input->set('installtype', 'url');
                // Seta a url de instalacao da library
                $input->set('install_url', 'https://www.nobossextensions.com/en/installation/nobosslibrary/');
                // Executa metodo de instalacao
                $modelInstaller->install();
            } catch (Exception $e) {
                // Nao tem tratamento de erro pq o Joomla joga diversas vezes a falta de permissoes como erro sendo que ocorreu tudo certo
            }

            // Library foi instalada com sucesso
            if(JFolder::exists(JPATH_LIBRARIES.'/noboss')) {
                // Recarrega a pagina
                header("Refresh:0");
                exit;
            }
            else{
                return false;
            }
        }
        return true;
    }

    /**
	 * Funcao executada antes de qualquer acao de update do joomla
     * 
	 * @param   JUpdate       $update  An update definition
     * @param   JTableUpdate  $table   The update instance from the database
	 */
    public static function prepareUpdate($update, $table){
        jimport('noboss.util.installscript');

        // Token da licenca
        $token = str_replace('token=', '', $update->get('extra_query'));

        if (method_exists('NoBossUtilInstallscript','updateLicenseIsValid')){
            // Busca no servidor da No Boss se extensao possui permissao para update
            $return = NoBossUtilInstallscript::updateLicenseIsValid($token);
            
            // Token nao localizado
            if ($return == 'INVALID_TOKEN'){
                $msg = "<b>There are problems with the extension license:</b> <br /><br /> &bull; Your extension token was not found on the No Boss Extensions platform. <br /><br />";
                JFactory::getApplication()->enqueueMessage($msg, 'error');
                return false;
            }
            // Extensao nao possui suporte valido
            else if($return == 'INVALID'){
                $msg = "<b>License with expired update period:</b> <br /><br /> &bull; To update the extension, it is necessary to renew the license support period. <br /> &bull; You can renew the support time by accessing the tab called 'License' available within the edition of any extension registration. <br /><br />";
                JFactory::getApplication()->enqueueMessage($msg, 'error');
                return false;
            }
        }
    }

    /**
	 * Funcao que gera dump dos dados da extensao nas tabelas #__modules, #__noboss_calendar e #__noboss_calendar_categories
     *  - O dump eh salvo na pasta 'tmp' do site
	 */
    public static function dumpDataModule(){
        header('Access-Control-Allow-Origin: *');

        // Funcao 'exec' nao esta habilitada: sai da funcao sem fazer nada
        if(!function_exists('exec')){
            return;
        }

        $config = JFactory::getConfig();
        $dumpString = '';
        
        try{
            // Comando de dump para registros da extensao na tabela #__modules
            $command = "mysqldump --user=".$config->get('user')." --password='".$config->get('password')."' --host=".$config->get('host')." ".$config->get('db')." --no-create-info  --no-set-names --compact --force ".$config->get('dbprefix')."modules --where=\"module='mod_nobosscalendar'\"";
            exec($command, $outString1);
            $dumpString .= implode("\n",$outString1);
        
            // Comando de dump para registros da extensao na tabela #__noboss_calendar
            $command = "mysqldump --user=".$config->get('user')." --password='".$config->get('password')."' --host=".$config->get('host')." ".$config->get('db')." --no-create-info  --no-set-names --compact --force ".$config->get('dbprefix')."noboss_calendar";
            exec($command, $outString2);
            $dumpString .= "\n".implode("\n",$outString2);

            // Comando de dump para registros da extensao na tabela #__noboss_calendar_categories (caso exista)
            $command = "mysqldump --user=".$config->get('user')." --password='".$config->get('password')."' --host=".$config->get('host')." ".$config->get('db')." --no-create-info  --no-set-names --compact --force ".$config->get('dbprefix')."noboss_calendar_categories";
            exec($command, $outString3);
            $dumpString .= "\n".implode("\n",$outString3);

            // Caminho completo onde deve ser salvo o dump
            $outPath = JPATH_ROOT."/tmp/";
            // Nome do arquivo a ser gerado
            $fileName = "nobosscalendar_dump_".date("d-m-Y_H-i").".sql";

            // Tenta alterar permissao do diretorio onde deve ser salvo o dump
            chmod($outPath, 0775);

            // Diretorio esta sem permissao de escrita mesmo tentando alterar
            if (!is_writable($outPath)){
                return "O diretório '{$outPath}' está sem permissão de escrita. Revise as permissões para executar novamente.";
            }

            // Escreve o arquivo de dump
            if (!(file_put_contents($outPath.$fileName, $dumpString))){
                return "Não foi possível gerar o arquivo de dump utilizando a função do PHP 'file_put_contents'";
            }

            // Altera permissao do arquivo gerado
            chmod($outPath.$fileName, 0775);

            return "Dump gerado com sucesso em {$outPath}{$fileName}";
        }
        catch(Exception $e){
            return $e->getMessage();
        }
    }

    /**
	 * Funcao ajax para a funcao dumpDataModule
     *  - Url para executar a funcao: WEBSITE/index.php?option=com_nobossajax&module=nobosscalendar&method=dumpDataModule&format=raw
	 */
    public static function dumpDataModuleAjax(){
        exit(self::dumpDataModule());
    }
}
