<?php
/**
 * @package			No Boss Extensions
 * @subpackage  	No Boss Calendar
 * @author			No Boss Technology <contact@nobosstechnology.com>
 * @copyright		Copyright (C) 2022 No Boss Technology. All rights reserved.
 * @license			GNU Lesser General Public License version 3 or later; see <https://www.gnu.org/licenses/lgpl-3.0.en.html>
 */

defined('_JEXEC') or die;

// require_once 'script.extension.php';
// mod_NobosscalendarInstallerScript::updateVersion_review_admin();
// exit;

// Garante que nao serao exibidos erros ou notices na extensao
//error_reporting(0);

$app = JFactory::getApplication();
$doc = JFactory::getDocument();
// pega o template vinculado a pagina
$tmpl = $app->getTemplate(true);

// pega os parametros do template
$tmplParams = $tmpl->params;
// pega a cor primaria setada nos parametros do template
$tmplPrimaryColor = $tmplParams->get('primary_color');
// pega a cor secundaria setada nos parametros do template
$tmplSecondaryColor = $tmplParams->get('secondary_color');

// Importa os arquivos da library noboss
jimport('noboss.util.loadextensionassets');
jimport('noboss.util.fonts');
jimport('noboss.util.curl');

$doc->addScriptOptions('site_tmpl', array(
    'tmplName' => $tmpl->template
));

// Parametro com nome do modulo nao esta definido
if (!isset($module->name)){
    $module->name = str_replace('mod_', '', $module->module);
}
$moduleName = $module->name;
$extensionName = "mod_" . $module->name;
$idModule = $module->id;
$idCalendar = $params->get("id_calendar", 0);

// Carrega helper do módulo.
JLoader::register('ModNobosscalendarHelper', __DIR__ . '/helper.php');

// Verifica se no boss library esta instalada: se ainda nao estiver, tenta instalar e se ainda nao der retorna false
if(!ModNobosscalendarHelper::checkLibraryInstallation()){
    return;
}

// Carrega jQuery.
JHtml::_('jquery.framework');

// Módulo
$theme = json_decode($params->get('theme'))->theme;

// Tema nao definido
if (empty($theme)){
    return;
}

// string com o nome da modal da área externa concatenado com o modelo selecionado 
$externalAreaXml = "external_area";
// variável que armazena o objeto com os parâmetros da modal de área externa do tema selecionado  
$externalArea = json_decode($params->get($externalAreaXml));

// Área externa
// armazena estilo da seção, elemento mais externo do html 
$sectionStyle = "";
// armazena estilo da seção para o mobile, elemento mais externo do html 
$sectionStyleMobile = "";

// Ajustes manuais da área externa caso exista valor
if ($externalArea->external_area_display_mode){
    if(!empty($externalArea->external_area_width)){
        $sectionStyle .= 'margin-left: auto !important; margin-right: auto !important; width:' . $externalArea->external_area_width . '%;';
    }
    if(!empty($externalArea->external_area_width_mobile)){
        $sectionStyleMobile .= 'width:' . $externalArea->external_area_width_mobile . '% !important; ';
    }
}

// verifica se é o modelo 2 para definir o estilo de largura do conteudo
if($theme == "model2"){
    // verifica qual o modo de exibição
    // 1: é manual, então exibe container
    // 0: é full width 
    if($externalArea->content_display_mode){
        $itemColumns = !empty($externalArea->content_columns) ? "nb-lg-{$externalArea->content_columns} nb-md-{$externalArea->content_columns} nb-sm-{$externalArea->content_columns} nb-xs-12" : "";
    }
}

// Armazena o tipo de fundo da area externa (cor ou gradiente)
$backgroundType = $externalArea->external_area_background_type;

// Se o tipo de fundo for "cor"
// pega a cor definida no modulo ou a cor primaria do template
$externalArea->external_area_background_color = !empty($externalArea->external_area_background_color) ? $externalArea->external_area_background_color : $tmplPrimaryColor;
if($backgroundType == "background-color" && !empty($externalArea->external_area_background_color)){
    // pega a cor definida no modulo ou a cor primaria do template
    $externalArea->external_area_background_color = !empty($externalArea->external_area_background_color) ? $externalArea->external_area_background_color : $tmplPrimaryColor;
    // Armazena essa cor ao estilo de fundo da secao
    $sectionStyle .= "background-color: {$externalArea->external_area_background_color};";
}elseif($backgroundType == "background-gradient"){
    // Se o tipo for gradiente, acresenta o CSS de gradiente ao estilo da seção
    $gradient1 = $externalArea->external_area_gradient_filter_1;
    $gradient2 = $externalArea->external_area_gradient_filter_2;
    $sectionStyle .= "background: {$gradient2}; ";
    $sectionStyle .= "background: -webkit-linear-gradient(to right, {$gradient1}, {$gradient2}); "; 
    $sectionStyle .= "background: linear-gradient(to right, {$gradient1}, {$gradient2}); ";
}

// espaçamento interno
$innerSpace = $externalArea->external_area_inner_space;
$innerSpaceMobile = $externalArea->external_area_inner_space_mobile;

// armazena o estilo do espaçamento interno na variável que é colocada no elemento mais externo
$sectionStyle .= ' padding: ' . implode(' ', $innerSpace) . '; ';
// armazena o estilo do espaçamento interno para o mobile na variável que é colocada no elemento mais externo
$sectionStyleMobile .= 'padding: ' . implode(' ', $innerSpaceMobile) . ' !important; ';

// espaçamento externo
$outerSpace = $externalArea->external_area_outer_space;
$outerSpaceMobile = $externalArea->external_area_outer_space_mobile;

// armazena o estilo do espaçamento externo na variável que é colocada no elemento mais externo
$sectionStyle .= ' margin: ' . implode(' ', $outerSpace) . '; ';
// armazena o estilo do espaçamento externo na variável que é colocada no elemento mais externo
$sectionStyleMobile .= 'margin: ' . implode(' ', $outerSpaceMobile) . ' !important;';


// Dados para titulo dos destaques
$showTitle = $params->get('show_title');
$titleStyle = ""; $title = ""; $titleStyleMobile = "";
if($showTitle){
    $title = rtrim($params->get('title'));
    $titleTagHtml	= $externalArea->title_tag_html;
    $titleStyle .= NoBossUtilFonts::importNobossfontlist($externalArea->title_font);
    $titleStyle .= " text-align: {$externalArea->title_alignment};";
    $titleStyle .= " text-transform: {$externalArea->title_transform};";
    // pega a cor definida no modulo ou a cor primaria do template
    $externalArea->title_color = !empty($externalArea->title_color) ? $externalArea->title_color : $tmplPrimaryColor;
    $titleStyle .= " color: {$externalArea->title_color};";
    $titleSize = $externalArea->title_size;
    if(!empty($titleSize)){
        $titleSizeEm = $titleSize/16;
        $titleStyle .= " font-size: {$titleSize}px; font-size: {$titleSizeEm}em;";
    }
    if(!empty($externalArea->title_size_mobile)){
        $titleSizeMobile  = $externalArea->title_size_mobile;
        $titleSizeMobileEm = $titleSizeMobile/16;
        $titleStyleMobile = " font-size: {$titleSizeMobile}px; font-size: {$titleSizeMobileEm}em !important;";
    }
    if(!empty($externalArea->title_space)){
        $titleStyle .= " padding:".implode(" ", $externalArea->title_space).";";
    }
}

// Dados para texto de apoio dos destaques
$showSubtitle = $params->get('show_subtitle');
$subtitleStyle = ""; $subtitle = ""; $subtitleStyleMobile = "";
if($showSubtitle){
    $subtitle = nl2br(rtrim($params->get('subtitle')));
    $subtitleTagHtml = $externalArea->subtitle_tag_html;
    $subtitleStyle .= NoBossUtilFonts::importNobossfontlist($externalArea->subtitle_font);
    $subtitleStyle .= " text-align: {$externalArea->subtitle_alignment};";
    $subtitleStyle .= " text-transform: {$externalArea->subtitle_transform};";
    // pega a cor definida no modulo ou a cor primaria do template
    $externalArea->subtitle_color = !empty($externalArea->subtitle_color) ? $externalArea->subtitle_color : $tmplPrimaryColor;
    $subtitleStyle .= " color: {$externalArea->subtitle_color};";
    $subtitleSize = $externalArea->subtitle_size;
    if(!empty($subtitleSize)){
        $subtitleSizeEm = $subtitleSize/16;
        $subtitleStyle .= " font-size: {$subtitleSize}px; font-size: {$subtitleSizeEm}em;";
    }
    if(!empty($externalArea->subtitle_size_mobile)){
        $subtitleSizeMobile  = $externalArea->subtitle_size_mobile;
        $subtitleSizeMobileEm = $subtitleSizeMobile/16;
        $subtitleStyleMobile = " font-size: {$subtitleSizeMobile}px; font-size: {$subtitleSizeMobileEm}em !important;";
    }
    if(!empty($externalArea->subtitle_space)){
        $subtitleStyle .= " padding:".implode(" ", $externalArea->subtitle_space).";";
    }
}

// Obtem parametros da modal
$modalCustomization = json_decode($params->get('modal_customization'));
$modalCustomization = ModNobosscalendarHelper::getModalParams($idModule, $modalCustomization);

// Categorias
//$categories = ModNobosscalendarHelper::getCategories($idCalendar);

$events = array();

// Id do calendario definido
if ($idCalendar){
    // Obtem eventos no banco
    $events = ModNobosscalendarHelper::getEventsDataBase($idCalendar, $idModule, 1);
}

$nowDate = date('Y-m-d H:i:s');

// armazena o numero de eventos publicados
$availableItems = count((array) $events);

// verifica se há pelo menos um evento publicado
if($availableItems){
    // Pega os parametros de estilo usados nas partes atualizáveis do calendário  
    $calendarParams = ModNobosscalendarHelper::getCalendarParams($idModule);
    $custom = $calendarParams->itemsCustomization;

    if(!empty($custom->sidebar_background_color)){
        $custom->sidebar_background_color = !empty($custom->sidebar_background_color) ? $custom->sidebar_background_color : $tmplPrimaryColor;
    }

    if(!empty($custom->events_background_color)){
        $custom->events_background_color = !empty($custom->events_background_color) ? $custom->events_background_color : $tmplPrimaryColor;
    }

    // Pega data atual para para criar o calendário.
    $auxToday = new DateTime();		
    $today = JDate::getInstance($auxToday->format('Y-m-d'));

    // Nao eh modelo de cards
    if ($theme != 'model2'){
        // Dados para o calendário.
        $dataCalendar = ModNobosscalendarHelper::getDataToCalendar($idModule, $idCalendar, $today, $custom);
    }

    // Modelo de cards e navegacao normal (nao eh por MÊS)
    if(($theme == "model2") && (isset($custom->browsing_month)) && ($custom->browsing_month == 0)){
        // Obtem eventos utilizando funcao que obtem eventos proximos da data atua
        $returnEventsCards = ModNobosscalendarHelper::getRunningEventsCards($idModule, $custom->events_to_display, $custom->interval_days);

        // Ha resultados a exibir: seta data inicial do primeiro evento como $date
        if (count($returnEventsCards->events) > 0){
            $eventsSearch = $returnEventsCards->events;
            unset($returnEventsCards->events);
            $date = new JDate($eventsSearch[0]->initial_date);
        }
    }
    // Modelo de cards e navegacao por mes
    else if ($theme == "model2"){
        // Pega o primeiro dia do mes
        $date = ModNobosscalendarHelper::getFirstDayMonth($today);

        // Setado para exibir meses sem eventos na navegacao
        if($custom->display_empty_month == 1){
            $monthSkipEmpty = 1;
        }
        // Setado para pular meses sem eventos: fixa um limite de tentativas de meses a buscar com evento
        else{
            $monthSkipEmpty = 24;
        }

        // Contador de meses pulados (sem eventos)
        $skippedMonths = 0;

        $eventsSearch = array();

        // Navega bucando meses ate achar mes com eventos, respeitando limite da variavel $monthSkipEmpty
        while((empty((array)$eventsSearch)) && ($skippedMonths < $monthSkipEmpty)){
            // Ja tentou o mes atual: passa um mes para frente
            if($skippedMonths > 0){
                $date->modify("+1 month");
            }
            
            // Clona a data, colocando ponteiro para ultimo dia do mes
            $finalDate = clone $date;
            $finalDate->modify('last day of this month');
            
            // Obtem os eventos do mes navegado
            $eventsSearch = ModNobosscalendarHelper::getEvents($date, $finalDate, $idModule);

            $skippedMonths++;
        }

    }
    // Navegacao por mes (demais modelos)
    else{
        // Pega o primeiro dia do mes
        $date = ModNobosscalendarHelper::getFirstDayMonth($today);
        // Clona o primeiro dia para ser percorrido na montagem do calendario
        $dateFor = clone $date;
        
        $lastDate = clone $date;
        $lastDate->modify('last day of this month');
    }
    
    // Caso seja o modelo 1
    if($theme == "model1"){
        // pega um array com todos os meses do ano e seu respectivo numero de eventos
        $yearMonths = ModNobosscalendarHelper::getEventsYear($date, $idModule);	
    }

    // Define prefixo a ser utilizado na insercao de codigos inline para CSS e JS
    $prefixCodeJsAndCss = "[module-id={$module->name}_{$module->id}]";

    // Obtem informacoes de codigos JS e CSS a serem inseridos
    $loadJs	 		= $params->get('load_js');
    $loadCss 		= $params->get('load_css');
    $overwritingJs	= (!empty($params->get('overwriting_js'))) ? rtrim($params->get('overwriting_js')) : '';
    $overwritingCss	= (!empty($params->get('overwriting_css'))) ? rtrim($params->get('overwriting_css')) : '';

    // Instancia objeto passando o nome da extensao com prefixo (ex: 'mod_nobossbanners')
    $assetsObject = new NoBossUtilLoadExtensionAssets($extensionName, $prefixCodeJsAndCss);

    // Adiciona arquivos e codigos JS (se definido para exibir)
    $assetsObject->loadJs($loadJs, array('code' => $overwritingJs));

    // Adiciona arquivo CSS para uma familia de fontes
    $assetsObject->loadFamilyIcons("font-awesome-v6");

    // Adiciona arquivos e codigos CSS (se definido para carregar)
    $assetsObject->loadCss($loadCss, array('code' => $overwritingCss));
    
    //adiciona os arquivos de estilo do tema
    require JModuleHelper::getLayoutPath($extensionName, 'style/' . $theme);
    require JModuleHelper::getLayoutPath($extensionName, 'style/no_events');
    
    // Carrega as semanas e dias do calendario (menos para o modelo 2 que eh de cards)
    if($theme != "model2"){
        require JModuleHelper::getLayoutPath($extensionName, 'style/calendar_body');
    }

    // Carrega o tema do modelo navegado
    require JModuleHelper::getLayoutPath($extensionName, 'theme/'.$params->get('layout', $theme));
}

// Obtem dados da API do Google
$googleApi = (!empty($params->get('google_calendar'))) ? json_decode($params->get('google_calendar')) : '';

// Dados da API estao definidos e importacao automatica esta habilitada
if(!empty($googleApi) && ($googleApi->importer_automatic_enable)){
    $connection = json_decode($googleApi->connection);

    // Verifica ainda se dados da conexao estao definidos
    if(!empty($connection) && !empty($connection->client_id) && !empty($connection->access_token)){
        // Ainda nao foi adicionado na pagina script de importacao para id_calendar do modulo atual (essa verificacao impede que script seja executado mais de uma vez na mesma pagina qnd mais de um calendario eh carregado usando o mesmo id_calendar)
        if(((version_compare(JVERSION, '4', '<')) && (@!strpos($doc->_script["text/javascript"], "formData_{$idCalendar}"))) || ((version_compare(JVERSION, '4', '>=')) && (@!strpos(implode(' ', $doc->_script["text/javascript"]), "formData_{$idCalendar}")))){
            // Executa requisicao JS async para funcao que faz importacao automatica de eventos da API
            $doc->addScriptDeclaration("
                let formData_{$idCalendar} = new FormData();
                formData_{$idCalendar}.append('params_api','".urlencode($params->get('google_calendar'))."');
                formData_{$idCalendar}.append('id_module','".$idModule."');
                formData_{$idCalendar}.append('id_calendar','".$idCalendar."');
                formData_{$idCalendar}.append('api','googlecalendar');
                let xhttp_{$idCalendar} = new XMLHttpRequest();
                xhttp_{$idCalendar}.open('POST', '".JURI::root()."index.php?option=com_nobossajax&module=nobosscalendar&method=apiImportAutomatic&format=raw', true);
                xhttp_{$idCalendar}.send(formData_{$idCalendar});");
        }
    }
}
