 <?php
/**
 * @package			No Boss Extensions
 * @subpackage  	No Boss Calendar
 * @author			No Boss Technology <contact@nobosstechnology.com>
 * @copyright		Copyright (C) 2020 No Boss Technology. All rights reserved.
 * @license			GNU Lesser General Public License version 3 or later; see <https://www.gnu.org/licenses/lgpl-3.0.en.html>
 */

defined('_JEXEC') or die();

?>

<div class="nb-calendar__body <?php echo $numCategories == 0 ? 'is-empty-margin' : ''; ?>" data-now="<?php echo $date; ?>"  <?php echo $theme == 'model3' ? $custom->calendar_background_color : ''; ?>">  
    <?php 
    // Inclui o arquivo que contém o mês e as setas de navegação
    require JModuleHelper::getLayoutPath($extensionName, 'common/month_header');

    // flag que indica se a semana comeca na segunda
    $startsOnMonday = isset($custom->week_initial_day) ? $custom->week_initial_day === "monday" : false;
    
    ?>
    <div class="nb-week" style="<?php echo $custom->days_week_size; ?>">
        <?php if(!$startsOnMonday){ ?>
            <div class="nb-week__day <?php if (!empty($custom->highlight_month_day_color) && $today->dayofweek == 7 && $date->month == $today->month && $date->year == $today->year) {echo 'nb-week__day--today';}?>" style="<?php echo (!empty($custom->days_week_color_sunday)) ? "color: {$custom->days_week_color_sunday};" : ''; ?>">
                <?php echo JText::_('MOD_NOBOSSCALENDAR_WEEKDAY_SUNDAY'); ?>
            </div>
        <?php } ?>
        <div class="nb-week__day <?php if (!empty($custom->highlight_month_day_color) && $today->dayofweek == 1 && $date->month == $today->month && $date->year == $today->year) {echo 'nb-week__day--today';}?>">
            <?php echo JText::_('MOD_NOBOSSCALENDAR_WEEKDAY_MONDAY'); ?>
        </div>
        <div class="nb-week__day <?php if (!empty($custom->highlight_month_day_color) && $today->dayofweek == 2 && $date->month == $today->month && $date->year == $today->year) {echo 'nb-week__day--today';}?>">
            <?php echo JText::_('MOD_NOBOSSCALENDAR_WEEKDAY_TUESDAY'); ?>
        </div>
        <div class="nb-week__day <?php if (!empty($custom->highlight_month_day_color) && $today->dayofweek == 3 && $date->month == $today->month && $date->year == $today->year) {echo 'nb-week__day--today';}?>">
            <?php echo JText::_('MOD_NOBOSSCALENDAR_WEEKDAY_WEDNESDAY'); ?>
        </div>
        <div class="nb-week__day <?php if (!empty($custom->highlight_month_day_color) && $today->dayofweek == 4 && $date->month == $today->month && $date->year == $today->year) {echo 'nb-week__day--today';}?>">
            <?php echo JText::_('MOD_NOBOSSCALENDAR_WEEKDAY_THURDAY'); ?>
        </div>
        <div class="nb-week__day <?php if (!empty($custom->highlight_month_day_color) && $today->dayofweek == 5 && $date->month == $today->month && $date->year == $today->year) {echo 'nb-week__day--today';}?>">
            <?php echo JText::_('MOD_NOBOSSCALENDAR_WEEKDAY_FRIDAY'); ?>
        </div>
        <div class="nb-week__day <?php if (!empty($custom->highlight_month_day_color) && $today->dayofweek == 6 && $date->month == $today->month && $date->year == $today->year) {echo 'nb-week__day--today';}?>">
            <?php echo JText::_('MOD_NOBOSSCALENDAR_WEEKDAY_SATURDAY'); ?>
        </div>
        <?php if($startsOnMonday){ ?>
            <div class="nb-week__day <?php if (!empty($custom->highlight_month_day_color) && $today->dayofweek == 7 && $date->month == $today->month && $date->year == $today->year) {echo 'nb-week__day--today';}?>" style="<?php echo (!empty($custom->days_week_color_sunday)) ? "color: {$custom->days_week_color_sunday};" : ''; ?>">
                <?php echo JText::_('MOD_NOBOSSCALENDAR_WEEKDAY_SUNDAY'); ?>
            </div>
        <?php } ?>
    </div>
    <div class="nb-month">
        <?php // Dias do mês. ?>
        <div class="nb-month__week">
            <?php
            // Preenche como "branco" datas iniciais do calendário que não pertencem ao mês atual.
            // Caso o dia da semana seja o 7, Domingo, não é preciso colocar dias em branco
            if ($dateFor->dayofweek != ($startsOnMonday ? 1 : 7)) { ?>
                <?php for ($i = ($startsOnMonday ? 1 : 0); $i < $dateFor->dayofweek; $i++) { ?>
                    <div class="nb-month__day nb-month__day--blank">&nbsp;</div>
                <?php }
            } 
            
            // Mês atual.
            $monthCurrent = $dateFor->month;
            
            // Evento percorrido eh do mes que esta sendo navegado
            while ($dateFor->month == $monthCurrent) {
                // Dia formatado sem zero a esquerda.
                $formatedDay = ltrim($dateFor->day, '0');
                // Verifica se o dia possui evento.
                $dayHasEvent = (isset($dataCalendar['days'][$dateFor->day]));
            
                // Se for o último dia da semana.
                if ($dateFor->dayofweek == ($startsOnMonday ? 1 : 7)) { ?>
                    <?php // Fecha linha e abre uma nova. ?>
                    </div>
                    <div class="nb-month__week">
                <?php } ?>
                
                <?php // Div de cada dia do calendario ?>
                <div data-day="<?php echo $dateFor->format('Y-m-d'); ?>" data-day-only="<?php echo $dateFor->format('j'); ?>" class="nb-month__day <?php if (!empty($custom->highlight_month_day_color) && $today->format('Y-m-d') == $dateFor->format('Y-m-d')) {echo 'nb-month__day--today ';}if ($dayHasEvent == true) {echo 'nb-month__day--event';} ?>" style="<?php echo ((!empty($custom->days_week_color_sunday)) && ($dateFor->dayofweek == 7)) ? "color: {$custom->days_week_color_sunday};" : ''; ?>">
                    
                    <span class="nb-month__date" style="<?php echo $custom->days_month_size; ?>">
                        <?php echo $formatedDay; ?>
                    </span>
                    <?php 
                    
                    // Dia possui evento: exibe cores da categoria
                    if ($dayHasEvent == true) {
                        ?>
                        <div class="nb-event-categories">
                            <?php
                            $duplicated = array(); 

                            // Percorre eventos do dia
                            foreach($dataCalendar['days'][$dateFor->day] as $event){ 
                                // Evento possui categoria vinculada
                                if (!empty($event->event_category->id)){
                                    if(isset($event->event_category->category_color)){
                                        $event->event_category->category_color = !empty($event->event_category->category_color) ? $event->event_category->category_color : $tmplPrimaryColor;
                                    }

                                    if(!in_array($event->event_category->id, $duplicated)){
                                        array_push($duplicated, $event->event_category->id); ?>

                                        <span data-category-id="<?php echo $event->event_category->id; ?>" class="nb-event-categories__category" style="background-color: <?php echo $event->event_category->category_color; ?>"></span>
                                    <?php
                                    }
                                }
                            }
                            ?>
                        </div>
                        <?php
                    } 
                    ?>
                </div>

                <?php
                // Adiciona um dia a iteração. 
                $dateAux = clone $dateFor;
                $dateFor = $dateFor->getInstance($dateFor->toSql() . " +1 day");
            } ?>
            <?php // Preenche como "branco" datas finais do calendário que não pertencem ao mês atual. ?>

            <?php 
                // Se for o último dia da semana.
                if ($dateFor->dayofweek == ($startsOnMonday ? 1 : 7) && $dateAux->day == $dateAux->modify('last day of this month')->day) { ?>
                    <?php // Fecha linha e abre uma nova. ?>
                    </div>
                    <div class="nb-month__week">
                <?php }
                
                if($startsOnMonday){
                    for ($i = $dateFor->dayofweek; $i <= 7; $i++) {  ?>
                        <div class="nb-month__day nb-month__day--blank">&nbsp;</div>
                    <?php 
                    }
                }else{
                    for ($i = $dateFor->dayofweek; $i < 7; $i++) {  ?>
                        <div class="nb-month__day nb-month__day--blank">&nbsp;</div>
                <?php }
                }
            ?>
        </div>
    </div>
</div>
