<?php
/**
 * @package			No Boss Extensions
 * @subpackage  	No Boss Calendar
 * @author			No Boss Technology <contact@nobosstechnology.com>
 * @copyright		Copyright (C) 2020 No Boss Technology. All rights reserved.
 * @license			GNU Lesser General Public License version 3 or later; see <https://www.gnu.org/licenses/lgpl-3.0.en.html>
 */

defined('_JEXEC') or die();

$legends = $dataCalendar['legends'];
$numCategories = count($legends); 
?>

<div class="nb-calendar__inner">
    <div class="nb-calendar__content" style="<?php echo $custom->calendar_background_color; ?>">
        <?php // Adiciona template da tabela do calendário. ?>
        <?php require JModuleHelper::getLayoutPath('mod_nobosscalendar', 'common/calendar_body');?>
    </div>

    <div class="nb-events <?php echo isset($isOpen) && $isOpen ? 'is-open' : ''; echo ($custom->display_month_events == '2') ? 'nb-events--slide' : ''; ?>" data-minimumwidth="<?php echo $custom->bar_list_minimum_width; ?>" data-eventlist="<?php echo $custom->display_month_events; ?>" style='<?php echo $custom->calendar_events_background_color; ?>'>
        <?php
        // Sem eventos a exibir no mes 
        if(empty($dataCalendar['days'])){ 
            require JModuleHelper::getLayoutPath('mod_nobosscalendar', 'common/no_events');
        }
        // Tem eventos a exibir
        else {
            // Para desktop o botao voltar eh sempre exibido no topo. Ja no mobile depende do que for definido em parametro
            ?>
            <button class="nb-back-button nb-back-button--desktop <?php echo ($custom->back_button_position_mobile == 'top') ? 'nb-back-button--mobile': ''; ?>" style='<?php echo "color: {$custom->events_texts_color};" ?>'>
                <?php echo JText::_('MOD_NOBOSSCALENDAR_MODAL_BUTTON_RETURN'); ?>
            </button>
            <?php 

            // Carrega area que lista todos eventos do mes
            require JModuleHelper::getLayoutPath('mod_nobosscalendar', 'common/day_events');

            // Definido que botao de 'voltar' deve ser exibido no rodape para mobile
            if($custom->back_button_position_mobile == 'bottom'){
                ?>
                    <button class="nb-back-button nb-back-button--mobile" style='<?php echo "color: {$custom->events_texts_color};" ?>'>
                        <?php echo JText::_('MOD_NOBOSSCALENDAR_MODAL_BUTTON_RETURN'); ?>
                    </button>
                <?php
            }

            // Legendas para o mobile
            if(($custom->show_legends) && (!empty($dataCalendar['legends']))  && ((count($dataCalendar['legends']) > 1) || $dataCalendar['legends'][0]->id != 'none1')){ 
            ?>
                <div class="nb-legends nb-legends--mobile <?php echo $numCategories == 0 ? 'is-empty' : ''; ?>">
                    <?php if($numCategories > 0){ ?>
                        <?php require JModuleHelper::getLayoutPath('mod_nobosscalendar', 'common/legends'); ?>
                    <?php } ?>
                </div>
            <?php 
            }
        } ?>
    </div>

    <?php 
    // Legendas para o desktop
    if(($custom->show_legends) && (!empty($dataCalendar['legends'])) && ((count($dataCalendar['legends']) > 1) || $dataCalendar['legends'][0]->id != 'none1')){ 
    ?>
        <div class="nb-legends nb-legends--desktop <?php echo ($numCategories == 1) ? 'is-single-category' : '' ; ?> <?php echo $numCategories == 0 ? 'is-empty' : ''; ?>">
            <?php
            if($numCategories > 0){
                require JModuleHelper::getLayoutPath('mod_nobosscalendar', 'common/legends');
            }
            ?> 
        </div>
    <?php 
    }

    // Requisicao feita via ajax
    if (isset($isAjax)){
        $doc = JFactory::getDocument();

        // Existem scripts inline (formato J3, mas que ainda funciona no J4)
        if(!empty($doc->_style) && !empty($doc->_style['text/css'])){
            $stylesInline = $doc->_style['text/css'];

            // No J4 vem como array e convertemos para string para ficar igual ao J3
            if(is_array($stylesInline)){
                $stylesInline = implode(' ', $stylesInline);
            }
        }

        // Adiciona na pagina via PHP para todos os casos (ajax ou nao)
        echo "<style>{$stylesInline}</style>";
    }
    ?>
</div>

<?php
// Carrega modais de conteudo escondidas
require JModuleHelper::getLayoutPath($extensionName, 'common/modal');
?>
