<?php
/**
 * @package			No Boss Extensions
 * @subpackage  	No Boss Calendar
 * @author			No Boss Technology <contact@nobosstechnology.com>
 * @copyright		Copyright (C) 2023 No Boss Technology. All rights reserved.
 * @license			GNU Lesser General Public License version 3 or later; see <https://www.gnu.org/licenses/lgpl-3.0.en.html>
 * 
 * @nota            Arquivo que lista os eventos do mes e os exibe conforme o dia que for clicado no calendario
 */

defined('_JEXEC') or die();

// Contador para montar id do evento para manipulacao via JS
$count = 0;

// Array para armazenar eventos com modal
$arrayEventsModal = array();

// Array para armazenar eventos que ja foram exibidos
$arrayEventsDisplay = array();

?>

<ul class="nb-events__list">
    <?php
    // Percorre todos os dias que tem eventos
    foreach ($dataCalendar['days'] as $day => $eventsOfDay){
        // Percorre todos os eventos do dia corrente
        foreach ($eventsOfDay as $event){
            // Evento ainda nao foi carregado na pagina
            if (!in_array($event->id_event, $arrayEventsDisplay)){
                 // Adiciona evento no array de eventos exibidos
                array_push($arrayEventsDisplay, $event->id_event);
            }
            // Evento nao eh recorrente ou o tipo de recorrencia nao eh por 'datas especificas'
            else if((empty($event->recurrence_type)) || (($event->recurrence_type != 'specific-dates') && ($event->recurrence_type != 'specific-dates-hours'))){
                // Impede o evento de ser exibido novamente 
                // somente evento do tipo 'datas especificas' eh exibido mais de uma vez pq fazemos ele ser duplicado para cada dia (inclusive a variavel '$event->is_recurrent' vem como 0)
                continue;
            }

            if (!empty($event->link)){
                $event->link = rtrim($event->link);
            }

            if (!isset($event->one_event_schedule)){
                $event->one_event_schedule = 0;
            }

            $dateIni = new JDate($event->initial_date); 
            $dateFim = new JDate($event->final_date);

            $classHideEvent = '';

            // Setado para exibir eventos na latetal
            if($custom->display_month_events == '1'){
                // Setado para exibir apenas eventos com mesma data do dia de hoje
                if($custom->events_to_display_default == 'day'){
                    // Eventos do dia, ano e mes do dia atual sao iguais ao ano e mes carregado E dia de hoje existe no array de datas a exibir do evento
                    if(($today->year == $date->year) && ($today->month == $date->month) && (in_array($today->day, $event->days))){
                        // Exibir evento do dia corrente
                        $classHideEvent = '';
                    }
                    // Nao eh uma data igual ao dia de hoje
                    else{
                        // Seta para exibir evento
                        $classHideEvent = ' hide-day';
                    }
                }
                // Setado para exibir todos eventos do mes no carregamento
                elseif($custom->events_to_display_default == 'month'){
                    // Exibir evento do dia corrente
                    $classHideEvent = '';
                }
                // Setado para nao exibir nenhum evento
                elseif($custom->events_to_display_default == 'none'){
                    // Seta para exibir evento
                    $classHideEvent = ' hide-day';
                }
            }

            $qntDisplayEvent = 1;

            // Evento setado para ser exibido uma vez por data
            if (($event->one_event_schedule == 1) && (count($event->hours) > 1)){
                // Define qnt de exibicoes do evento na listagem conforme qnt de horarios cadastrados
                $qntDisplayEvent = count($event->hours);
            }            

            // Percorre todas exibicoes a fazer do evento
            for ($key = 0; $key < $qntDisplayEvent; $key++) {
                // Evento tem horario a exibir: pega data inicial e final da exibicao corrente
                if ((!empty($event->hours)) && (count($event->hours) > 0)){
                    $event->initial_time = $event->hours[$key]->initial;
                    $event->final_time = $event->hours[$key]->final;
                    // Quebra horario em array para pegar hora e minutos separadamente
                    $time = explode(':', $event->initial_time);
                    // Obtem timestamp para o horario inicial (utilizado para montar ordenacao dos resultados via css com flex order)
                    $timestampInitialTime = mktime($time[0], $time[1], 0, $date->month, $event->days[0], $date->year);
                }
                // Evento nao possui horario
                else{
                    // Obtem timestamp apenas da data
                    $timestampInitialTime = mktime(0, 0, 0, $date->month, $event->days[0], $date->year);
                }
                ?>
                <li class="nb-events__item <?php echo $event->link_option == 'modal' ? 'nb-events__item--has-modal-card' : '';  echo $classHideEvent; ?> <?php echo (($event->link_option === 'external' || $event->link_option === 'internal') && !empty($event->link)) ? 'has-link' : ''; ?>" style='order:<?php echo $timestampInitialTime; ?>; <?php echo (!empty($event->event_text_color)) ? "color: {$event->event_text_color};" : "color: {$custom->events_texts_color};" ; ?>' 
                    data-event-category="<?php echo (isset($event->event_category->id)) ? $event->event_category->id : ''; ?>" 
                    data-days="<?php echo json_encode($event->days); ?>"
                    <?php echo "module-item-id={$moduleName}_{$idModule}_{$date->month}_{$count}"; ?>>
                    
                    <?php 
                    // Carrega estilo da lateral que exibe os eventos
                    require JModuleHelper::getLayoutPath($extensionName, 'style/day_events');

                    // Evento possui link de url: realiza abertura do <a href>
                    if (($event->link_option === 'external' || $event->link_option === 'internal') && !empty($event->link)){ ?>
                        <a href="<?php echo $event->link; ?>" class="nb-event__link" target="<?php echo $event->link_target; ?>" title="<?php echo $event->link_title; ?>">
                    <?php
                    } ?>
                    <div class="nb-event__content">
                        <div class="nb-event__date" style='<?php echo $custom->events_date_style; ?>;'>
                            <?php // Data inicial ?>
                            <span class="nb-event__start" style='<?php echo $custom->events_title_font_family; ?> text-transform: <?php echo $custom->events_title_transform; ?>;' <?php echo (isset($event->is_recurrent) && $event->is_recurrent) ? 'start-date-id="event-recurrent"' : '';?>'>
                                <?php
                                // Evento recorrente: exibe datas que ocorre no mes (exibido por default qnd vem todos eventos do mes listados, mas qnd usuario ve o evento clicando em uma data, exibe apenas o dia clicado via JS)
                                if (isset($event->is_recurrent) && $event->is_recurrent){
                                    echo implode(', ', $event->days).' '.$date->format('M');
                                }
                                // Evento normal
                                else{
                                    echo $dateIni->format('d').' '.$dateIni->format('M');
                                }
                                ?>
                            </span>
                            <?php 
                            // Data final diferente de data inicial e nao eh evento recorrente: exibe tb a data final
                            if (($dateIni != $dateFim) && (isset($event->is_recurrent) && (!$event->is_recurrent))){ ?>
                                <span class="nb-event__end" style='<?php echo $custom->events_title_font_family; ?> text-transform: <?php echo $custom->events_title_transform; ?>;'>
                                    <?php 
                                    echo $dateFim->format('d').' '.$dateFim->format('M');
                                    ?>
                                </span>
                            <?php
                            }
                            ?>                            
                        </div>
                        <?php
                        // Hora do evento definida
                        if(!empty($event->initial_time)){
                                ?>
                            <div class="nb-event__time" style='<?php echo $custom->events_schedule_style; ?>'>
                                <?php
                                // Exibicao de todos horarios em um unico evento
                                if ($event->one_event_schedule == 0){
                                    // Percorre todos horarios do evento
                                    foreach ($event->hours as $key => $hour) {
                                        // Se nao for o primeiro item, adiciona um separador
                                        if($key > 0){
                                            echo ' | ';
                                        }
                                        
                                        // Exibe da hora inicial
                                        if($custom->events_schedule_format == 'am-pm'){
                                            echo JFactory::getDate($hour->initial)->format('h:i A');
                                        }
                                        else{
                                            echo $hour->initial;
                                        }

                                        // Exibe hora final (caso seja diferente da inicial)
                                        if(!empty($hour->final) && ($hour->initial != $hour->final)){
                                            if($custom->events_schedule_format == 'am-pm'){
                                                echo ' - '.JFactory::getDate($hour->final)->format('h:i A');
                                            }
                                            else{
                                                echo ' - '.$hour->final;
                                            }
                                        }
                                    }
                                }
                                // Exibicao de um evento por data
                                else{
                                    // Exibe da hora inicial
                                    if($custom->events_schedule_format == 'am-pm'){
                                        echo JFactory::getDate($event->initial_time)->format('h:i A');
                                    }
                                    else{
                                        echo $event->initial_time;
                                    }
                                    
                                    if(!empty($event->final_time) && ($event->initial_time != $event->final_time)){
                                        // Hora final
                                        if($custom->events_schedule_format == 'am-pm'){
                                            echo ' - '.JFactory::getDate($event->final_time)->format('h:i A');
                                        }
                                        else{
                                            echo ' - '.$event->final_time;
                                        }
                                    }
                                }
                                ?>
                            </div>
                            <?php 
                        } ?>
                        <div class="nb-event__infos">
                            <?php
                            $event->event_title = rtrim($event->event_title);
                            $event->event_subtitle = rtrim($event->event_subtitle);
                            $event->event_place = rtrim($event->event_place);

                            if (!empty($event->event_title)) {
                                echo "<{$custom->events_title_tag_html} class='nb-event__title' style='{$custom->events_title_style}'>{$event->event_title}</{$custom->events_title_tag_html}>";
                            }
                            if (!empty($event->event_subtitle)) {
                                $event->event_subtitle = nl2br($event->event_subtitle);

                                echo "<{$custom->events_subtitle_tag_html} class='nb-event__description' style='{$custom->events_subtitle_style}'>{$event->event_subtitle}</{$custom->events_subtitle_tag_html}>";
                            }
                            if(!empty($event->event_place)){
                                $event->event_place = nl2br($event->event_place);
                                ?>
                                <span class="nb-event__localization" <?php echo (!empty($event->event_place_link)) ? "data-link='{$event->event_place_link}'" : '';?> style='opacity: 0.75; <?php echo $custom->events_address_style; ?> <?php echo $custom->events_subtitle_font_family; ?> text-align: <?php echo $custom->events_subtitle_alignment; ?>; '><?php echo  $event->event_place; ?></span>
                            <?php
                            }
                            ?>
                        </div>
                    </div>      
                    <?php // Insere link no evento 
                    if (($event->link_option === 'external' || $event->link_option === 'internal') && !empty($event->link)){ ?>
                        </a>
                        <?php 
                    } ?>
                </li>     
                <?php
            }

            // Evento possui modal de conteudo
            if($event->link_option == 'modal' && !empty($event->modal_content)){
                // Armazena id criado para o evento para saber na modal qual deve ser aberta
                $event->moduleItemId = "{$moduleName}_{$idModule}_{$date->month}_{$count}";
                $arrayEventsModal[] = $event;
            }
            $count++;
        }
    } ?>
</ul>
