<?php
/**
 * @package			No Boss Extensions
 * @subpackage  	No Boss Calendar
 * @author			No Boss Technology <contact@nobosstechnology.com>
 * @copyright		Copyright (C) 2022 No Boss Technology. All rights reserved.
 * @license			GNU Lesser General Public License version 3 or later; see <https://www.gnu.org/licenses/lgpl-3.0.en.html>
 * 
 * @nota            Arquivo que carrega modal de conteudo
 */

defined('_JEXEC') or die();

if (isset($arrayEventsModal)){
    // Percorre os eventos do mes que possuem modal (definido no arquivo day_events.php)
    foreach ($arrayEventsModal as $event) {
        // Evento setado realmente para abrir modal
        if($event->link_option == 'modal' && isset($event->modal_content)){
            $dateIni = new JDate($event->initial_date); 
            $dateFim = new JDate($event->final_date);
            ?>
            <div class="<?php echo $moduleName;?>-modal" data-calendar-modal data-calendar-id="<?php echo $event->moduleItemId; ?>">
                <div class="<?php echo $moduleName;?>-modal-inner">
                    <span class="btn-close fa fa-times" data-calendar-close-modal></span>
                    <div class="<?php echo $moduleName;?>-modal-header">
                        <div class="<?php echo $moduleName;?>-modal-header-inner">    
                            
                            <?php // nome do evento ?>
                            <h2 class="<?php echo $moduleName;?>-title"><?php echo $event->event_title; ?></h2>            

                            <?php // nome da categoria (se for para exibir) ?>
                            <?php if(!empty($modalCustomization->show_category) && $modalCustomization->show_category && substr($event->event_category->id, 0, 4) != 'none'){?>
                                <p class="<?php echo $moduleName;?>-category" <?php if (!empty($modalCustomization->show_display_background_color) && ($modalCustomization->show_display_background_color == 1)) { echo "style='background-color: {$event->event_category->category_color};'"; } ?>>
                                    <?php echo $event->event_category->legend; ?>
                                </p>
                            <?php }?>

                            <div class="<?php echo $moduleName;?>-details">
                                <div class="<?php echo $moduleName;?>-dates">
                                    <?php
                                    // data do evento
                                    if(!empty($modalCustomization->show_date) && ($modalCustomization->show_date == 1)) { 
                                        ?>
                                        <div class="<?php echo $moduleName;?>-date">
                                            <i class="fa fa-calendar"></i>
                                            <span>
                                                <?php 
                                                // Evento recorrente: exibe datas que ocorre no mes (exibido por default qnd vem todos eventos do mes listados, mas qnd usuario ve o evento clicando em uma data, exibe apenas o dia clicado via JS)
                                                if ($event->is_recurrent){
                                                    echo implode(', ', $event->days).' '.$date->format('M'); // FIXME: precisamos aqui pegar o mes percorrido
                                                }
                                                // Evento normal: exibe data inicial e final
                                                else{
                                                    // Exibe data inicial
                                                    echo $dateIni->format('d');?> <?php echo $dateIni->format('M');
                                                    
                                                    // Exibe data final (caso seja diferente da inicial)
                                                    if(!empty($dateFim) && ($dateIni != $dateFim)){
                                                        echo $dateFim->format('M'); 
                                                    }
                                                }
                                                ?>
                                            </span>
                                        </div>
                                    <?php }?>

                                    <?php // hora do evento ?>
                                    <?php if(!empty($modalCustomization->show_hour) && ($modalCustomization->show_hour == 1) && !empty($event->hours)){?>
                                        <div class="<?php echo $moduleName;?>-time">
                                            <i class="fa fa-clock-o"></i>
                                            <span>
                                                <?php 
                                                // Percorre todos horarios do evento
                                                foreach ($event->hours as $key => $hour) {
                                                    // Se nao for o primeiro item, adiciona um separador
                                                    if($key > 0){
                                                        echo ' | ';
                                                    }
                                                    // Exibe da hora inicial
                                                    if($custom->events_schedule_format == 'am-pm'){
                                                        echo JFactory::getDate($hour->initial)->format('h:i A');
                                                    }
                                                    else{
                                                        echo $hour->initial;
                                                    }

                                                    // Exibe hora final (caso seja diferente da inicial)
                                                    if(!empty($hour->final) && ($hour->initial != $hour->final)){
                                                        if($custom->events_schedule_format == 'am-pm'){
                                                            echo ' - '.JFactory::getDate($hour->final)->format('h:i A');
                                                        }
                                                        else{
                                                            echo ' - '.$hour->final;
                                                        }
                                                    }
                                                }
                                                ?>
                                            </span>
                                        </div>
                                    <?php }?>
                                </div>

                                <?php 
                                // endereco do evento
                                if(!empty($modalCustomization->show_address) && ($modalCustomization->show_address == 1) && (!empty($event->event_place))){
                                    //$event->event_place = nl2br($event->event_place);
                                    ?>
                                    <span class="nb-event__localization" <?php echo (!empty($event->event_place_link)) ? "data-link='{$event->event_place_link}'" : '';?>><?php echo  $event->event_place; ?></span>
                                <?php 
                                }
                                ?>
                            </div>
                        </div>
                    </div>
        
                    <?php // conteudo detalhado do evento ?>
                    <div class="<?php echo $moduleName;?>-modal-body">
                        <p class="<?php echo $moduleName;?>-modal-content">
                            <?php 
                            echo JHTML::_('content.prepare', $event->modal_content);
                            ?>
                        </p>
                    </div>

                </div>
            </div>
        <?php
        }
    }
}

// Definida customizacao da modal: carrega arquivo que aplica estilos
if(isset($modalCustomization)){
    require JModuleHelper::getLayoutPath($extensionName, 'style/modal');
}
?>
