    <?php
/**
 * @package			No Boss Extensions
 * @subpackage  	No Boss Calendar
 * @author			No Boss Technology <contact@nobosstechnology.com>
 * @copyright		Copyright (C) 2022 No Boss Technology. All rights reserved.
 * @license			GNU Lesser General Public License version 3 or later; see <https://www.gnu.org/licenses/lgpl-3.0.en.html>
 */

defined('_JEXEC') or die();
?>

<div class="nb-calendar" style="<?php echo ($custom->limit_maximum_width == '1') ? $custom->calendar_maximum_width : ''; ?>" data-now="<?php echo $date; ?>">
    <?php
    // Carrega cabecalho de meses
    require JModuleHelper::getLayoutPath($extensionName, 'common/month_header');

    // Sem eventos a exibir
    if(empty((array)$eventsSearch)){
        require JModuleHelper::getLayoutPath($extensionName, 'common/no_events');
    }
    // Exibe eventos do mes
    else { ?>
        <ul class="nb-calendar__body">
            <?php
            $count = 0;

            // Array para armazenar eventos com modal
            $arrayEventsModal = array();

            require JModuleHelper::getLayoutPath($extensionName, 'style/' . $theme . '_item');

            // Percorre eventos a exibir
            foreach ($eventsSearch as $event) {
                if(empty($event->indice)){
                    $event->indice = 0;
                }
                
                // Obtem datas de inicio e fim
                $dateIni = new JDate($event->initial_date);
                $dateFim = new JDate($event->final_date);

                ?>
                <li data-event-indice="<?php echo $event->indice; ?>" date-current="<?php echo $dateIni; ?>" class="nb-calendar__event <?php echo (($custom->events_link_display == 'card') && ($event->link_option == 'modal')) ? 'nb-calendar__event--has-modal-card' : ''; ?>"
                style='<?php echo (!empty($event->event_category->category_color)) ? "background-color: {$event->event_category->category_color};" : ''; ?> <?php echo !empty($event->event_text_color) ? "color: {$event->event_text_color};" : "color: {$custom->events_texts_color};"; ?>' <?php echo "module-item-id={$moduleName}_{$idModule}_{$date->month}_{$count}"; ?>>
                    
                    <?php
                    // Evento com link em todo card
                    if(($custom->events_link_display == 'card') && !empty($event->link) && ($event->link_option === 'external' || $event->link_option === 'internal')){ ?>
                        <a href="<?php echo $event->link; ?>" class="nb-event__link_card" target="<?php echo $event->link_target; ?>" title="<?php echo $event->link_title; ?>">
                    <?php
                    }
                    ?>

                    <div class="nb-event__content">
                        <?php // Categoria ?>
                        <?php if(!empty($event->event_category->id) && $event->event_category->id != "none" && !empty($event->event_category->show_in_legends) && $event->event_category->show_in_legends){ ?>
                            <div class="nb-event-legend" >
                                <span class="legend__tag" style='<?php echo $custom->events_title_font_family; ?> <?php echo "color: {$event->event_category->category_color};" ?>'><?php echo $event->event_category->legend; ?></span>
                            </div>
                        <?php } ?>

                        <?php // Datas ?>
                        <div class="nb-event__date" style='<?php echo $custom->events_date_style; ?>;'>
                            <?php // Data inicial ?>
                            <div class="nb-day__start" <?php echo $event->is_recurrent ? 'start-date-id="event-recurrent"' : '';?>>
                                <span class="nb-event__month" style='<?php echo $custom->events_title_font_family; ?> text-transform: <?php echo $custom->events_title_transform; ?>;'>
                                    <?php echo $dateIni->format('M'); ?>
                                </span>
                                <span class="nb-event__day" style='<?php echo $custom->events_title_font_family; ?> text-transform: <?php echo $custom->events_title_transform; ?>;'>
                                    <?php
                                        // Evento recorrente: exibe datas que ocorre no mes (exibido por default qnd vem todos eventos do mes listados, mas qnd usuario ve o evento clicando em uma data, exibe apenas o dia clicado via JS)
                                        if ($event->is_recurrent){
                                            echo implode(', ', $event->days);
                                        }
                                        // Evento normal
                                        else{
                                            echo $dateIni->format('d');
                                        }
                                    ?>
                                </span>
                            </div>

                            <?php 
                            // Data final diferente de data inicial e nao eh evento recorrente: exibe tb a data final
                            if (($dateIni != $dateFim) && (!$event->is_recurrent)){
                                ?>
                                <div class="nb-day__end">
                                    <span class="nb-event__month" style='<?php echo $custom->events_title_font_family; ?> text-transform: <?php echo $custom->events_title_transform; ?>;'>
                                        <?php
                                        if ($event->is_recurrent){
                                            echo $date->format('M');
                                        }
                                        // Evento normal
                                        else{
                                            echo $dateFim->format('M');
                                        }
                                        ?>
                                    </span>
                                    <span class="nb-event__day nb-event__day--last" style='<?php echo $custom->events_title_font_family; ?> text-transform: <?php echo $custom->events_title_transform; ?>;'>
                                        <?php
                                            echo $dateFim->format('d');
                                        ?>
                                    </span>
                                </div>
                                <?php
                            }
                            ?>
                        </div>

                        <?php // Titulo e descricao curta ?>
                        <div class="nb-event__infos">
                            <?php
                                // Titulo do evento
                                if (!empty(rtrim($event->event_title))) {
                                    echo "<{$custom->events_title_tag_html} class='nb-event__title' style='padding-top: 10px; {$custom->events_title_style}'>{$event->event_title}</{$custom->events_title_tag_html}>";
                                }
                            ?>
                            <?php
                                // Descricao curta
                                if (!empty(rtrim($event->event_subtitle))) {
                                    $event->event_subtitle = nl2br($event->event_subtitle);

                                    echo "<{$custom->events_subtitle_tag_html} class='nb-event__description' style='padding: 10px 0px; {$custom->events_subtitle_style}'>{$event->event_subtitle}</{$custom->events_subtitle_tag_html}>";
                                }
                            ?>
                        </div>

                        <?php
                        // Horarios
                        if(!empty($event->hours)){
                        ?>
                            <span class="nb-event__time" style='<?php echo $custom->events_schedule_style; ?>'>
                                <?php
                                // Percorre todos horarios do evento
                                foreach ($event->hours as $key => $hour) {
                                    // Se nao for o primeiro item, adiciona um separador
                                    if($key > 0){
                                        echo ' | ';
                                    }
                                    // Exibe da hora inicial
                                    if($custom->events_schedule_format == 'am-pm'){
                                        echo JFactory::getDate($hour->initial)->format('h:i A');
                                    }
                                    else{
                                        echo $hour->initial;
                                    }

                                    // Exibe hora final (caso seja diferente da inicial)
                                    if(!empty($hour->final) && ($hour->initial != $hour->final)){
                                        if($custom->events_schedule_format == 'am-pm'){
                                            echo ' - '.JFactory::getDate($hour->final)->format('h:i A');
                                        }
                                        else{
                                            echo ' - '.$hour->final;
                                        }
                                    }
                                }
                                ?>
                            </span>
                        <?php
                        }

                        // Local
                        if(!empty(rtrim($event->event_place))){
                            $event->event_place = nl2br($event->event_place);
                            ?>
                            <span class="nb-event__localization" <?php echo (!empty($event->event_place_link)) ? "data-link='{$event->event_place_link}'" : '';?> style='<?php echo $custom->events_subtitle_font_family; ?> <?php echo $custom->events_address_style; ?>'><?php echo  $event->event_place; ?></span>
                        <?php 
                        }

                        // Botao com link
                        if(($custom->events_link_display == 'button') && ($event->link_option != 'none')){
                            ?>
                            <div class="nb-event_button">
                                <?php
                                // Link normal
                                if (!empty($event->link) && ($event->link_option === 'external' || $event->link_option === 'internal')){
                                    ?>
                                    <a href="<?php echo $event->link; ?>" style='<?php echo $custom->button_style; ?>' target="<?php echo $event->link_target; ?>" title="<?php echo $event->link_title; ?>">
                                        <?php echo $custom->events_bt_text; ?>
                                    </a>
                                    <?php
                                }
                                // Link de modal
                                else{
                                    ?>
                                    <span class="nb-calendar__event--has-modal-button" style='<?php echo $custom->button_style; ?>'>
                                        <?php echo $custom->events_bt_text; ?>
                                    </span>
                                    <?php
                                }
                            ?>
                            </div>
                            <?php
                        }
                        ?>
                    </div>
                    <?php // Fecha link, caso definido para todo card ?>
                    <?php if(($custom->events_link_display == 'card') && !empty($event->link) && ($event->link_option === 'external' || $event->link_option === 'internal')){ ?>
                        </a>
                    <?php } ?>
                    </li>
                <?php

                // Evento possui modal de conteudo adicional
                if($event->link_option == 'modal' && !empty($event->modal_content)){
                    // Armazena id criado para o evento para saber na modal qual deve ser aberta
                    $event->moduleItemId = "{$moduleName}_{$idModule}_{$date->month}_{$count}";
                    $arrayEventsModal[] = $event;
                }
                $count++;
            }
            ?>
        </ul>
        <?php
    
        // Carrega modais de conteudo
        require JModuleHelper::getLayoutPath($extensionName, 'common/modal');
    }
    ?>
</div>
